/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ui.configuration.SdkDetector;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.SdkListModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Producer;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkListModelBuilder {
    @Nullable
    private final Project myProject;
    @NotNull
    private final ProjectSdksModel mySdkModel;
    @NotNull
    private final Condition<? super Sdk> mySdkFilter;
    @NotNull
    private final Condition<? super SdkTypeId> mySdkTypeFilter;
    @NotNull
    private final Condition<? super SdkTypeId> mySdkTypeCreationFilter;
    @NotNull
    private final EventDispatcher<ModelListener> myModelListener = EventDispatcher.create(ModelListener.class);
    private boolean mySuggestedItemsConnected = false;
    private boolean myIsSdkDetectorInProgress = false;
    private ImmutableList<SdkListItem.SdkItem> myHead = ImmutableList.of();
    private ImmutableList<SdkListItem.ActionItem> myDownloadActions = ImmutableList.of();
    private ImmutableList<SdkListItem.ActionItem> myAddActions = ImmutableList.of();
    private ImmutableList<SdkListItem.SuggestedItem> mySuggestions = ImmutableList.of();
    private SdkListItem.ProjectSdkItem myProjectSdkItem = null;
    private SdkListItem.NoneSdkItem myNoneSdkItem = null;
    private SdkListItem.InvalidSdkItem myInvalidItem = null;
    private ImmutableList<SdkListItem.SdkReferenceItem> myReferenceItems = ImmutableList.of();

    public SdkListModelBuilder(@Nullable Project project, @NotNull ProjectSdksModel sdkModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter2, @Nullable Condition<? super SdkTypeId> sdkTypeCreationFilter2, @Nullable Condition<? super Sdk> sdkFilter) {
        this.myProject = project;
        this.mySdkModel = sdkModel;
        this.mySdkTypeFilter = type -> type != null && (sdkTypeFilter2 == null || sdkTypeFilter2.value(type));
        Condition simpleJavaTypeFix = SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExists();
        this.mySdkTypeCreationFilter = type -> !(type == null || type instanceof SdkType && !((SdkType)type).allowCreationByUser() || !this.mySdkTypeFilter.value(type) || sdkTypeCreationFilter2 != null && !sdkTypeCreationFilter2.value(type) || !simpleJavaTypeFix.value(type));
        this.mySdkFilter = sdk2 -> sdk2 != null && this.mySdkTypeFilter.value((Object)sdk2.getSdkType()) && (sdkFilter == null || sdkFilter.value(sdk2));
    }

    public void addModelListener(@NotNull ModelListener listener2) {
        this.myModelListener.addListener((EventListener)listener2);
    }

    public void removeListener(@NotNull ModelListener listener2) {
        this.myModelListener.removeListener((EventListener)listener2);
    }

    @NotNull
    public SdkListItem.SdkReferenceItem addSdkReferenceItem(@NotNull SdkType type, @NotNull String name, @Nullable String versionString, boolean isValid) {
        SdkListItem.SdkReferenceItem element2 = new SdkListItem.SdkReferenceItem(type, name, versionString, isValid);
        this.removeSdkReferenceItem(element2);
        ImmutableList.Builder builder2 = ImmutableList.builder();
        builder2.addAll(this.myReferenceItems);
        builder2.add((Object)element2);
        this.myReferenceItems = builder2.build();
        this.syncModel();
        return element2;
    }

    public void removeSdkReferenceItem(@NotNull SdkListItem.SdkReferenceItem item) {
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (SdkListItem.SdkReferenceItem element2 : this.myReferenceItems) {
            if (Objects.equals(element2, item)) continue;
            builder2.add((Object)element2);
        }
        this.myReferenceItems = builder2.build();
        this.syncModel();
    }

    @NotNull
    private SdkListModel syncModel() {
        SdkListModel model = this.buildModel();
        ((ModelListener)this.myModelListener.getMulticaster()).syncModel(model);
        return model;
    }

    @NotNull
    public SdkListModel buildModel() {
        Sdk projectSdk;
        ImmutableList.Builder newModel = ImmutableList.builder();
        if (this.myNoneSdkItem != null) {
            newModel.add((Object)this.myNoneSdkItem);
        }
        if (this.myProjectSdkItem != null && ((projectSdk = this.mySdkModel.getProjectSdk()) == null || this.mySdkFilter.value((Object)projectSdk))) {
            newModel.add((Object)this.myProjectSdkItem);
        }
        if (this.myInvalidItem != null) {
            newModel.add((Object)this.myInvalidItem);
        }
        newModel.addAll(this.myReferenceItems);
        newModel.addAll(this.myHead);
        ImmutableList subItems = ImmutableList.builder().addAll(this.myDownloadActions).addAll(this.myAddActions).build();
        if (subItems.size() > 3 && !newModel.build().isEmpty()) {
            newModel.add((Object)new SdkListItem.GroupItem(AllIcons.General.Add, ProjectBundle.message((String)"combobox.item.add.sdk", (Object[])new Object[0]), (List<SdkListItem.ActionItem>)subItems));
        } else {
            newModel.addAll((Iterable)subItems);
        }
        for (SdkListItem.SuggestedItem item : this.mySuggestions) {
            if (!this.isApplicableSuggestedItem(item)) continue;
            newModel.add((Object)item);
        }
        return new SdkListModel(this.myIsSdkDetectorInProgress, (List<? extends SdkListItem>)newModel.build(), (Producer<? extends Sdk>)((Producer)() -> this.mySdkModel.getProjectSdk()));
    }

    private boolean isApplicableSuggestedItem(@NotNull SdkListItem.SuggestedItem item) {
        if (!this.mySdkTypeFilter.value((Object)item.getSdkType())) {
            return false;
        }
        for (Sdk sdk2 : this.mySdkModel.getSdks()) {
            if (!FileUtil.pathsEqual((String)sdk2.getHomePath(), (String)item.getHomePath())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public SdkListItem showProjectSdkItem() {
        SdkListItem.ProjectSdkItem projectSdkItem = new SdkListItem.ProjectSdkItem();
        if (Objects.equals(this.myProjectSdkItem, projectSdkItem)) {
            return this.myProjectSdkItem;
        }
        this.myProjectSdkItem = projectSdkItem;
        this.syncModel();
        return this.myProjectSdkItem;
    }

    @NotNull
    public SdkListItem showNoneSdkItem() {
        SdkListItem.NoneSdkItem noneSdkItem = new SdkListItem.NoneSdkItem();
        if (Objects.equals(this.myNoneSdkItem, noneSdkItem)) {
            return this.myNoneSdkItem;
        }
        this.myNoneSdkItem = noneSdkItem;
        this.syncModel();
        return this.myNoneSdkItem;
    }

    @NotNull
    public SdkListItem showInvalidSdkItem(@NotNull String name) {
        SdkListItem.InvalidSdkItem invalidItem = new SdkListItem.InvalidSdkItem(name);
        if (Objects.equals(this.myInvalidItem, invalidItem)) {
            return this.myInvalidItem;
        }
        this.myInvalidItem = invalidItem;
        this.syncModel();
        return this.myInvalidItem;
    }

    public void reloadSdks() {
        ImmutableList.Builder newHead = new ImmutableList.Builder();
        for (Sdk sdk2 : SdkListModelBuilder.sortSdks(this.mySdkModel.getSdks())) {
            if (!this.mySdkFilter.value((Object)sdk2)) continue;
            newHead.add((Object)this.newSdkItem(sdk2));
        }
        this.myHead = newHead.build();
        this.syncModel();
    }

    @NotNull
    private SdkListItem.SdkItem newSdkItem(@NotNull Sdk sdk2) {
        return new SdkListItem.SdkItem(sdk2){

            @Override
            boolean hasSameSdk(@NotNull Sdk value2) {
                return Objects.equals(this.getSdk(), value2) || Objects.equals(SdkListModelBuilder.this.mySdkModel.findSdk(this.getSdk()), value2);
            }
        };
    }

    public boolean executeAction(@NotNull JComponent parent, @NotNull SdkListItem item, @NotNull Consumer<? super SdkListItem> afterExecution) {
        Consumer onNewSdkAdded = sdk2 -> {
            this.reloadSdks();
            SdkListItem.SdkItem sdkItem = this.newSdkItem((Sdk)sdk2);
            afterExecution.consume((Object)sdkItem);
        };
        if (item instanceof SdkListItem.ActionItem) {
            ProjectSdksModel.NewSdkAction action2 = ((SdkListItem.ActionItem)item).myAction;
            action2.actionPerformed(null, parent, (Consumer<? super Sdk>)onNewSdkAdded);
            return true;
        }
        if (item instanceof SdkListItem.SuggestedItem) {
            SdkListItem.SuggestedItem suggestedItem = (SdkListItem.SuggestedItem)item;
            final String homePath = suggestedItem.getHomePath();
            ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, ProjectBundle.message((String)"progress.title.jdk.combo.box.resolving.jdk.home", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    indicator.setText(ProjectBundle.message((String)"progress.text.jdk.combo.box.resolving.jdk.home", (Object[])new Object[]{StringUtil.trimMiddle((String)homePath, (int)50)}));
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (File[])new File[]{new File(homePath)});
                }
            });
            this.mySdkModel.addSdk(suggestedItem.getSdkType(), homePath, (Consumer<? super Sdk>)onNewSdkAdded);
            return true;
        }
        return false;
    }

    public void processSelectedElement(@NotNull JComponent parent, @NotNull SdkListItem item, @NotNull Consumer<? super SdkListItem> afterNewItemAdded, @NotNull Consumer<? super SdkListItem> onSelectableItem) {
        if (!this.executeAction(parent, item, afterNewItemAdded)) {
            onSelectableItem.consume((Object)item);
        }
    }

    public void reloadActions() {
        Map<SdkType, ProjectSdksModel.NewSdkAction> downloadActions = this.mySdkModel.createDownloadActions(this.mySdkTypeCreationFilter);
        Map<SdkType, ProjectSdksModel.NewSdkAction> addActions = this.mySdkModel.createAddActions(this.mySdkTypeCreationFilter);
        this.myDownloadActions = SdkListModelBuilder.createActions(SdkListItem.ActionRole.DOWNLOAD, downloadActions);
        this.myAddActions = SdkListModelBuilder.createActions(SdkListItem.ActionRole.ADD, addActions);
        this.syncModel();
    }

    public void detectItems(@NotNull JComponent parent, @NotNull Disposable lifetime) {
        if (this.mySuggestedItemsConnected) {
            return;
        }
        this.mySuggestedItemsConnected = true;
        SdkDetector.getInstance().getDetectedSdksWithUpdate(this.myProject, lifetime, ModalityState.stateForComponent((Component)parent), new SdkDetector.DetectedSdkListener(){

            @Override
            public void onSearchStarted() {
                SdkListModelBuilder.this.mySuggestions = ImmutableList.of();
                SdkListModelBuilder.this.myIsSdkDetectorInProgress = true;
                SdkListModelBuilder.this.syncModel();
            }

            @Override
            public void onSdkDetected(@NotNull SdkType type, @NotNull String version2, @NotNull String home) {
                SdkListItem.SuggestedItem item = new SdkListItem.SuggestedItem(type, version2, home);
                SdkListModelBuilder.this.mySuggestions = ImmutableList.builder().addAll((Iterable)SdkListModelBuilder.this.mySuggestions).add((Object)item).build();
                SdkListModelBuilder.this.syncModel();
            }

            @Override
            public void onSearchCompleted() {
                SdkListModelBuilder.this.myIsSdkDetectorInProgress = false;
                SdkListModelBuilder.this.syncModel();
            }
        });
    }

    @NotNull
    private static ImmutableList<SdkListItem.ActionItem> createActions(@NotNull SdkListItem.ActionRole role, @NotNull Map<SdkType, ProjectSdksModel.NewSdkAction> actions) {
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (ProjectSdksModel.NewSdkAction action2 : actions.values()) {
            builder2.add((Object)new SdkListItem.ActionItem(role, action2, null));
        }
        return builder2.build();
    }

    private static Sdk @NotNull [] sortSdks(Sdk @NotNull [] sdks) {
        Sdk[] clone = (Sdk[])sdks.clone();
        Arrays.sort(clone, (sdk1, sdk2) -> {
            SdkType sdkType2;
            SdkType sdkType1 = (SdkType)sdk1.getSdkType();
            return !sdkType1.equals((Object)(sdkType2 = (SdkType)sdk2.getSdkType())) ? StringUtil.compare((String)sdkType1.getPresentableName(), (String)sdkType2.getPresentableName(), (boolean)true) : sdkType1.getComparator().compare(sdk1, sdk2);
        });
        return clone;
    }

    public static interface ModelListener
    extends EventListener {
        default public void syncModel(@NotNull SdkListModel model) {
        }
    }
}

