/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageDirectoryCache {
    private static final Logger LOG = Logger.getInstance(PackageDirectoryCache.class);
    private final MultiMap<String, VirtualFile> myRootsByPackagePrefix = MultiMap.create();
    private final Map<String, PackageInfo> myDirectoriesByPackageNameCache = new ConcurrentHashMap<String, PackageInfo>();
    private final Set<String> myNonExistentPackages = ContainerUtil.newConcurrentSet();

    public PackageDirectoryCache(@NotNull MultiMap<String, VirtualFile> rootsByPackagePrefix) {
        for (String prefix : rootsByPackagePrefix.keySet()) {
            for (VirtualFile file2 : rootsByPackagePrefix.get((Object)prefix)) {
                if (!file2.isValid()) {
                    LOG.error("Invalid root: " + file2);
                    continue;
                }
                this.myRootsByPackagePrefix.putValue((Object)prefix, (Object)file2);
            }
        }
    }

    void clear() {
        this.myNonExistentPackages.clear();
        this.myDirectoriesByPackageNameCache.clear();
    }

    public void onLowMemory() {
        this.myNonExistentPackages.clear();
    }

    @NotNull
    public List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName) {
        PackageInfo info = this.getPackageInfo(packageName);
        return info == null ? Collections.emptyList() : Collections.unmodifiableList(info.myPackageDirectories);
    }

    @Nullable
    private PackageInfo getPackageInfo(@NotNull String packageName) {
        PackageInfo info = this.myDirectoriesByPackageNameCache.get(packageName);
        if (info == null && !this.myNonExistentPackages.contains(packageName)) {
            if (packageName.length() > Registry.intValue((String)"java.max.package.name.length") || StringUtil.containsAnyChar((String)packageName, (String)";[/")) {
                return null;
            }
            SmartList result2 = new SmartList();
            if (StringUtil.isNotEmpty((String)packageName) && !StringUtil.startsWithChar((CharSequence)packageName, (char)'.')) {
                int i2 = packageName.lastIndexOf(46);
                while (true) {
                    PackageInfo parentInfo;
                    if ((parentInfo = this.getPackageInfo(i2 > 0 ? packageName.substring(0, i2) : "")) != null) {
                        result2.addAll(parentInfo.getSubPackageDirectories(packageName.substring(i2 + 1)));
                    }
                    if (i2 < 0) break;
                    i2 = packageName.lastIndexOf(46, i2 - 1);
                    ProgressManager.checkCanceled();
                }
            }
            for (VirtualFile file2 : this.myRootsByPackagePrefix.get((Object)packageName)) {
                if (!file2.isDirectory() || !file2.isValid()) continue;
                result2.add(file2);
            }
            if (!result2.isEmpty()) {
                info = new PackageInfo(packageName, (List<? extends VirtualFile>)result2);
                this.myDirectoriesByPackageNameCache.put(packageName, info);
            } else {
                this.myNonExistentPackages.add(packageName);
            }
        }
        return info;
    }

    @NotNull
    public Set<String> getSubpackageNames(@NotNull String packageName) {
        PackageInfo info = this.getPackageInfo(packageName);
        return info == null ? Collections.emptySet() : Collections.unmodifiableSet(((MultiMap)info.mySubPackages.getValue()).keySet());
    }

    @NotNull
    public Set<String> getSubpackageNames(@NotNull String packageName, @NotNull GlobalSearchScope scope) {
        PackageInfo info = this.getPackageInfo(packageName);
        if (info == null) {
            return Collections.emptySet();
        }
        HashSet<String> result2 = new HashSet<String>();
        for (Map.Entry entry : ((MultiMap)info.mySubPackages.getValue()).entrySet()) {
            String shortName = (String)entry.getKey();
            Collection directories = (Collection)entry.getValue();
            if (!ContainerUtil.exists((Iterable)directories, arg_0 -> ((GlobalSearchScope)scope).contains(arg_0))) continue;
            result2.add(shortName);
        }
        return Collections.unmodifiableSet(result2);
    }

    @NotNull
    public static PackageDirectoryCache createCache(@NotNull List<? extends VirtualFile> roots) {
        MultiMap map2 = MultiMap.create();
        map2.putValues((Object)"", roots);
        return new PackageDirectoryCache((MultiMap<String, VirtualFile>)map2);
    }

    protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
        return true;
    }

    private class PackageInfo {
        @NotNull
        final String myQname;
        @NotNull
        final List<? extends VirtualFile> myPackageDirectories;
        final NotNullLazyValue<MultiMap<String, VirtualFile>> mySubPackages = new VolatileNotNullLazyValue<MultiMap<String, VirtualFile>>(){

            @NotNull
            protected MultiMap<String, VirtualFile> compute() {
                MultiMap result2 = MultiMap.createLinked();
                for (VirtualFile virtualFile : PackageInfo.this.myPackageDirectories) {
                    ProgressManager.checkCanceled();
                    for (VirtualFile child2 : virtualFile.getChildren()) {
                        String packageName;
                        String childName = child2.getName();
                        String string = packageName = PackageInfo.this.myQname.isEmpty() ? childName : PackageInfo.this.myQname + "." + childName;
                        if (!child2.isDirectory() || !PackageDirectoryCache.this.isPackageDirectory(child2, packageName)) continue;
                        result2.putValue((Object)childName, (Object)child2);
                    }
                }
                return result2;
            }
        };

        PackageInfo(@NotNull String qname, List<? extends VirtualFile> packageDirectories) {
            this.myQname = qname;
            this.myPackageDirectories = packageDirectories;
        }

        @NotNull
        Collection<VirtualFile> getSubPackageDirectories(String shortName) {
            return ((MultiMap)this.mySubPackages.getValue()).get((Object)shortName);
        }
    }
}

