/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.InheritedJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleSourceOrderEntryImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.InvalidDataException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class OrderEntryFactory {
    OrderEntryFactory() {
    }

    @NotNull
    static OrderEntry createOrderEntryByElement(@NotNull Element element2, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        String type = element2.getAttributeValue("type");
        if (type == null) {
            throw new InvalidDataException();
        }
        switch (type) {
            case "sourceFolder": {
                return new ModuleSourceOrderEntryImpl(element2, rootModel);
            }
            case "jdk": {
                return new ModuleJdkOrderEntryImpl(element2, rootModel, projectRootManager);
            }
            case "inheritedJdk": {
                return new InheritedJdkOrderEntryImpl(element2, rootModel, projectRootManager);
            }
            case "library": {
                return new LibraryOrderEntryImpl(element2, rootModel, projectRootManager);
            }
            case "module-library": {
                return new ModuleLibraryOrderEntryImpl(element2, rootModel, projectRootManager);
            }
            case "module": {
                return new ModuleOrderEntryImpl(element2, rootModel);
            }
        }
        throw new InvalidDataException("Unknown order entry type:" + type);
    }

    @NotNull
    static Element createOrderEntryElement(@NotNull String type) {
        Element element2 = new Element("orderEntry");
        element2.setAttribute("type", type);
        return element2;
    }
}

