/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import gnu.trove.TIntHashSet;
import org.jetbrains.annotations.NotNull;

class OnlyOnceExceptionLogger {
    @NotNull
    private final Logger myLogger;
    @NotNull
    private final TIntHashSet myReportedHashes = new TIntHashSet();

    OnlyOnceExceptionLogger(@NotNull Logger logger) {
        this.myLogger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void info(@NotNull String message, @NotNull Throwable throwable) {
        boolean added;
        int hash = ThrowableInterner.computeHashCode((Throwable)throwable);
        TIntHashSet tIntHashSet = this.myReportedHashes;
        synchronized (tIntHashSet) {
            added = this.myReportedHashes.add(hash);
        }
        if (added) {
            this.myLogger.info(message + " (trace_hash = " + hash + ")", throwable);
        } else {
            this.myLogger.info(message + " (stacktrace has been already reported with trace_hash = " + hash + ")");
        }
    }
}

