/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LibraryOrderEntryBaseImpl
extends OrderEntryBaseImpl
implements LibraryOrSdkOrderEntry {
    private static final Logger LOG = Logger.getInstance(LibraryOrderEntryBaseImpl.class);
    final ProjectRootManagerImpl myProjectRootManagerImpl;
    @NotNull
    protected DependencyScope myScope = DependencyScope.COMPILE;
    @Nullable
    private RootProvider myCurrentlySubscribedRootProvider;

    LibraryOrderEntryBaseImpl(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        super(rootModel);
        this.myProjectRootManagerImpl = projectRootManager;
    }

    protected final void init() {
        this.updateFromRootProviderAndSubscribe();
    }

    public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType type) {
        return this.getRootFiles(type);
    }

    public String @NotNull [] getUrls(@NotNull OrderRootType type) {
        LOG.assertTrue(!this.getRootModel().getModule().isDisposed());
        return this.getRootUrls(type);
    }

    public VirtualFile @NotNull [] getRootFiles(@NotNull OrderRootType type) {
        RootProvider rootProvider = this.getRootProvider();
        return rootProvider == null ? VirtualFile.EMPTY_ARRAY : rootProvider.getFiles(type);
    }

    @Nullable
    protected abstract RootProvider getRootProvider();

    public String @NotNull [] getRootUrls(@NotNull OrderRootType type) {
        RootProvider rootProvider = this.getRootProvider();
        return rootProvider == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : rootProvider.getUrls(type);
    }

    @NotNull
    public final Module getOwnerModule() {
        return this.getRootModel().getModule();
    }

    void updateFromRootProviderAndSubscribe() {
        this.getRootModel().makeExternalChange(() -> this.resubscribe(this.getRootProvider()));
    }

    private void resubscribe(RootProvider wrapper2) {
        this.unsubscribe();
        this.subscribe(wrapper2);
    }

    private void subscribe(@Nullable RootProvider wrapper2) {
        if (wrapper2 != null) {
            this.myProjectRootManagerImpl.subscribeToRootProvider(this, wrapper2);
        }
        this.myCurrentlySubscribedRootProvider = wrapper2;
    }

    private void unsubscribe() {
        if (this.myCurrentlySubscribedRootProvider != null) {
            this.myProjectRootManagerImpl.unsubscribeFromRootProvider(this, this.myCurrentlySubscribedRootProvider);
        }
        this.myCurrentlySubscribedRootProvider = null;
    }

    @Override
    public void dispose() {
        this.unsubscribe();
        super.dispose();
    }
}

