/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPackageType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003JH\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2'\u0010\u0011\u001a#\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000fJ\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010\u001fJ\t\u0010 \u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "", "ideBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "expectedOS", "", "(Lcom/intellij/openapi/util/BuildNumber;Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "foldSubPredicates", "filter", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "emptyResult", "op", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "acc", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;ZLkotlin/jvm/functions/Function2;)Ljava/lang/Boolean;", "hashCode", "", "testJdkPackage", "pkg", "testJdkProduct", "product", "testPredicate", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Boolean;", "toString", "Companion", "intellij.platform.lang.impl"})
public final class JdkPredicate {
    private final BuildNumber ideBuildNumber;
    private final String expectedOS;
    public static final Companion Companion = new Companion(null);

    public final boolean testJdkProduct(@NotNull ObjectNode product) {
        JsonNode filterNode = product.get("filter");
        return Intrinsics.areEqual((Object)this.testPredicate(filterNode), (Object)true);
    }

    public final boolean testJdkPackage(@NotNull ObjectNode pkg) {
        JdkPackageType jdkPackageType;
        JsonNode jsonNode = pkg.get("os");
        if (Intrinsics.areEqual((Object)(jsonNode != null ? jsonNode.asText() : null), (Object)this.expectedOS) ^ true) {
            return false;
        }
        Object object = pkg.get("package_type");
        if (object != null && (object = object.asText()) != null) {
            Object object2 = object;
            JdkPackageType.Companion companion = JdkPackageType.Companion;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object2;
            boolean bl3 = false;
            jdkPackageType = companion.findType((String)p1);
        } else {
            jdkPackageType = null;
        }
        if (jdkPackageType == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.testPredicate(pkg.get("filter")), (Object)true);
    }

    @Nullable
    public final Boolean testPredicate(@Nullable JsonNode filter2) {
        if (filter2 == null) {
            return true;
        }
        if (filter2.isBoolean()) {
            return filter2.asBoolean();
        }
        if (!(filter2 instanceof ObjectNode)) {
            return null;
        }
        Object object = filter2.get("type");
        if (object == null || (object = object.asText()) == null) {
            return null;
        }
        Object type = object;
        if (Intrinsics.areEqual((Object)type, (Object)"or")) {
            return this.foldSubPredicates((ObjectNode)filter2, false, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)testPredicate.1.INSTANCE));
        }
        if (Intrinsics.areEqual((Object)type, (Object)"and")) {
            return this.foldSubPredicates((ObjectNode)filter2, true, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)testPredicate.2.INSTANCE));
        }
        if (Intrinsics.areEqual((Object)type, (Object)"not")) {
            Boolean bl = this.testPredicate(filter2.get("item"));
            if (bl == null) {
                return null;
            }
            boolean subResult = bl;
            return !subResult;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"const")) {
            JsonNode jsonNode = filter2.get("value");
            return jsonNode != null ? Boolean.valueOf(jsonNode.asBoolean()) : null;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"build_number_range")) {
            String untilBuild;
            JsonNode jsonNode = filter2.get("since");
            String fromBuild = jsonNode != null ? jsonNode.asText() : null;
            JsonNode jsonNode2 = filter2.get("until");
            String string = untilBuild = jsonNode2 != null ? jsonNode2.asText() : null;
            if (fromBuild == null && untilBuild == null) {
                return true;
            }
            if (fromBuild != null) {
                BuildNumber buildNumber = BuildNumber.fromStringOrNull((String)fromBuild);
                if (buildNumber == null) {
                    return null;
                }
                BuildNumber fromBuildSafe = buildNumber;
                if (fromBuildSafe.compareTo(this.ideBuildNumber) > 0) {
                    return false;
                }
            }
            if (untilBuild != null) {
                BuildNumber buildNumber = BuildNumber.fromStringOrNull((String)untilBuild);
                if (buildNumber == null) {
                    return null;
                }
                BuildNumber untilBuildSafe = buildNumber;
                if (this.ideBuildNumber.compareTo(untilBuildSafe) > 0) {
                    return false;
                }
            }
            return true;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean foldSubPredicates(ObjectNode filter2, boolean emptyResult, Function2<? super Boolean, ? super Boolean, Boolean> op) {
        void $this$fold$iv;
        JsonNode jsonNode = filter2.get("items");
        if (!(jsonNode instanceof ArrayNode)) {
            jsonNode = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        if (arrayNode == null) {
            return null;
        }
        ArrayNode items = arrayNode;
        if (items.isEmpty()) {
            return false;
        }
        Iterable iterable = (Iterable)items;
        Boolean initial$iv = emptyResult;
        boolean $i$f$fold = false;
        Boolean accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void subFilter;
            JsonNode jsonNode2 = (JsonNode)element$iv;
            boolean acc = accumulator$iv;
            boolean bl = false;
            Boolean bl2 = this.testPredicate((JsonNode)subFilter);
            if (bl2 == null) {
                return null;
            }
            boolean subResult = bl2;
            accumulator$iv = (boolean)((Boolean)op.invoke((Object)acc, (Object)subResult));
        }
        return accumulator$iv;
    }

    public JdkPredicate(@NotNull BuildNumber ideBuildNumber, @NotNull String expectedOS) {
        this.ideBuildNumber = ideBuildNumber;
        this.expectedOS = expectedOS;
    }

    private final BuildNumber component1() {
        return this.ideBuildNumber;
    }

    private final String component2() {
        return this.expectedOS;
    }

    @NotNull
    public final JdkPredicate copy(@NotNull BuildNumber ideBuildNumber, @NotNull String expectedOS) {
        return new JdkPredicate(ideBuildNumber, expectedOS);
    }

    public static /* synthetic */ JdkPredicate copy$default(JdkPredicate jdkPredicate, BuildNumber buildNumber, String string, int n, Object object) {
        if ((n & 1) != 0) {
            buildNumber = jdkPredicate.ideBuildNumber;
        }
        if ((n & 2) != 0) {
            string = jdkPredicate.expectedOS;
        }
        return jdkPredicate.copy(buildNumber, string);
    }

    @NotNull
    public String toString() {
        return "JdkPredicate(ideBuildNumber=" + this.ideBuildNumber + ", expectedOS=" + this.expectedOS + ")";
    }

    public int hashCode() {
        BuildNumber buildNumber = this.ideBuildNumber;
        String string = this.expectedOS;
        return (buildNumber != null ? buildNumber.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JdkPredicate)) break block3;
                JdkPredicate jdkPredicate = (JdkPredicate)object;
                if (!Intrinsics.areEqual((Object)this.ideBuildNumber, (Object)jdkPredicate.ideBuildNumber) || !Intrinsics.areEqual((Object)this.expectedOS, (Object)jdkPredicate.expectedOS)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate$Companion;", "", "()V", "createInstance", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final JdkPredicate createInstance() {
            String string;
            if (SystemInfo.isWindows) {
                string = "windows";
            } else if (SystemInfo.isMac) {
                string = "macOS";
            } else if (SystemInfo.isLinux) {
                string = "linux";
            } else {
                String string2 = "Unsupported OS";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String expectedOS = string;
            return new JdkPredicate(ApplicationInfoImpl.getShadowInstance().getBuild(), expectedOS);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

