/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.UnknownSdkType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectJdkTable", storages={@Storage(value="jdk.table.xml", roamingType=RoamingType.DISABLED, useSaveThreshold=ThreeState.NO)})
public class ProjectJdkTableImpl
extends ProjectJdkTable
implements ExportableComponent,
PersistentStateComponent<Element> {
    private final List<Sdk> mySdks = new ArrayList<Sdk>();
    @NonNls
    private static final String ELEMENT_JDK = "jdk";
    private final Map<String, ProjectJdkImpl> myCachedProjectJdks = new HashMap<String, ProjectJdkImpl>();

    public ProjectJdkTableImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){
            private final FileTypeManager myFileTypeManager = FileTypeManager.getInstance();

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (!events.isEmpty()) {
                    SmartHashSet affected = new SmartHashSet();
                    for (VFileEvent vFileEvent : events) {
                        this.addAffectedJavaSdk(vFileEvent, (Set<? super Sdk>)affected);
                    }
                    if (!affected.isEmpty()) {
                        for (Sdk sdk2 : affected) {
                            ((SdkType)sdk2.getSdkType()).setupSdkPaths(sdk2);
                        }
                    }
                }
            }

            private void addAffectedJavaSdk(VFileEvent event, Set<? super Sdk> affected) {
                CharSequence fileName = null;
                if (event instanceof VFileCreateEvent) {
                    if (((VFileCreateEvent)event).isDirectory()) {
                        return;
                    }
                    fileName = ((VFileCreateEvent)event).getChildName();
                } else {
                    VirtualFile file2 = event.getFile();
                    if (file2 != null && file2.isValid()) {
                        if (file2.isDirectory()) {
                            return;
                        }
                        fileName = file2.getNameSequence();
                    }
                }
                if (fileName == null) {
                    String eventPath = event.getPath();
                    fileName = VfsUtil.extractFileName((String)eventPath);
                }
                if (fileName != null && !ArchiveFileType.INSTANCE.equals(this.myFileTypeManager.getFileTypeByFileName(fileName))) {
                    return;
                }
                for (Sdk sdk2 : ProjectJdkTableImpl.this.mySdks) {
                    if (!(sdk2.getSdkType() instanceof JavaSdkType) || affected.contains(sdk2)) continue;
                    String homePath = sdk2.getHomePath();
                    String eventPath = event.getPath();
                    if (StringUtil.isEmpty((String)homePath) || !FileUtil.isAncestor((String)homePath, (String)eventPath, (boolean)true)) continue;
                    affected.add((Sdk)sdk2);
                }
            }
        });
        SdkType.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<SdkType>(){

            public void extensionAdded(@NotNull SdkType extension, @NotNull PluginDescriptor pluginDescriptor) {
                ProjectJdkTableImpl.this.loadSdkType(extension);
            }

            public void extensionRemoved(@NotNull SdkType extension, @NotNull PluginDescriptor pluginDescriptor) {
                ProjectJdkTableImpl.this.forgetSdkType(extension);
            }
        }, null);
    }

    private void loadSdkType(@NotNull SdkType newSdkType) {
        for (Sdk sdk2 : this.mySdks) {
            SdkTypeId sdkType = sdk2.getSdkType();
            if (!(sdkType instanceof UnknownSdkType) || !sdkType.getName().equals(newSdkType.getName()) || !(sdk2 instanceof ProjectJdkImpl)) continue;
            WriteAction.run(() -> {
                Element additionalData = ProjectJdkTableImpl.saveSdkAdditionalData(sdk2);
                ((ProjectJdkImpl)sdk2).changeType((SdkTypeId)newSdkType, additionalData);
            });
        }
    }

    private void forgetSdkType(@NotNull SdkType extension) {
        HashSet<Sdk> toRemove2 = new HashSet<Sdk>();
        for (Sdk sdk2 : this.mySdks) {
            SdkTypeId sdkType = sdk2.getSdkType();
            if (sdkType != extension) continue;
            if (sdk2 instanceof ProjectJdkImpl) {
                Element additionalDataElement = ProjectJdkTableImpl.saveSdkAdditionalData(sdk2);
                ((ProjectJdkImpl)sdk2).changeType((SdkTypeId)UnknownSdkType.getInstance((String)sdkType.getName()), additionalDataElement);
                continue;
            }
            toRemove2.add(sdk2);
        }
        for (Sdk sdk2 : toRemove2) {
            this.removeJdk(sdk2);
        }
    }

    @Nullable
    private static Element saveSdkAdditionalData(Sdk sdk2) {
        Element additionalDataElement;
        SdkAdditionalData additionalData = sdk2.getSdkAdditionalData();
        if (additionalData != null) {
            additionalDataElement = new Element("additional");
            sdk2.getSdkType().saveAdditionalData(additionalData, additionalDataElement);
        } else {
            additionalDataElement = null;
        }
        return additionalDataElement;
    }

    public File @NotNull [] getExportFiles() {
        return new File[]{PathManager.getOptionsFile((String)"jdk.table")};
    }

    @NotNull
    public String getPresentableName() {
        return ProjectBundle.message((String)"sdk.table.settings", (Object[])new Object[0]);
    }

    @Nullable
    public Sdk findJdk(@NotNull String name) {
        int len = this.mySdks.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Sdk jdk = this.mySdks.get(i2);
            if (!Comparing.strEqual((String)name, (String)jdk.getName())) continue;
            return jdk;
        }
        return null;
    }

    @Nullable
    public Sdk findJdk(@NotNull String name, @NotNull String type) {
        Sdk projectJdk = this.findJdk(name);
        if (projectJdk != null) {
            return projectJdk;
        }
        String uniqueName = type + "." + name;
        projectJdk = this.myCachedProjectJdks.get(uniqueName);
        if (projectJdk != null) {
            return projectJdk;
        }
        String jdkPrefix = "jdk.";
        String jdkPath = System.getProperty("jdk." + name);
        if (jdkPath == null) {
            return null;
        }
        SdkType sdkType = SdkType.findByName((String)type);
        if (sdkType != null && sdkType.isValidSdkHome(jdkPath)) {
            ProjectJdkImpl projectJdkImpl = new ProjectJdkImpl(name, (SdkTypeId)sdkType);
            projectJdkImpl.setHomePath(jdkPath);
            sdkType.setupSdkPaths((Sdk)projectJdkImpl);
            this.myCachedProjectJdks.put(uniqueName, projectJdkImpl);
            return projectJdkImpl;
        }
        return null;
    }

    public Sdk @NotNull [] getAllJdks() {
        return this.mySdks.toArray(new Sdk[0]);
    }

    @NotNull
    public List<Sdk> getSdksOfType(@NotNull SdkTypeId type) {
        Sdk[] sdks;
        ArrayList<Sdk> result2 = new ArrayList<Sdk>();
        for (Sdk sdk2 : sdks = this.getAllJdks()) {
            if (sdk2.getSdkType() != type) continue;
            result2.add(sdk2);
        }
        return result2;
    }

    public void addTestJdk(@NotNull Sdk jdk, @NotNull Disposable parentDisposable) {
        WriteAction.runAndWait(() -> this.mySdks.add(jdk));
        Disposer.register((Disposable)parentDisposable, () -> this.removeTestJdk(jdk));
    }

    public void removeTestJdk(@NotNull Sdk jdk) {
        WriteAction.runAndWait(() -> this.mySdks.remove(jdk));
    }

    public void addJdk(@NotNull Sdk jdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.mySdks.add(jdk);
        ((ProjectJdkTable.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JDK_TABLE_TOPIC)).jdkAdded(jdk);
    }

    public void removeJdk(@NotNull Sdk jdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ((ProjectJdkTable.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JDK_TABLE_TOPIC)).jdkRemoved(jdk);
        this.mySdks.remove(jdk);
        if (jdk instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)jdk));
        }
    }

    public void updateJdk(@NotNull Sdk originalJdk, @NotNull Sdk modifiedJdk) {
        String previousName = originalJdk.getName();
        String newName = modifiedJdk.getName();
        ((ProjectJdkImpl)modifiedJdk).copyTo((ProjectJdkImpl)originalJdk);
        if (!previousName.equals(newName)) {
            ((ProjectJdkTable.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JDK_TABLE_TOPIC)).jdkNameChanged(originalJdk, previousName);
        }
    }

    @NotNull
    public SdkTypeId getDefaultSdkType() {
        return UnknownSdkType.getInstance((String)"");
    }

    @NotNull
    public SdkTypeId getSdkTypeByName(@NotNull String sdkTypeName) {
        return ProjectJdkTableImpl.findSdkTypeByName(sdkTypeName);
    }

    @NotNull
    private static SdkTypeId findSdkTypeByName(@NotNull String sdkTypeName) {
        SdkType[] allSdkTypes;
        for (SdkType type : allSdkTypes = SdkType.getAllTypes()) {
            if (!type.getName().equals(sdkTypeName)) continue;
            return type;
        }
        return UnknownSdkType.getInstance((String)sdkTypeName);
    }

    @NotNull
    public Sdk createSdk(@NotNull String name, @NotNull SdkTypeId sdkType) {
        return new ProjectJdkImpl(name, sdkType);
    }

    public void loadState(@NotNull Element element2) {
        this.mySdks.clear();
        for (Element child2 : element2.getChildren(ELEMENT_JDK)) {
            ProjectJdkImpl jdk = new ProjectJdkImpl(null, null);
            jdk.readExternal(child2, this);
            this.mySdks.add(jdk);
        }
    }

    public Element getState() {
        Element element2 = new Element("state");
        for (Sdk jdk : this.mySdks) {
            if (!(jdk instanceof ProjectJdkImpl)) continue;
            Element e = new Element(ELEMENT_JDK);
            ((ProjectJdkImpl)jdk).writeExternal(e);
            element2.addContent(e);
        }
        return element2;
    }
}

