/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHomeFinderBasic {
    private final Logger LOG = Logger.getInstance(this.getClass());
    private final List<Supplier<Set<String>>> myFinders = new ArrayList<Supplier<Set<String>>>();

    JavaHomeFinderBasic(boolean forceEmbeddedJava, String ... paths) {
        this.myFinders.add(this::checkDefaultLocations);
        this.myFinders.add(this::findInPATH);
        this.myFinders.add(() -> this.findInSpecifiedPaths(paths));
        this.myFinders.add(this::findJavaInstalledBySdkMan);
        if (forceEmbeddedJava || Registry.is((String)"java.detector.include.embedded", (boolean)false)) {
            this.myFinders.add(() -> this.scanAll(JavaHomeFinderBasic.getJavaHome(), false));
        }
    }

    @NotNull
    private Set<String> findInSpecifiedPaths(String[] paths) {
        return this.scanAll(Stream.of(paths).map(it -> new File((String)it)).collect(Collectors.toList()), true);
    }

    protected void registerFinder(@NotNull Supplier<Set<String>> finder) {
        this.myFinders.add(finder);
    }

    @NotNull
    public final Set<String> findExistingJdks() {
        TreeSet<String> result2 = new TreeSet<String>();
        for (Supplier<Set<String>> action2 : this.myFinders) {
            try {
                result2.addAll((Collection<String>)action2.get());
            }
            catch (Exception e) {
                this.LOG.warn("Failed to find Java Home. " + e.getMessage(), (Throwable)e);
            }
        }
        return result2;
    }

    @NotNull
    private Set<String> findInPATH() {
        try {
            String pathVarString = EnvironmentUtil.getValue((String)"PATH");
            if (pathVarString == null || pathVarString.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<File> dirsToCheck = new HashSet<File>();
            for (String p : pathVarString.split(File.pathSeparator)) {
                File parentFile;
                File dir = new File(p);
                if (!StringUtilRt.equal((CharSequence)dir.getName(), (CharSequence)"bin", (boolean)SystemInfo.isFileSystemCaseSensitive) || (parentFile = dir.getParentFile()) == null) continue;
                dirsToCheck.addAll(this.listPossibleJdkInstallRootsFromHomes(parentFile));
            }
            return this.scanAll(dirsToCheck, false);
        }
        catch (Exception e) {
            this.LOG.warn("Failed to scan PATH for JDKs. " + e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    @NotNull
    private Set<String> checkDefaultLocations() {
        if (ApplicationManager.getApplication() == null) {
            return Collections.emptySet();
        }
        HashSet<File> paths = new HashSet<File>();
        paths.add(JdkInstaller.getInstance().defaultInstallDir());
        for (Sdk jdk : ProjectJdkTable.getInstance().getAllJdks()) {
            String homePath;
            if (!(jdk.getSdkType() instanceof JavaSdkType) || jdk.getSdkType() instanceof DependentSdkType || (homePath = jdk.getHomePath()) == null) continue;
            paths.addAll(this.listPossibleJdkInstallRootsFromHomes(new File(homePath)));
        }
        return this.scanAll(paths, true);
    }

    @NotNull
    protected Set<String> scanAll(@Nullable File file2, boolean includeNestDirs) {
        if (file2 == null) {
            return Collections.emptySet();
        }
        return this.scanAll(Collections.singleton(file2), includeNestDirs);
    }

    @NotNull
    protected Set<String> scanAll(@NotNull Collection<File> files2, boolean includeNestDirs) {
        HashSet<String> result2 = new HashSet<String>();
        for (File root : new HashSet<File>(files2)) {
            this.scanFolder(root, includeNestDirs, result2);
        }
        return result2;
    }

    private void scanFolder(@NotNull File folder, boolean includeNestDirs, @NotNull Collection<? super String> result2) {
        if (JdkUtil.checkForJdk((File)folder)) {
            result2.add(folder.getAbsolutePath());
            return;
        }
        if (!includeNestDirs) {
            return;
        }
        File[] files2 = folder.listFiles();
        if (files2 == null) {
            return;
        }
        for (File candidate : files2) {
            for (File adjusted : this.listPossibleJdkHomesFromInstallRoot(candidate)) {
                this.scanFolder(adjusted, false, result2);
            }
        }
    }

    @NotNull
    protected List<File> listPossibleJdkHomesFromInstallRoot(@NotNull File file2) {
        return Collections.singletonList(file2);
    }

    @NotNull
    protected List<File> listPossibleJdkInstallRootsFromHomes(@NotNull File file2) {
        return Collections.singletonList(file2);
    }

    @Nullable
    protected static File getJavaHome() {
        String property = SystemProperties.getJavaHome();
        if (property == null) {
            return null;
        }
        File javaHome = new File(property).getParentFile();
        return javaHome == null || !javaHome.isDirectory() ? null : javaHome;
    }

    @NotNull
    private Set<String> findJavaInstalledBySdkMan() {
        File candidatesDir = JavaHomeFinderBasic.findSdkManCandidatesDir();
        if (candidatesDir == null) {
            return Collections.emptySet();
        }
        File javasDir = new File(candidatesDir, "java");
        if (javasDir.isDirectory()) {
            return this.scanAll(javasDir, true);
        }
        return Collections.emptySet();
    }

    @Nullable
    private static File findSdkManCandidatesDir() {
        File homeDir;
        File primaryDir;
        File candidatesDir;
        String homePath;
        File candidatesDir2;
        File primaryDir2;
        File candidatesDir3;
        String candidatesPath = EnvironmentUtil.getValue((String)"SDKMAN_CANDIDATES_DIR");
        if (candidatesPath != null && (candidatesDir3 = new File(candidatesPath)).isDirectory()) {
            return candidatesDir3;
        }
        String primaryPath = EnvironmentUtil.getValue((String)"SDKMAN_DIR");
        if (primaryPath != null && (primaryDir2 = new File(primaryPath)).isDirectory() && (candidatesDir2 = new File(primaryDir2, "candidates")).isDirectory()) {
            return candidatesDir2;
        }
        if (!SystemInfo.isWindows && (homePath = System.getProperty("user.home")) != null && (candidatesDir = new File(primaryDir = new File(homeDir = new File(homePath), ".sdkman"), "candidates")).isDirectory()) {
            return candidatesDir;
        }
        return null;
    }
}

