/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.internal.statistic.IdeActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceAlternativeResolveTracker;
import com.intellij.openapi.project.DumbServiceAppIconProgress;
import com.intellij.openapi.project.DumbServiceBalloon;
import com.intellij.openapi.project.DumbServiceGuiTaskQueue;
import com.intellij.openapi.project.DumbServiceHeavyActivities;
import com.intellij.openapi.project.DumbServiceMergingTaskQueue;
import com.intellij.openapi.project.DumbServiceSyncTaskQueue;
import com.intellij.openapi.project.DumbServiceVfsBatchListener;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.TrackedEdtActivityService;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.util.containers.Queue;
import com.intellij.util.exception.FrequentErrorLogger;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.ui.DeprecationStripePanel;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumbServiceImpl
extends DumbService
implements Disposable,
ModificationTracker,
DumbServiceBalloon.Service {
    private static final ExtensionPointName<StartupActivity.RequiredForSmartMode> REQUIRED_FOR_SMART_MODE_STARTUP_ACTIVITY = new ExtensionPointName("com.intellij.requiredForSmartModeStartupActivity");
    private static final Logger LOG = Logger.getInstance(DumbServiceImpl.class);
    private static final FrequentErrorLogger ourErrorLogger = FrequentErrorLogger.newInstance((Logger)LOG);
    private final AtomicReference<State> myState;
    private volatile Throwable myDumbEnterTrace;
    private volatile Throwable myDumbStart;
    private final DumbService.DumbModeListener myPublisher;
    private long myModificationCount;
    private final Queue<Runnable> myRunWhenSmartQueue = new Queue(5);
    private final Project myProject;
    private final TrackedEdtActivityService myTrackedEdtActivityService;
    private final DumbServiceMergingTaskQueue myTaskQueue;
    private final DumbServiceGuiTaskQueue myGuiDumbTaskRunner;
    private final DumbServiceSyncTaskQueue mySyncDumbTaskRunner;
    private final DumbServiceHeavyActivities myHeavyActivities;
    private final DumbServiceAlternativeResolveTracker myAlternativeResolveTracker;
    private final DumbServiceBalloon myBalloon;

    public DumbServiceImpl(Project project) {
        this.myProject = project;
        this.myTrackedEdtActivityService = new TrackedEdtActivityService(project);
        this.myTaskQueue = new DumbServiceMergingTaskQueue();
        this.myGuiDumbTaskRunner = new DumbServiceGuiTaskQueue(this.myProject, this.myTaskQueue);
        this.mySyncDumbTaskRunner = new DumbServiceSyncTaskQueue(this.myTaskQueue);
        this.myPublisher = (DumbService.DumbModeListener)project.getMessageBus().syncPublisher(DUMB_MODE);
        this.myHeavyActivities = new DumbServiceHeavyActivities();
        new DumbServiceVfsBatchListener(this.myProject, this.myHeavyActivities);
        this.myBalloon = new DumbServiceBalloon(project, this);
        this.myAlternativeResolveTracker = new DumbServiceAlternativeResolveTracker();
        this.myState = new AtomicReference<State>(project.isDefault() ? State.SMART : State.WAITING_PROJECT_SMART_MODE_STARTUP_TASKS);
    }

    void queueStartupActivitiesRequiredForSmartMode() {
        LOG.assertTrue(this.myState.compareAndSet(State.WAITING_PROJECT_SMART_MODE_STARTUP_TASKS, State.RUNNING_PROJECT_SMART_MODE_STARTUP_TASKS), (Object)("actual state: " + (Object)((Object)this.myState.get()) + ", project " + this.getProject()));
        List activities = REQUIRED_FOR_SMART_MODE_STARTUP_ACTIVITY.getExtensionList();
        if (activities.isEmpty()) {
            this.myState.set(State.SMART);
        } else {
            for (StartupActivity.RequiredForSmartMode activity : activities) {
                activity.runActivity(this.getProject());
            }
            if (DumbServiceImpl.isSynchronousTaskExecution()) {
                this.myState.set(State.SMART);
            }
        }
    }

    public static DumbServiceImpl getInstance(@NotNull Project project) {
        return (DumbServiceImpl)DumbService.getInstance((Project)project);
    }

    public void cancelTask(@NotNull DumbModeTask task2) {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("cancel " + task2);
        }
        this.myTaskQueue.cancelTask(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ApplicationManager.getApplication().assertIsWriteThread();
        this.myBalloon.dispose();
        Queue<Runnable> queue = this.myRunWhenSmartQueue;
        synchronized (queue) {
            this.myRunWhenSmartQueue.clear();
        }
        this.myTaskQueue.disposePendingTasks();
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isAlternativeResolveEnabled() {
        return this.myAlternativeResolveTracker.isAlternativeResolveEnabled();
    }

    public void suspendIndexingAndRun(@NotNull String activityName, @NotNull Runnable activity) {
        this.myHeavyActivities.suspendIndexingAndRun(activityName, activity);
    }

    public boolean isSuspendedDumbMode() {
        boolean suspended = this.myHeavyActivities.isSuspended();
        return this.isDumb() && suspended;
    }

    public void setAlternativeResolveEnabled(boolean enabled) {
        this.myAlternativeResolveTracker.setAlternativeResolveEnabled(enabled);
    }

    public ModificationTracker getModificationTracker() {
        return this;
    }

    @Override
    public boolean isDumb() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed() && Registry.is((String)"ide.check.is.dumb.contract")) {
            ourErrorLogger.error("To avoid race conditions isDumb method should be used only under read action or in EDT thread.", (Throwable)new IllegalStateException());
        }
        return this.myState.get() != State.SMART;
    }

    public void setDumb(boolean dumb) {
        if (dumb) {
            this.myState.set(State.RUNNING_DUMB_TASKS);
            this.myPublisher.enteredDumbMode();
        } else {
            this.myState.set(State.WAITING_FOR_FINISH);
            this.updateFinished();
        }
    }

    public void runInDumbMode(@NotNull Runnable runnable2) {
        this.setDumb(true);
        try {
            runnable2.run();
        }
        finally {
            this.setDumb(false);
        }
    }

    @Override
    public void runWhenSmart(@Async.Schedule @NotNull Runnable runnable2) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> this.unsafeRunWhenSmart(runnable2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsafeRunWhenSmart(@NotNull @Async.Schedule Runnable runnable2) {
        Queue<Runnable> queue = this.myRunWhenSmartQueue;
        synchronized (queue) {
            if (this.isDumb()) {
                this.myRunWhenSmartQueue.addLast((Object)ClientId.decorateRunnable((Runnable)runnable2));
                return;
            }
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            runnable2.run();
        } else {
            app.invokeLater(() -> this.unsafeRunWhenSmart(runnable2), ModalityState.NON_MODAL, this.myProject.getDisposed());
        }
    }

    public void queueTask(@NotNull DumbModeTask task2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling task " + task2);
        }
        if (this.myProject.isDefault()) {
            LOG.error("No indexing tasks should be created for default project: " + task2);
        }
        if (DumbServiceImpl.isSynchronousTaskExecution()) {
            this.mySyncDumbTaskRunner.runTaskSynchronously(task2);
        } else {
            this.queueAsynchronousTask(task2);
        }
    }

    @VisibleForTesting
    private void queueAsynchronousTask(@NotNull DumbModeTask task2) {
        Throwable trace = new Throwable();
        ModalityState modality = ModalityState.defaultModalityState();
        Runnable runnable2 = () -> this.queueTaskOnEdt(task2, modality, trace);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable2.run();
        } else {
            TransactionGuard.submitTransaction((Disposable)this.myProject, (Runnable)runnable2);
        }
    }

    private void queueTaskOnEdt(@NotNull DumbModeTask task2, @NotNull ModalityState modality, @NotNull Throwable trace) {
        this.myTaskQueue.addTask(task2);
        State state = this.myState.get();
        if (state == State.WAITING_PROJECT_SMART_MODE_STARTUP_TASKS) {
            return;
        }
        if (state == State.SMART || state == State.WAITING_FOR_FINISH || state == State.RUNNING_PROJECT_SMART_MODE_STARTUP_TASKS) {
            this.enterDumbMode(modality, trace);
            this.myTrackedEdtActivityService.invokeLaterIfProjectNotDisposed(this::startBackgroundProcess);
        }
    }

    private void enterDumbMode(@NotNull ModalityState modality, @NotNull Throwable trace) {
        boolean wasSmart = !this.isDumb();
        WriteAction.run(() -> {
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                this.myState.set(State.SCHEDULED_TASKS);
            }
            this.myDumbStart = trace;
            this.myDumbEnterTrace = new Throwable();
            this.myTrackedEdtActivityService.setDumbStartModality(modality);
            ++this.myModificationCount;
        });
        if (wasSmart) {
            try {
                this.myPublisher.enteredDumbMode();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private void queueUpdateFinished() {
        if (this.myState.compareAndSet(State.RUNNING_DUMB_TASKS, State.WAITING_FOR_FINISH)) {
            this.myHeavyActivities.resetCurrentSuspender();
            this.myTrackedEdtActivityService.invokeLaterAfterProjectInitialized(this::updateFinished);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchToSmartMode() {
        Queue<Runnable> queue = this.myRunWhenSmartQueue;
        synchronized (queue) {
            if (!this.myState.compareAndSet(State.WAITING_FOR_FINISH, State.SMART)) {
                return false;
            }
        }
        StartUpMeasurer.compareAndSetCurrentState((LoadingState)LoadingState.PROJECT_OPENED, (LoadingState)LoadingState.INDEXING_FINISHED);
        this.myDumbEnterTrace = null;
        this.myDumbStart = null;
        ++this.myModificationCount;
        return !this.myProject.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFinished() {
        if (!((Boolean)WriteAction.compute(this::switchToSmartMode)).booleanValue()) {
            return;
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("updateFinished");
        }
        try {
            this.myPublisher.exitDumbMode();
            FileEditorManagerEx.getInstanceEx(this.myProject).refreshIcons();
        }
        finally {
            while (!this.isDumb()) {
                Runnable runnable2;
                Queue<Runnable> queue = this.myRunWhenSmartQueue;
                synchronized (queue) {
                    if (this.myRunWhenSmartQueue.isEmpty()) {
                        break;
                    }
                    runnable2 = (Runnable)this.myRunWhenSmartQueue.pullFirst();
                }
                DumbServiceImpl.doRun(runnable2);
            }
        }
    }

    private static void doRun(@Async.Execute Runnable runnable2) {
        try {
            runnable2.run();
        }
        catch (ProcessCanceledException e) {
            LOG.error("Task canceled: " + runnable2, new Attachment[]{new Attachment("pce", (Throwable)e)});
        }
        catch (Throwable e) {
            LOG.error("Error executing task " + runnable2, e);
        }
    }

    public void showDumbModeNotification(@NotNull @NlsContexts.PopupContent String message) {
        UIUtil.invokeLaterIfNeeded(() -> {
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
            if (ideFrame != null) {
                ((StatusBarEx)ideFrame.getStatusBar()).notifyProgressByBalloon(MessageType.WARNING, message);
            }
        });
    }

    public void showDumbModeActionBalloon(@NotNull @NlsContexts.PopupContent String balloonText, @NotNull Runnable runWhenSmartAndBalloonStillShowing) {
        this.myBalloon.showDumbModeActionBalloon(balloonText, runWhenSmartAndBalloonStillShowing);
    }

    public void cancelAllTasksAndWait() {
        Application application = ApplicationManager.getApplication();
        if (!application.isWriteThread() || application.isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Must be called on write thread without write action");
        }
        while (this.myState.get() != State.SMART && this.myState.get() != State.WAITING_PROJECT_SMART_MODE_STARTUP_TASKS && !this.myProject.isDisposed()) {
            LockSupport.parkNanos(50000000L);
            this.myTrackedEdtActivityService.executeAllQueuedActivities();
            this.myTaskQueue.cancelAllTasks();
            this.myHeavyActivities.resumeProgressIfPossible();
        }
    }

    public void waitForSmartMode() {
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed() || application.isDispatchThread()) {
            throw new AssertionError((Object)"Don't invoke waitForSmartMode from inside read action in dumb mode");
        }
        while (this.myState.get() != State.SMART && !this.myProject.isDisposed()) {
            LockSupport.parkNanos(50000000L);
            ProgressManager.checkCanceled();
        }
    }

    public JComponent wrapGently(@NotNull JComponent dumbUnawareContent, @NotNull Disposable parentDisposable) {
        final DumbUnawareHider wrapper2 = new DumbUnawareHider(dumbUnawareContent);
        wrapper2.setContentVisible(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                wrapper2.setContentVisible(false);
            }

            public void exitDumbMode() {
                wrapper2.setContentVisible(true);
            }
        });
        return wrapper2;
    }

    public JComponent wrapWithSpoiler(@NotNull JComponent dumbAwareContent, final @NotNull Runnable updateRunnable, @NotNull Disposable parentDisposable) {
        final DeprecationStripePanel stripePanel = new DeprecationStripePanel(IdeBundle.message((String)"dumb.mode.spoiler.wrapper.text", (Object[])new Object[0]), AllIcons.General.Warning).withAlternativeAction(IdeBundle.message((String)"dumb.mode.spoiler.wrapper.reload.text", (Object[])new Object[0]), (AnAction)new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                updateRunnable.run();
            }
        });
        stripePanel.setVisible(this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                stripePanel.setVisible(true);
                updateRunnable.run();
            }

            public void exitDumbMode() {
                stripePanel.setVisible(false);
                updateRunnable.run();
            }
        });
        return stripePanel.wrap(dumbAwareContent);
    }

    public void smartInvokeLater(@NotNull Runnable runnable2) {
        this.smartInvokeLater(runnable2, ModalityState.defaultModalityState());
    }

    public void smartInvokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDumb()) {
                this.runWhenSmart(() -> this.smartInvokeLater(runnable2, modalityState));
            } else {
                runnable2.run();
            }
        }, modalityState, this.myProject.getDisposed());
    }

    public void completeJustSubmittedTasks() {
        ApplicationManager.getApplication().assertIsWriteThread();
        assert (this.myProject.isInitialized());
        if (this.myState.get() != State.SCHEDULED_TASKS) {
            return;
        }
        while (this.isDumb()) {
            this.assertState(State.SCHEDULED_TASKS);
            this.showModalProgress();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showModalProgress() {
        NoAccessDuringPsiEvents.checkCallContext("modal indexing");
        try {
            ((ApplicationImpl)ApplicationManager.getApplication()).executeSuspendingWriteAction(this.myProject, IndexingBundle.message((String)"progress.indexing", (Object[])new Object[0]), () -> {
                this.assertState(State.SCHEDULED_TASKS);
                this.runBackgroundProcess(ProgressManager.getInstance().getProgressIndicator());
                this.assertState(State.SMART, State.WAITING_FOR_FINISH);
            });
            this.assertState(State.SMART, State.WAITING_FOR_FINISH);
            if (this.myState.get() == State.SMART) return;
        }
        catch (Throwable throwable) {
            if (this.myState.get() == State.SMART) throw throwable;
            this.assertState(State.WAITING_FOR_FINISH);
            this.updateFinished();
            this.assertState(State.SMART, State.SCHEDULED_TASKS);
            throw throwable;
        }
        this.assertState(State.WAITING_FOR_FINISH);
        this.updateFinished();
        this.assertState(State.SMART, State.SCHEDULED_TASKS);
    }

    private void assertState(State ... expected) {
        State state = this.myState.get();
        List<State> expectedList = Arrays.asList(expected);
        if (!expectedList.contains((Object)state)) {
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            if (this.myDumbEnterTrace != null) {
                attachments.add(new Attachment("indexingStart", this.myDumbEnterTrace));
            }
            attachments.add(new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString()));
            throw new RuntimeExceptionWithAttachments("Internal error, please include thread dump attachment. Expected " + expectedList + ", but was " + state.toString(), attachments.toArray(Attachment.EMPTY_ARRAY));
        }
    }

    private void startBackgroundProcess() {
        try {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, IndexingBundle.message((String)"progress.indexing", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator visibleIndicator) {
                    DumbServiceImpl.this.runBackgroundProcess(visibleIndicator);
                }
            });
        }
        catch (Throwable e) {
            this.queueUpdateFinished();
            LOG.error("Failed to start background index update task", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBackgroundProcess(final @NotNull ProgressIndicator visibleIndicator) {
        block18: {
            ((ProgressManagerImpl)ProgressManager.getInstance()).markProgressSafe((UserDataHolder)visibleIndicator);
            if (!this.myState.compareAndSet(State.SCHEDULED_TASKS, State.RUNNING_DUMB_TASKS)) {
                return;
            }
            try (ProgressSuspender suspender = ProgressSuspender.markSuspendable(visibleIndicator, "Indexing paused");){
                this.myHeavyActivities.setCurrentSuspenderAndSuspendIfRequested(suspender);
                IdeActivity activity = IdeActivity.started((Project)this.myProject, (String)"indexing");
                ShutDownTracker shutdownTracker = ShutDownTracker.getInstance();
                Thread self = Thread.currentThread();
                try {
                    shutdownTracker.registerStopperThread(self);
                    DumbServiceAppIconProgress.registerForProgress(this.myProject, (ProgressIndicatorEx)visibleIndicator);
                    this.myGuiDumbTaskRunner.processTasksWithProgress(taskIndicator -> {
                        suspender.attachToProgress((ProgressIndicatorEx)taskIndicator);
                        taskIndicator.addStateDelegate(new AbstractProgressIndicatorExBase(){

                            @Override
                            protected void delegateProgressChange(@NotNull AbstractProgressIndicatorExBase.IndicatorAction action2) {
                                super.delegateProgressChange(action2);
                                action2.execute((ProgressIndicatorEx)visibleIndicator);
                            }
                        });
                    }, activity);
                }
                catch (Throwable unexpected) {
                    try {
                        LOG.error(unexpected);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        shutdownTracker.unregisterStopperThread(self);
                        this.myHeavyActivities.resetCurrentSuspender();
                        this.queueUpdateFinished();
                        activity.finished();
                    }
                }
                shutdownTracker.unregisterStopperThread(self);
                this.myHeavyActivities.resetCurrentSuspender();
                this.queueUpdateFinished();
                activity.finished();
            }
        }
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Nullable
    public Throwable getDumbModeStartTrace() {
        return this.myDumbStart;
    }

    private static boolean isSynchronousTaskExecution() {
        Application application = ApplicationManager.getApplication();
        return (application.isUnitTestMode() || application.isHeadlessEnvironment()) && !Boolean.parseBoolean(System.getProperty("idea.force.dumb.queue.tasks", "false"));
    }

    private static enum State {
        SMART,
        SCHEDULED_TASKS,
        RUNNING_DUMB_TASKS,
        WAITING_FOR_FINISH,
        WAITING_PROJECT_SMART_MODE_STARTUP_TASKS,
        RUNNING_PROJECT_SMART_MODE_STARTUP_TASKS;

    }
}

