/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class SmoothProgressAdapter
extends AbstractProgressIndicatorExBase
implements ProgressIndicatorEx,
WrappedProgressIndicator,
StandardProgressIndicator {
    private static final int SHOW_DELAY = 500;
    private Future<?> myStartupAlarm = CompletableFuture.completedFuture(null);
    private final ProgressIndicator myOriginal;
    private final Project myProject;
    private volatile boolean myOriginalStarted;
    private DialogWrapper myDialog;
    private final Runnable myShowRequest = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SmoothProgressAdapter.this.getLock();
            synchronized (object) {
                if (!SmoothProgressAdapter.this.isRunning()) {
                    return;
                }
                SmoothProgressAdapter.this.myOriginal.start();
                SmoothProgressAdapter.this.myOriginalStarted = true;
                SmoothProgressAdapter.this.myOriginal.setText(SmoothProgressAdapter.this.getText());
                SmoothProgressAdapter.this.myOriginal.setFraction(SmoothProgressAdapter.this.getFraction());
                SmoothProgressAdapter.this.myOriginal.setText2(SmoothProgressAdapter.this.getText2());
            }
        }
    };

    public SmoothProgressAdapter(@NotNull ProgressIndicator original, @NotNull Project project) {
        this.myOriginal = original;
        this.myProject = project;
        if (this.myOriginal.isModal()) {
            this.myOriginal.setModalityProgress((ProgressIndicator)this);
            this.setModalityProgress(this);
        }
        ProgressManager.assertNotCircular((ProgressIndicator)original);
        if (original.isRunning() || original.isCanceled()) {
            throw new IllegalArgumentException("Original indicator must be not started and not cancelled: " + original);
        }
    }

    @NotNull
    public ProgressIndicator getOriginalProgressIndicator() {
        return this.myOriginal;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.myOriginal.setIndeterminate(indeterminate);
    }

    @Override
    public boolean isIndeterminate() {
        return this.myOriginal.isIndeterminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isRunning()) {
                return;
            }
            super.start();
            this.myOriginalStarted = false;
            this.myStartupAlarm = AppExecutorUtil.getAppScheduledExecutorService().schedule(this.myShowRequest, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void startBlocking() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.start();
        if (this.isModal()) {
            this.showDialog();
        }
    }

    private void showDialog() {
        if (this.myDialog == null) {
            this.myDialog = new DialogWrapper(this.myProject, false){
                {
                    this.getWindow().setBounds(0, 0, 1, 1);
                    this.setResizable(false);
                }

                protected boolean isProgressDialog() {
                    return true;
                }

                protected JComponent createCenterPanel() {
                    return null;
                }
            };
            this.myDialog.setModal(true);
            this.myDialog.setUndecorated(true);
            this.myDialog.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.myOriginal.isRunning()) {
                this.myOriginalStarted = true;
                this.myOriginal.stop();
            }
            this.myStartupAlarm.cancel(false);
            Semaphore semaphore = new Semaphore();
            semaphore.down();
            SwingUtilities.invokeLater(() -> {
                if (!this.myOriginalStarted && this.myOriginal instanceof Disposable) {
                    Disposer.dispose((Disposable)((Disposable)this.myOriginal));
                }
                semaphore.waitFor();
                if (this.myDialog != null) {
                    this.myDialog.close(0);
                    this.myDialog = null;
                }
            });
            try {
                super.stop();
            }
            finally {
                semaphore.up();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String text) {
        Object object = this.getLock();
        synchronized (object) {
            super.setText(text);
            if (this.myOriginal.isRunning()) {
                this.myOriginal.setText(text);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFraction(double fraction) {
        Object object = this.getLock();
        synchronized (object) {
            super.setFraction(fraction);
            if (this.myOriginal.isRunning()) {
                this.myOriginal.setFraction(fraction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText2(String text) {
        Object object = this.getLock();
        synchronized (object) {
            super.setText2(text);
            if (this.myOriginal.isRunning()) {
                this.myOriginal.setText2(text);
            }
        }
    }

    @Override
    public final void cancel() {
        super.cancel();
        this.myOriginal.cancel();
    }

    @Override
    public final boolean isCanceled() {
        return super.isCanceled() || this.myOriginalStarted && this.myOriginal.isCanceled();
    }
}

