/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public final class ProgressIndicatorUtils {
    private static final Logger LOG = Logger.getInstance(ProgressIndicatorUtils.class);
    private static final List<Runnable> ourWACancellations = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress2, @NotNull Disposable parentDisposable) {
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action2) {
                if (progress2.isRunning()) {
                    progress2.cancel();
                }
            }
        }, parentDisposable);
        return progress2;
    }

    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task2) {
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(false, false), task2);
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull ProgressIndicator progressIndicator2, @NotNull ReadTask readTask) {
        return ProgressIndicatorUtils.scheduleWithWriteActionPriority(progressIndicator2, PooledThreadExecutor.INSTANCE, readTask);
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2, @Nullable ProgressIndicator progressIndicator2) {
        Ref result2 = new Ref((Object)Boolean.FALSE);
        ProgressIndicatorUtils.runWithWriteActionPriority(() -> result2.set((Object)ApplicationManagerEx.getApplicationEx().tryRunReadAction(action2)), progressIndicator2 == null ? new ProgressIndicatorBase(false, false) : progressIndicator2);
        return (Boolean)result2.get();
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2) {
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action2, null);
    }

    public static boolean runWithWriteActionPriority(@NotNull Runnable action2, @NotNull ProgressIndicator progressIndicator2) {
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            throw new IllegalStateException("Must not call from EDT");
        }
        Runnable cancellation2 = ProgressIndicatorUtils.indicatorCancellation(progressIndicator2);
        if (ProgressIndicatorUtils.isWriting(application)) {
            cancellation2.run();
            return false;
        }
        return (Boolean)ProgressManager.getInstance().runProcess(() -> {
            try {
                return ProgressIndicatorUtils.runActionAndCancelBeforeWrite(application, cancellation2, action2);
            }
            catch (ProcessCanceledException ignore) {
                return false;
            }
        }, progressIndicator2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static boolean runActionAndCancelBeforeWrite(@NotNull ApplicationEx application, @NotNull Runnable cancellation2, @NotNull Runnable action2) {
        if (ProgressIndicatorUtils.isWriting(application)) {
            cancellation2.run();
            return false;
        }
        ourWACancellations.add(cancellation2);
        try {
            if (ProgressIndicatorUtils.isWriting(application)) {
                cancellation2.run();
                boolean bl = false;
                return bl;
            }
            action2.run();
            boolean bl = true;
            return bl;
        }
        finally {
            ourWACancellations.remove(cancellation2);
        }
    }

    @NotNull
    private static Runnable indicatorCancellation(@NotNull ProgressIndicator progressIndicator2) {
        return () -> {
            if (!progressIndicator2.isCanceled()) {
                progressIndicator2.cancel();
            }
        };
    }

    private static boolean isWriting(ApplicationEx application) {
        return application.isWriteActionPending() || application.isWriteActionInProgress();
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(final @NotNull ProgressIndicator progressIndicator2, @NotNull Executor executor, final @NotNull ReadTask readTask) {
        final CompletableFuture future2 = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (application.isDisposed() || progressIndicator2.isCanceled() || future2.isCancelled()) {
                future2.complete(null);
                return;
            }
            final Disposable listenerDisposable = Disposer.newDisposable();
            ApplicationListener listener2 = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action2) {
                    if (!progressIndicator2.isCanceled()) {
                        progressIndicator2.cancel();
                        readTask.onCanceled(progressIndicator2);
                    }
                }
            };
            application.addApplicationListener(listener2, listenerDisposable);
            future2.whenComplete((__, ___) -> Disposer.dispose((Disposable)listenerDisposable));
            try {
                executor.execute(ClientId.decorateRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ReadTask.Continuation continuation;
                        try {
                            continuation = ProgressIndicatorUtils.runUnderProgress(progressIndicator2, readTask);
                        }
                        catch (Throwable e) {
                            future2.completeExceptionally(e);
                            throw e;
                        }
                        if (continuation == null) {
                            future2.complete(null);
                        } else if (!future2.isCancelled()) {
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (future2.isCancelled()) {
                                        return;
                                    }
                                    Disposer.dispose((Disposable)listenerDisposable);
                                    try {
                                        if (!progressIndicator2.isCanceled()) {
                                            continuation.getAction().run();
                                        }
                                    }
                                    finally {
                                        future2.complete(null);
                                    }
                                }

                                public String toString() {
                                    return "continuation of " + readTask;
                                }
                            }, continuation.getModalityState());
                        }
                    }

                    public String toString() {
                        return readTask.toString();
                    }
                }));
            }
            catch (Throwable e) {
                future2.completeExceptionally(e);
                throw e;
            }
        }, ModalityState.any());
        return future2;
    }

    private static ReadTask.Continuation runUnderProgress(@NotNull ProgressIndicator progressIndicator2, @NotNull ReadTask task2) {
        return (ReadTask.Continuation)ProgressManager.getInstance().runProcess(() -> {
            try {
                return task2.runBackgroundProcess(progressIndicator2);
            }
            catch (ProcessCanceledException ignore) {
                return null;
            }
        }, progressIndicator2);
    }

    public static void yieldToPendingWriteActions() {
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            throw new IllegalStateException("Mustn't be called from within read action");
        }
        if (application.isDispatchThread()) {
            throw new IllegalStateException("Mustn't be called from EDT");
        }
        Semaphore semaphore = new Semaphore(1);
        application.invokeLater(() -> ((Semaphore)semaphore).up(), ModalityState.any());
        ProgressIndicatorUtils.awaitWithCheckCanceled(semaphore, ProgressIndicatorProvider.getGlobalProgressIndicator());
    }

    @Nullable
    public static <T> T withTimeout(long timeoutMs, @NotNull Computable<T> computation) {
        ProgressManager.checkCanceled();
        ProgressIndicator outer = ProgressIndicatorProvider.getGlobalProgressIndicator();
        AbstractProgressIndicatorBase inner = outer != null ? new SensitiveProgressWrapper(outer) : new ProgressIndicatorBase(false, false);
        AtomicBoolean canceledByTimeout = new AtomicBoolean();
        ScheduledFuture<?> cancelProgress = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            canceledByTimeout.set(true);
            inner.cancel();
        }, timeoutMs, TimeUnit.MILLISECONDS);
        try {
            Object object = ProgressManager.getInstance().runProcess(computation, (ProgressIndicator)inner);
            return (T)object;
        }
        catch (ProcessCanceledException e) {
            if (canceledByTimeout.get()) {
                T t = null;
                return t;
            }
            throw e;
        }
        finally {
            cancelProgress.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithLockAndCheckingCanceled(@NotNull Lock lock, int timeout, @NotNull TimeUnit timeUnit, @NotNull ThrowableComputable<T, E> computable) throws E, ProcessCanceledException {
        ProgressIndicatorUtils.awaitWithCheckCanceled(lock, timeout, timeUnit);
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    public static void awaitWithCheckCanceled(@NotNull CountDownLatch waiter) {
        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable<Boolean, ? extends Exception>)((ThrowableComputable)() -> waiter.await(10L, TimeUnit.MILLISECONDS)));
    }

    public static <T> T awaitWithCheckCanceled(@NotNull Future<T> future2) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return ProgressIndicatorUtils.awaitWithCheckCanceled(future2, indicator);
    }

    public static <T> T awaitWithCheckCanceled(@NotNull Future<T> future2, @Nullable ProgressIndicator indicator) {
        while (true) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled(indicator);
            try {
                return future2.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException | TimeoutException exception) {
                continue;
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)cause;
                }
                if (cause instanceof CancellationException) {
                    throw new ProcessCanceledException(cause);
                }
                ExceptionUtil.rethrow((Throwable)e);
                continue;
            }
            break;
        }
    }

    public static void awaitWithCheckCanceled(@NotNull Lock lock, int timeout, @NotNull TimeUnit timeUnit) {
        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable<Boolean, ? extends Exception>)((ThrowableComputable)() -> lock.tryLock(timeout, timeUnit)));
    }

    public static void awaitWithCheckCanceled(@NotNull ThrowableComputable<Boolean, ? extends Exception> waiter) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        boolean success = false;
        while (!success) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled(indicator);
            try {
                success = (Boolean)waiter.compute();
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedException)) {
                    LOG.warn((Throwable)e);
                }
                throw new ProcessCanceledException((Throwable)e);
            }
        }
    }

    public static void checkCancelledEvenWithPCEDisabled(@Nullable ProgressIndicator indicator) {
        if (indicator != null && indicator.isCanceled()) {
            indicator.checkCanceled();
            throw new ProcessCanceledException();
        }
    }

    public static void awaitWithCheckCanceled(@NotNull Semaphore semaphore, @Nullable ProgressIndicator indicator) {
        while (!semaphore.waitFor(10L)) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled(indicator);
        }
    }

    static {
        Application app = ApplicationManager.getApplication();
        app.addApplicationListener(new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action2) {
                for (Runnable cancellation2 : ourWACancellations) {
                    cancellation2.run();
                }
            }
        }, (Disposable)app);
    }
}

