/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.WeakList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractProgressIndicatorExBase
extends AbstractProgressIndicatorBase
implements ProgressIndicatorEx {
    private final boolean myReusable;
    private volatile ProgressIndicatorEx @Nullable [] myStateDelegates;
    private volatile WeakList<TaskInfo> myFinished;
    private volatile boolean myWasStarted;
    private TaskInfo myOwnerTask;

    public AbstractProgressIndicatorExBase(boolean reusable) {
        this.myReusable = reusable;
    }

    public AbstractProgressIndicatorExBase() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.getLock();
        synchronized (object) {
            super.start();
            this.delegateRunningChange(ProgressIndicator::start);
            this.myWasStarted = true;
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.delegateRunningChange(ProgressIndicator::stop);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.delegateRunningChange(ProgressIndicator::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(@NotNull TaskInfo task2) {
        WeakList finished2 = this.myFinished;
        if (finished2 == null) {
            Object object = this.getLock();
            synchronized (object) {
                finished2 = this.myFinished;
                if (finished2 == null) {
                    this.myFinished = finished2 = new WeakList();
                }
            }
        }
        if (!finished2.addIfAbsent((Object)task2)) {
            return;
        }
        this.delegateRunningChange(each -> each.finish(task2));
    }

    @Override
    public boolean isFinished(@NotNull TaskInfo task2) {
        WeakList<TaskInfo> list2 = this.myFinished;
        return list2 != null && list2.contains(task2);
    }

    protected void setOwnerTask(TaskInfo owner) {
        this.myOwnerTask = owner;
    }

    @Override
    public void processFinish() {
        if (this.myOwnerTask != null) {
            this.finish(this.myOwnerTask);
            this.myOwnerTask = null;
        }
    }

    @Override
    public final void checkCanceled() {
        super.checkCanceled();
        this.delegate(ProgressIndicator::checkCanceled);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.delegateProgressChange(each -> each.setText(text));
    }

    @Override
    public void setText2(String text) {
        super.setText2(text);
        this.delegateProgressChange(each -> each.setText2(text));
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.delegateProgressChange(each -> each.setFraction(fraction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushState() {
        Object object = this.getLock();
        synchronized (object) {
            super.pushState();
            this.delegateProgressChange(ProgressIndicator::pushState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popState() {
        Object object = this.getLock();
        synchronized (object) {
            super.popState();
            this.delegateProgressChange(ProgressIndicator::popState);
        }
    }

    @Override
    protected boolean isReuseable() {
        return this.myReusable;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.delegateProgressChange(each -> each.setIndeterminate(indeterminate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        Object object = this.getLock();
        synchronized (object) {
            delegate.initStateFrom(this);
            Object[] stateDelegates = this.myStateDelegates;
            if (stateDelegates == null) {
                this.myStateDelegates = new ProgressIndicatorEx[]{delegate};
            } else {
                if (ArrayUtil.contains((Object)delegate, (Object[])stateDelegates)) {
                    throw new IllegalArgumentException("Already registered: " + delegate);
                }
                this.myStateDelegates = (ProgressIndicatorEx[])ArrayUtil.append((Object[])stateDelegates, (Object)delegate, ProgressIndicatorEx.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeStateDelegate(@NotNull ProgressIndicatorEx delegate) {
        Object object = this.getLock();
        synchronized (object) {
            Object[] delegates = this.myStateDelegates;
            if (delegates == null) {
                return;
            }
            this.myStateDelegates = (ProgressIndicatorEx[])ArrayUtil.remove((Object[])delegates, (Object)delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeAllStateDelegates() {
        Object object = this.getLock();
        synchronized (object) {
            this.myStateDelegates = null;
        }
    }

    protected void delegateProgressChange(@NotNull IndicatorAction action2) {
        this.delegate(action2);
        this.onProgressChange();
    }

    protected void delegateRunningChange(@NotNull IndicatorAction action2) {
        this.delegate(action2);
        this.onRunningChange();
    }

    private void delegate(@NotNull IndicatorAction action2) {
        ProgressIndicatorEx[] list2 = this.myStateDelegates;
        if (list2 != null) {
            for (ProgressIndicatorEx each : list2) {
                action2.execute(each);
            }
        }
    }

    @Override
    public void initStateFrom(@NotNull ProgressIndicator indicator) {
        super.initStateFrom(indicator);
        this.delegate(it -> it.initStateFrom(this));
    }

    protected void onProgressChange() {
    }

    protected void onRunningChange() {
    }

    @Override
    public boolean wasStarted() {
        return this.myWasStarted;
    }

    @FunctionalInterface
    protected static interface IndicatorAction {
        public void execute(@NotNull ProgressIndicatorEx var1);
    }
}

