/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundableProcessIndicator
extends ProgressWindow {
    protected StatusBarEx myStatusBar;
    private PerformInBackgroundOption myOption;
    private TaskInfo myInfo;
    private boolean myDidInitializeOnEdt = false;
    private boolean myDisposed;

    public BackgroundableProcessIndicator(@NotNull Task.Backgroundable task2) {
        this(task2.getProject(), (TaskInfo)task2, (PerformInBackgroundOption)task2);
    }

    public BackgroundableProcessIndicator(@Nullable Project project, @NotNull TaskInfo info, @NotNull PerformInBackgroundOption option2) {
        this(project, info, option2, null);
    }

    @VisibleForTesting
    BackgroundableProcessIndicator(@Nullable Project project, @NotNull TaskInfo info, @NotNull PerformInBackgroundOption option2, @Nullable StatusBarEx statusBarOverride) {
        super(info.isCancellable(), true, project, null, info.getCancelText());
        this.setOwnerTask(info);
        this.myOption = option2;
        this.myInfo = info;
        this.myStatusBar = statusBarOverride;
        this.myBackgrounded = this.shouldStartInBackground();
        UIUtil.invokeLaterIfNeeded(() -> this.initializeStatusBar());
    }

    @Override
    protected void initializeOnEdtIfNeeded() {
        super.initializeOnEdtIfNeeded();
        this.initializeStatusBar();
    }

    private void initializeStatusBar() {
        if (this.myDisposed || this.myDidInitializeOnEdt) {
            return;
        }
        this.myDidInitializeOnEdt = true;
        this.setTitle(this.myInfo.getTitle());
        if (this.myStatusBar == null) {
            Project nonDefaultProject = this.myProject == null || this.myProject.isDisposed() || this.myProject.isDefault() ? null : this.myProject;
            IdeFrameEx frame = WindowManagerEx.getInstanceEx().findFrameHelper(nonDefaultProject);
            this.myStatusBar = frame != null ? (StatusBarEx)frame.getStatusBar() : null;
        }
        this.myBackgrounded &= this.myStatusBar != null;
        if (this.myBackgrounded) {
            this.doBackground(this.myStatusBar);
        }
    }

    private boolean shouldStartInBackground() {
        return Registry.is((String)"ide.background.tasks") || this.myOption.shouldStartInBackground();
    }

    public BackgroundableProcessIndicator(@Nullable Project project, final @NlsContexts.ProgressTitle String progressTitle, @NotNull PerformInBackgroundOption option2, final @Nullable @NlsContexts.Button String cancelButtonText, final @NlsContexts.Tooltip String backgroundStopTooltip, final boolean cancellable) {
        this(project, new TaskInfo(){

            @NotNull
            public String getTitle() {
                return progressTitle;
            }

            public String getCancelText() {
                return cancelButtonText;
            }

            public String getCancelTooltipText() {
                return backgroundStopTooltip;
            }

            public boolean isCancellable() {
                return cancellable;
            }
        }, option2);
    }

    @Override
    protected void showDialog() {
        if (this.myDisposed) {
            return;
        }
        this.initializeOnEdtIfNeeded();
        if (this.shouldStartInBackground() && this.myStatusBar != null) {
            return;
        }
        super.showDialog();
    }

    @Override
    public void background() {
        if (this.myDisposed) {
            return;
        }
        assert (this.myDidInitializeOnEdt) : "Call to background action before showing dialog";
        this.myOption.processSentToBackground();
        this.doBackground(this.myStatusBar);
        super.background();
    }

    private void doBackground(@Nullable StatusBarEx statusBar) {
        if (statusBar != null) {
            statusBar.addProgress(this, this.myInfo);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myDisposed = true;
        this.myInfo = null;
        this.myStatusBar = null;
        this.myOption = null;
    }

    @Override
    public boolean isShowing() {
        return this.isModal() || !this.isBackgrounded();
    }

    @Override
    public String toString() {
        return super.toString() + "; task=" + this.myInfo;
    }
}

