/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebReferencesAnnotatorBase
extends ExternalAnnotator<MyInfo[], MyInfo[]> {
    private static final Logger LOG = Logger.getInstance(WebReferencesAnnotatorBase.class);
    private final Map<String, MyFetchCacheEntry> myFetchCache = new HashMap<String, MyFetchCacheEntry>();
    private final Object myFetchCacheLock = new Object();
    private static final long FETCH_CACHE_TIMEOUT = 10000L;
    protected static final WebReference[] EMPTY_ARRAY = new WebReference[0];

    protected abstract WebReference @NotNull [] collectWebReferences(@NotNull PsiFile var1);

    @Nullable
    protected static WebReference lookForWebReference(@NotNull PsiElement element2) {
        return WebReferencesAnnotatorBase.lookForWebReference(Arrays.asList(element2.getReferences()));
    }

    @Nullable
    private static WebReference lookForWebReference(Collection<PsiReference> references) {
        for (PsiReference reference2 : references) {
            WebReference webReference;
            if (reference2 instanceof WebReference) {
                return (WebReference)reference2;
            }
            if (!(reference2 instanceof PsiDynaReference) || (webReference = WebReferencesAnnotatorBase.lookForWebReference(((PsiDynaReference)reference2).getReferences())) == null) continue;
            return webReference;
        }
        return null;
    }

    public MyInfo[] collectInformation(@NotNull PsiFile file2) {
        WebReference[] references = this.collectWebReferences(file2);
        MyInfo[] infos = new MyInfo[references.length];
        for (int i2 = 0; i2 < infos.length; ++i2) {
            WebReference reference2 = references[i2];
            infos[i2] = new MyInfo(PsiAnchor.create(reference2.getElement()), reference2.getRangeInElement(), reference2.getValue());
        }
        return infos;
    }

    public MyInfo[] doAnnotate(MyInfo[] infos) {
        MyFetchResult[] fetchResults = new MyFetchResult[infos.length];
        for (int i2 = 0; i2 < fetchResults.length; ++i2) {
            fetchResults[i2] = this.checkUrl(infos[i2].myUrl);
        }
        boolean containsAvailableHosts = false;
        for (MyFetchResult fetchResult : fetchResults) {
            if (fetchResult == MyFetchResult.UNKNOWN_HOST) continue;
            containsAvailableHosts = true;
            break;
        }
        for (int i3 = 0; i3 < fetchResults.length; ++i3) {
            MyFetchResult result2 = fetchResults[i3];
            if (result2 != MyFetchResult.OK && (containsAvailableHosts || result2 != MyFetchResult.UNKNOWN_HOST)) continue;
            infos[i3].myResult = true;
        }
        return infos;
    }

    public void apply(@NotNull PsiFile file2, MyInfo[] infos, @NotNull AnnotationHolder holder) {
        if (infos == null || infos.length == 0) {
            return;
        }
        HighlightDisplayLevel displayLevel = this.getHighlightDisplayLevel((PsiElement)file2);
        for (MyInfo info : infos) {
            PsiElement element2;
            if (info.myResult || (element2 = info.myAnchor.retrieve()) == null) continue;
            int start2 = element2.getTextRange().getStartOffset();
            TextRange range2 = new TextRange(start2 + info.myRangeInElement.getStartOffset(), start2 + info.myRangeInElement.getEndOffset());
            String message = this.getErrorMessage(info.myUrl);
            AnnotationBuilder builder2 = holder.newAnnotation(displayLevel.getSeverity(), message).range(range2);
            for (IntentionAction action2 : this.getQuickFixes()) {
                builder2 = builder2.withFix(action2);
            }
            builder2.create();
        }
    }

    @NotNull
    protected abstract String getErrorMessage(@NotNull String var1);

    protected IntentionAction @NotNull [] getQuickFixes() {
        return IntentionAction.EMPTY_ARRAY;
    }

    @NotNull
    protected abstract HighlightDisplayLevel getHighlightDisplayLevel(@NotNull PsiElement var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private MyFetchResult checkUrl(String url) {
        Object object = this.myFetchCacheLock;
        synchronized (object) {
            MyFetchCacheEntry entry = this.myFetchCache.get(url);
            long currentTime = System.currentTimeMillis();
            if (entry != null && currentTime - entry.getTime() < 10000L) {
                return entry.getFetchResult();
            }
            MyFetchResult fetchResult = WebReferencesAnnotatorBase.doCheckUrl(url);
            this.myFetchCache.put(url, new MyFetchCacheEntry(currentTime, fetchResult));
            return fetchResult;
        }
    }

    private static MyFetchResult doCheckUrl(@NotNull String url) {
        if (url.startsWith("mailto")) {
            return MyFetchResult.OK;
        }
        try {
            HttpRequests.request((String)url).connectTimeout(3000).readTimeout(3000).tryConnect();
        }
        catch (UnknownHostException e) {
            LOG.info((Throwable)e);
            return MyFetchResult.UNKNOWN_HOST;
        }
        catch (HttpRequests.HttpStatusException e) {
            LOG.info((Throwable)e);
            return MyFetchResult.NONEXISTENCE;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Throwable)e);
        }
        return MyFetchResult.OK;
    }

    protected static class MyInfo {
        final PsiAnchor myAnchor;
        final String myUrl;
        final TextRange myRangeInElement;
        volatile boolean myResult;

        private MyInfo(PsiAnchor anchor2, TextRange rangeInElement, String url) {
            this.myAnchor = anchor2;
            this.myRangeInElement = rangeInElement;
            this.myUrl = url;
        }
    }

    private static enum MyFetchResult {
        OK,
        UNKNOWN_HOST,
        NONEXISTENCE;

    }

    private static class MyFetchCacheEntry {
        private final long myTime;
        private final MyFetchResult myFetchResult;

        private MyFetchCacheEntry(long time, @NotNull MyFetchResult fetchResult) {
            this.myTime = time;
            this.myFetchResult = fetchResult;
        }

        public long getTime() {
            return this.myTime;
        }

        @NotNull
        public MyFetchResult getFetchResult() {
            return this.myFetchResult;
        }
    }
}

