/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurableVisitor
implements Predicate<Configurable> {
    public static final Predicate<Configurable> ALL = configurable2 -> true;

    @Override
    public boolean test(Configurable configurable2) {
        return this.accept(configurable2);
    }

    protected abstract boolean accept(@NotNull Configurable var1);

    @Nullable
    public final Configurable find(ConfigurableGroup ... groups) {
        return ConfigurableVisitor.find((Predicate<Configurable>)this, Arrays.asList(groups));
    }

    @Nullable
    public static Configurable findById(@NotNull String id2, @NotNull List<? extends ConfigurableGroup> groups) {
        return ConfigurableVisitor.find((Configurable configurable2) -> id2.equals(ConfigurableVisitor.getId(configurable2)), groups);
    }

    @Nullable
    public static Configurable findByType(@NotNull Class<? extends Configurable> type, @NotNull List<? extends ConfigurableGroup> groups) {
        return ConfigurableVisitor.find((Configurable configurable2) -> ConfigurableWrapper.cast(type, (UnnamedConfigurable)configurable2) != null, groups);
    }

    @Nullable
    public static Configurable find(@NotNull Predicate<Configurable> visitor, @NotNull List<? extends ConfigurableGroup> groups) {
        for (ConfigurableGroup configurableGroup : groups) {
            Configurable result2 = ConfigurableVisitor.find(visitor, configurableGroup.getConfigurables());
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Configurable find(@NotNull Predicate<Configurable> visitor, Configurable @NotNull [] configurables) {
        for (Configurable configurable2 : configurables) {
            if (!visitor.test(configurable2)) continue;
            return configurable2;
        }
        for (Configurable configurable2 : configurables) {
            Configurable.Composite composite;
            Configurable result2;
            if (!(configurable2 instanceof Configurable.Composite) || (result2 = ConfigurableVisitor.find(visitor, (composite = (Configurable.Composite)configurable2).getConfigurables())) == null) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    public static List<Configurable> findAll(@NotNull Predicate<Configurable> visitor, @NotNull List<? extends ConfigurableGroup> groups) {
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        Consumer<Configurable> consumer = configurable2 -> {
            if (visitor.test((Configurable)configurable2)) {
                list2.add((Configurable)configurable2);
            }
        };
        for (ConfigurableGroup configurableGroup : groups) {
            ConfigurableVisitor.collect(consumer, configurableGroup.getConfigurables());
        }
        return list2;
    }

    @ApiStatus.Internal
    public static void collect(@NotNull Consumer<Configurable> visitor, Configurable @NotNull [] configurables) {
        for (Configurable configurable2 : configurables) {
            visitor.accept(configurable2);
            if (!(configurable2 instanceof Configurable.Composite)) continue;
            ConfigurableVisitor.collect(visitor, ((Configurable.Composite)configurable2).getConfigurables());
        }
    }

    @NotNull
    public static String getId(@NotNull Configurable configurable2) {
        return configurable2 instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable2).getId() : configurable2.getClass().getName();
    }

    @Deprecated
    public static final class ByID
    extends ConfigurableVisitor {
        private final String id;

        public ByID(@NotNull String id2) {
            this.id = id2;
        }

        @Override
        protected boolean accept(@NotNull Configurable configurable2) {
            return this.id.equals(ByID.getId(configurable2));
        }

        @Nullable
        public Configurable find(@NotNull List<? extends ConfigurableGroup> groups) {
            return ByID.find((Predicate<Configurable>)this, groups);
        }
    }
}

