/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.options.ConfigurableWithOptionDescriptors;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeanConfigurable<T>
implements UnnamedConfigurable,
ConfigurableWithOptionDescriptors {
    private final T myInstance;
    private String myTitle;
    private final List<BeanField> myFields = new ArrayList<BeanField>();

    protected BeanConfigurable(@NotNull T beanInstance) {
        this.myInstance = beanInstance;
    }

    protected BeanConfigurable(@NotNull T beanInstance, String title) {
        this(beanInstance);
        this.setTitle(title);
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    protected void setTitle(String title) {
        this.myTitle = title;
    }

    @Nullable
    protected T getInstance() {
        return this.myInstance;
    }

    @Deprecated
    protected void checkBox(@NonNls String fieldName, String title) {
        this.myFields.add(new CheckboxField(fieldName, title));
    }

    protected void checkBox(@NlsContexts.Checkbox @NotNull String title, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter) {
        CheckboxField field = new CheckboxField(new BeanMethodAccessor(getter, setter), title);
        this.myFields.add(field);
    }

    protected void checkBox(@NlsContexts.Checkbox @NotNull String title, @NotNull KMutableProperty0<Boolean> prop) {
        this.myFields.add(new CheckboxField(new BeanKPropertyAccessor(prop), title));
    }

    protected <V> void component(final @NotNull JComponent component2, @NotNull Getter<? extends V> beanGetter, @NotNull Setter<? super V> beanSetter, final @NotNull Getter<? extends V> componentGetter, final @NotNull Setter<? super V> componentSetter) {
        BeanField<JComponent> field = new BeanField<JComponent>(new BeanMethodAccessor(beanGetter, beanSetter)){

            @Override
            @NotNull
            JComponent createComponent() {
                return component2;
            }

            @Override
            Object getComponentValue() {
                return componentGetter.get();
            }

            @Override
            void setComponentValue(Object value2) {
                componentSetter.set(value2);
            }
        };
        this.myFields.add(field);
    }

    @NotNull
    public List<OptionDescription> getOptionDescriptors(@NotNull String configurableId, @NotNull Function<? super String, String> nameConverter) {
        List boxes = JBIterable.from(this.myFields).filter(CheckboxField.class).toList();
        T instance = this.getInstance();
        return ContainerUtil.map((Collection)boxes, box -> new BooleanOptionDescription((String)nameConverter.apply(((CheckboxField)box).getTitle()), configurableId, (CheckboxField)box, instance){
            final /* synthetic */ CheckboxField val$box;
            final /* synthetic */ Object val$instance;
            {
                this.val$box = checkboxField;
                this.val$instance = object;
                super(x0, x1);
            }

            public boolean isOptionEnabled() {
                return this.val$box.getValue(this.val$instance);
            }

            public void setOptionState(boolean enabled) {
                this.val$box.setValue(this.val$instance, enabled);
            }
        });
    }

    public JComponent createComponent() {
        JPanel panel2 = new JPanel(new GridLayout(this.myFields.size(), 1, 0, JBUI.scale((int)5)));
        for (BeanField field : this.myFields) {
            panel2.add((Component)field.getComponent());
        }
        BorderLayoutPanel result2 = JBUI.Panels.simplePanel().addToTop((Component)panel2);
        if (this.myTitle != null) {
            result2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.myTitle));
        }
        return result2;
    }

    public boolean isModified() {
        for (BeanField field : this.myFields) {
            if (!field.isModified(this.myInstance)) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (BeanField field : this.myFields) {
            field.apply(this.myInstance);
        }
    }

    public void reset() {
        for (BeanField field : this.myFields) {
            field.reset(this.myInstance);
        }
    }

    private static class CheckboxField
    extends BeanField<JCheckBox> {
        private final String myTitle;

        private CheckboxField(String fieldName, String title) {
            super(new BeanFieldAccessor(fieldName, Boolean.TYPE));
            this.myTitle = title;
        }

        private CheckboxField(BeanPropertyAccessor accessor, String title) {
            super(accessor);
            this.myTitle = title;
        }

        private String getTitle() {
            return this.myTitle;
        }

        private void setValue(Object settingsInstance, boolean value2) {
            this.myAccessor.setBeanValue(settingsInstance, value2);
        }

        private boolean getValue(Object settingsInstance) {
            return (Boolean)this.myAccessor.getBeanValue(settingsInstance);
        }

        @Override
        @NotNull
        JCheckBox createComponent() {
            return new JCheckBox(this.myTitle);
        }

        @Override
        Object getComponentValue() {
            return ((JCheckBox)this.getComponent()).isSelected();
        }

        @Override
        void setComponentValue(Object value2) {
            ((JCheckBox)this.getComponent()).setSelected((Boolean)value2);
        }
    }

    private static abstract class BeanField<T extends JComponent> {
        BeanPropertyAccessor myAccessor;
        T myComponent;

        private BeanField(BeanPropertyAccessor accessor) {
            this.myAccessor = accessor;
        }

        T getComponent() {
            if (this.myComponent == null) {
                this.myComponent = this.createComponent();
            }
            return this.myComponent;
        }

        @NotNull
        abstract T createComponent();

        boolean isModified(Object instance) {
            Object beanValue;
            Object componentValue = this.getComponentValue();
            return !Comparing.equal((Object)componentValue, (Object)(beanValue = this.myAccessor.getBeanValue(instance)));
        }

        void apply(Object instance) {
            this.myAccessor.setBeanValue(instance, this.getComponentValue());
        }

        void reset(Object instance) {
            this.setComponentValue(this.myAccessor.getBeanValue(instance));
        }

        abstract Object getComponentValue();

        abstract void setComponentValue(Object var1);
    }

    private static class BeanKPropertyAccessor<T>
    extends BeanPropertyAccessor {
        private final KMutableProperty0<T> myProperty;

        private BeanKPropertyAccessor(KMutableProperty0<T> property) {
            this.myProperty = property;
        }

        @Override
        Object getBeanValue(Object instance) {
            return this.myProperty.get();
        }

        @Override
        void setBeanValue(Object instance, @NotNull Object value2) {
            this.myProperty.set(value2);
        }
    }

    private static class BeanMethodAccessor<T>
    extends BeanPropertyAccessor {
        private final Getter<? extends T> myGetter;
        private final Setter<? super T> mySetter;

        private BeanMethodAccessor(Getter<? extends T> getter, Setter<? super T> setter) {
            this.myGetter = getter;
            this.mySetter = setter;
        }

        @Override
        Object getBeanValue(Object instance) {
            return this.myGetter.get();
        }

        @Override
        void setBeanValue(Object instance, @NotNull Object value2) {
            this.mySetter.set(value2);
        }
    }

    private static class BeanFieldAccessor
    extends BeanPropertyAccessor {
        private final String myFieldName;
        private final Class myValueClass;

        private BeanFieldAccessor(String fieldName, Class valueClass) {
            this.myFieldName = fieldName;
            this.myValueClass = valueClass;
        }

        @NonNls
        protected String getterName() {
            if (this.myValueClass.equals(Boolean.TYPE)) {
                return "is" + StringUtil.capitalize((String)this.myFieldName);
            }
            return "get" + StringUtil.capitalize((String)this.myFieldName);
        }

        @Override
        Object getBeanValue(@NotNull Object instance) {
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                return field.get(instance);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method2 = instance.getClass().getMethod(this.getterName(), new Class[0]);
                    return method2.invoke(instance, new Object[0]);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        void setBeanValue(@NotNull Object instance, @NotNull Object value2) {
            try {
                Field field = instance.getClass().getField(this.myFieldName);
                field.set(instance, value2);
            }
            catch (NoSuchFieldException e) {
                try {
                    Method method2 = instance.getClass().getMethod("set" + StringUtil.capitalize((String)this.myFieldName), this.myValueClass);
                    method2.invoke(instance, value2);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class BeanPropertyAccessor {
        private BeanPropertyAccessor() {
        }

        abstract Object getBeanValue(Object var1);

        abstract void setBeanValue(Object var1, @NotNull Object var2);
    }
}

