/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.ModuleStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.ExternalModuleListStorage;
import com.intellij.openapi.module.impl.ExternalModuleListStorageKt;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleGroupersKt;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.module.impl.ModuleManagerEx;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.ModulePathSaveItem;
import com.intellij.openapi.module.impl.SaveItem;
import com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.UnloadedModulesListStorage;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@ApiStatus.Internal
public abstract class ModuleManagerImpl
extends ModuleManagerEx
implements Disposable,
PersistentStateComponent<Element>,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance(ModuleManagerImpl.class);
    private static final Key<String> DISPOSED_MODULE_NAME = Key.create((String)"DisposedNeverAddedModuleName");
    protected final Project myProject;
    private final ProjectRootManagerEx myProjectRootManager;
    protected volatile ModuleModelImpl myModuleModel = new ModuleModelImpl(this);
    private Set<ModulePath> myModulePathsToLoad;
    private final Set<ModulePath> myFailedModulePaths = new HashSet<ModulePath>();
    private final Map<String, UnloadedModuleDescriptionImpl> myUnloadedModules = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>();
    private boolean myModulesLoaded;
    private double myProgressStep;
    private volatile Module[] myCachedSortedModules;
    private volatile Graph<Module> myCachedModuleProductionGraph;
    private volatile Graph<Module> myCachedModuleTestGraph;
    private volatile Comparator<Module> myCachedModuleComparator;

    public static ModuleManagerImpl getInstanceImpl(Project project) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance((Project)project);
    }

    public ModuleManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myProjectRootManager = ProjectRootManagerEx.getInstanceEx((Project)project);
    }

    public void projectOpened() {
        this.fireModulesAdded();
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectOpened();
        }
    }

    public void projectClosed() {
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectClosed();
        }
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
        this.myCachedModuleProductionGraph = null;
        this.myCachedModuleTestGraph = null;
    }

    public void dispose() {
        this.myModuleModel.disposeModel();
        this.myProjectRootManager.assertListenersAreDisposed();
    }

    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e, ExternalModuleListStorageKt.getFilteredModuleList(this.myProject, this.getModules(), false));
        return e;
    }

    public void loadState(@NotNull Element state) {
        Set<ModulePath> files2 = ModuleManagerImpl.getPathsToModuleFiles(state);
        Set<ModulePath> externalModules = ((ExternalModuleListStorage)this.myProject.getComponent(ExternalModuleListStorage.class)).getExternalModules();
        if (externalModules != null) {
            files2.addAll(externalModules);
        }
        this.loadState(files2);
    }

    public void noStateLoaded() {
        Set<ModulePath> externalModules = ((ExternalModuleListStorage)this.myProject.getComponent(ExternalModuleListStorage.class)).getExternalModules();
        if (externalModules != null) {
            this.loadState(new LinkedHashSet<ModulePath>(externalModules));
        }
    }

    private void loadState(@NotNull Set<ModulePath> modulePaths) {
        boolean isFirstLoadState = this.myModulePathsToLoad == null;
        this.myModulePathsToLoad = modulePaths;
        HashSet<String> unloadedModuleNames = new HashSet<String>(UnloadedModulesListStorage.getInstance(this.myProject).getUnloadedModuleNames());
        Iterator<ModulePath> iterator2 = this.myModulePathsToLoad.iterator();
        ArrayList<ModulePath> unloadedModulePaths = new ArrayList<ModulePath>();
        while (iterator2.hasNext()) {
            ModulePath modulePath = iterator2.next();
            if (!unloadedModuleNames.contains(modulePath.getModuleName())) continue;
            unloadedModulePaths.add(modulePath);
            iterator2.remove();
        }
        ArrayList<UnloadedModuleDescriptionImpl> unloaded = new ArrayList<UnloadedModuleDescriptionImpl>(UnloadedModuleDescriptionImpl.createFromPaths(unloadedModulePaths, this));
        if (!unloaded.isEmpty()) {
            this.unloadNewlyAddedModulesIfPossible(this.myModulePathsToLoad, unloaded);
        }
        this.myUnloadedModules.clear();
        for (UnloadedModuleDescriptionImpl description : unloaded) {
            this.myUnloadedModules.put(description.getName(), description);
        }
        if (isFirstLoadState) {
            return;
        }
        ModifiableModuleModel model = this.getModifiableModel();
        Module[] existingModules = model.getModules();
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        Object2ObjectOpenHashMap modulePathMap = new Object2ObjectOpenHashMap(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            modulePathMap.put(modulePath.getPath(), modulePath);
        }
        for (Module existingModule : existingModules) {
            Object[] group;
            ModulePath correspondingPath = (ModulePath)modulePathMap.remove(existingModule.getModuleFilePath());
            if (correspondingPath == null) {
                model.disposeModule(existingModule);
                continue;
            }
            this.myModulePathsToLoad.remove(correspondingPath);
            String groupStr = correspondingPath.getGroup();
            Object[] objectArray = group = groupStr == null ? null : groupStr.split("/");
            if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
            groupInterner.setModuleGroupPath(model, existingModule, (String[])group);
        }
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableModuleModel)model).commit());
        this.myModulePathsToLoad.clear();
    }

    protected void unloadNewlyAddedModulesIfPossible(@NotNull Set<ModulePath> modulesToLoad, @NotNull List<UnloadedModuleDescriptionImpl> modulesToUnload2) {
    }

    @NotNull
    public static Set<ModulePath> getPathsToModuleFiles(@NotNull Element element2) {
        LinkedHashSet<ModulePath> paths = new LinkedHashSet<ModulePath>();
        Element modules2 = element2.getChild("modules");
        if (modules2 != null) {
            for (Element moduleElement : modules2.getChildren("module")) {
                String fileUrlValue = moduleElement.getAttributeValue("fileurl");
                String filepath = fileUrlValue == null ? moduleElement.getAttributeValue("filepath") : VirtualFileManager.extractPath((String)fileUrlValue);
                paths.add(new ModulePath(FileUtilRt.toSystemIndependentName((String)Objects.requireNonNull(filepath)), moduleElement.getAttributeValue("group")));
            }
        }
        return paths;
    }

    protected void loadModules(@NotNull ModuleModelImpl moduleModel) {
        this.myFailedModulePaths.clear();
        if (this.myModulePathsToLoad == null || this.myModulePathsToLoad.isEmpty()) {
            this.myModulesLoaded = true;
            return;
        }
        this.myFailedModulePaths.addAll(this.myModulePathsToLoad);
        ProgressIndicator globalIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        EmptyProgressIndicator progressIndicator2 = this.myProject.isDefault() || globalIndicator == null ? new EmptyProgressIndicator() : globalIndicator;
        progressIndicator2.setText(ProjectModelBundle.message((String)"progress.text.loading.modules", (Object[])new Object[0]));
        progressIndicator2.setText2("");
        List errors = Collections.synchronizedList(new ArrayList());
        boolean isParallel = Registry.is((String)"parallel.modules.loading") && !ApplicationManager.getApplication().isDispatchThread();
        ExecutorService service = isParallel ? AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ModuleManager Loader", (int)Math.min(2, Runtime.getRuntime().availableProcessors())) : ConcurrencyUtil.newSameThreadExecutorService();
        ArrayList<Pair> tasks = new ArrayList<Pair>();
        HashSet<String> paths = new HashSet<String>(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            if (progressIndicator2.isCanceled()) break;
            String path = modulePath.getPath();
            if (!paths.add(path)) continue;
            tasks.add(new Pair(service.submit(() -> this.lambda$loadModules$1((ProgressIndicator)progressIndicator2, path, errors, modulePath)), (Object)modulePath));
        }
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        SmartList modulesWithUnknownTypes = new SmartList();
        for (Pair task2 : tasks) {
            if (progressIndicator2.isCanceled()) break;
            try {
                ModulePath modulePath;
                String groupPathString;
                Module module = (Module)((Future)task2.first).get();
                if (module == null) continue;
                moduleModel.addModule(module);
                if (this.isUnknownModuleType(module)) {
                    modulesWithUnknownTypes.add(module);
                }
                if ((groupPathString = (modulePath = (ModulePath)task2.second).getGroup()) != null) {
                    groupInterner.setModuleGroupPath(moduleModel, module, groupPathString.split("/"));
                }
                this.myFailedModulePaths.remove(modulePath);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        service.shutdown();
        progressIndicator2.checkCanceled();
        this.myModulesLoaded = true;
        Application app = ApplicationManager.getApplication();
        if (app.isInternal() || app.isEAP() || ApplicationInfo.getInstance().getBuild().isSnapshot()) {
            Object2ObjectOpenHashMap track = new Object2ObjectOpenHashMap();
            for (Module module : moduleModel.getModules()) {
                for (String url : ModuleRootManager.getInstance((Module)module).getContentRootUrls()) {
                    Module oldModule = track.put(url, module);
                    if (oldModule == null) continue;
                    LOG.warn("Module '" + module.getName() + "' and module '" + oldModule.getName() + "' have the same content root: " + url);
                }
            }
        }
        this.onModuleLoadErrors(moduleModel, errors);
        this.showUnknownModuleTypeNotification((List<? extends Module>)modulesWithUnknownTypes);
    }

    @NotNull
    private static Module loadModuleInternal(@NotNull Path filePath, @NotNull ModuleManagerImpl manager) throws IOException {
        String systemIndependentPath = filePath.toString().replace(File.separatorChar, '/');
        VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(systemIndependentPath);
        if (virtualFile != null) {
            virtualFile.setCharset(StandardCharsets.UTF_8, null, false);
        }
        return (Module)ReadAction.compute(() -> {
            ModuleEx module = manager.createAndLoadModule(systemIndependentPath);
            ModuleManagerImpl.initModule(module, () -> ((ModuleStore)module.getService(IComponentStore.class)).setPath(filePath, virtualFile, false));
            return module;
        });
    }

    private static void initModule(@NotNull ModuleEx module, @NotNull Runnable beforeComponentCreation) {
        try {
            module.init(beforeComponentCreation);
        }
        catch (Throwable e) {
            ModuleManagerImpl.disposeModuleLater(module);
            throw e;
        }
    }

    private void reportError(@NotNull List<? super ModuleLoadingErrorDescription> errors, @NotNull ModulePath modulePath, @NotNull Exception e) {
        errors.add(new ModuleLoadingErrorDescription(ProjectModelBundle.message((String)"module.cannot.load.error", (Object[])new Object[]{modulePath.getPath(), e.getMessage()}), modulePath, this));
    }

    public int getModulePathsCount() {
        return this.myModulePathsToLoad == null ? 0 : this.myModulePathsToLoad.size();
    }

    public boolean areModulesLoaded() {
        return this.myModulesLoaded;
    }

    public void setProgressStep(double step) {
        this.myProgressStep = step;
    }

    protected boolean isUnknownModuleType(@NotNull Module module) {
        return false;
    }

    protected void showUnknownModuleTypeNotification(@NotNull List<? extends Module> types) {
    }

    protected void fireModuleRemoved(@NotNull Module module) {
        ((ModuleListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES)).moduleRemoved(this.myProject, module);
    }

    protected void fireBeforeModuleRemoved(@NotNull Module module) {
        ((ModuleListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES)).beforeModuleRemoved(this.myProject, module);
    }

    protected void fireModulesRenamed(@NotNull List<Module> modules2, @NotNull Map<Module, String> oldNames) {
        if (modules2.isEmpty()) {
            return;
        }
        try {
            for (Module module : this.getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                if (!(moduleRootManager instanceof ModuleRootManagerImpl)) continue;
                ((ModuleRootManagerImpl)moduleRootManager).stateChanged();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        ((ModuleListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES)).modulesRenamed(this.myProject, modules2, oldNames::get);
    }

    private void onModuleLoadErrors(@NotNull ModuleModelImpl moduleModel, @NotNull List<? extends ModuleLoadingErrorDescription> errors) {
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$502(moduleModel, null);
        for (ModuleLoadingErrorDescription moduleLoadingErrorDescription : errors) {
            ModuleEx module = moduleModel.getModuleByFilePath(moduleLoadingErrorDescription.getModulePath().getPath());
            if (module == null) continue;
            moduleModel.myModules.remove(module.getName());
            ModuleManagerImpl.disposeModuleLater(module);
        }
        this.fireModuleLoadErrors(errors);
    }

    private static void disposeModuleLater(@NotNull Module module) {
        ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)module), module.getDisposed());
    }

    protected void fireModuleLoadErrors(@NotNull List<? extends ModuleLoadingErrorDescription> errors) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    void removeFailedModulePath(@NotNull ModulePath modulePath) {
        this.myFailedModulePaths.remove(modulePath);
        this.incModificationCount();
    }

    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new ModuleModelImpl(this.myModuleModel);
    }

    public void writeExternal(@NotNull Element element2, @NotNull List<? extends Module> collection) {
        ModuleManagerImpl.writeExternal(element2, collection, this);
    }

    @ApiStatus.Internal
    public static void writeExternal(@NotNull Element element2, @NotNull List<? extends Module> collection, ModuleManagerEx moduleManager) {
        Collection<ModulePath> failedModulePaths = moduleManager.getFailedModulePaths();
        Collection unloadedModuleDescriptions = moduleManager.getUnloadedModuleDescriptions();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.size() + failedModulePaths.size() + unloadedModuleDescriptions.size());
        for (Module module : collection) {
            sorted.add(new ModuleSaveItem(module, moduleManager));
        }
        for (ModulePath modulePath : failedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        for (UnloadedModuleDescription unloadedModuleDescription : unloadedModuleDescriptions) {
            sorted.add(new ModulePathSaveItem(((UnloadedModuleDescriptionImpl)unloadedModuleDescription).getModulePath()));
        }
        if (!sorted.isEmpty()) {
            sorted.sort(Comparator.comparing(SaveItem::getModuleName));
            Element modules2 = new Element("modules");
            for (SaveItem saveItem : sorted) {
                saveItem.writeExternal(modules2);
            }
            element2.addContent(modules2);
        }
    }

    @NotNull
    public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        return module;
    }

    @NotNull
    public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String id2) {
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newNonPersistentModule(moduleName, id2);
        modifiableModel.commit();
        return module;
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        return module;
    }

    public void disposeModule(@NotNull Module module) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableModuleModel modifiableModel = this.getModifiableModel();
            modifiableModel.disposeModule(module);
            modifiableModel.commit();
        });
    }

    public Module @NotNull [] getModules() {
        ModuleModelImpl model = this.myModuleModel;
        if (model.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        return model.getModules();
    }

    public Module @NotNull [] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        Module[] sortedModules = this.myCachedSortedModules;
        if (sortedModules == null) {
            this.myCachedSortedModules = sortedModules = this.myModuleModel.getSortedModules();
        }
        return sortedModules;
    }

    public Module findModuleByName(@NotNull String name) {
        return this.myModuleModel.findModuleByName(name);
    }

    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        Comparator cachedModuleComparator = this.myCachedModuleComparator;
        if (cachedModuleComparator == null) {
            this.myCachedModuleComparator = cachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        return cachedModuleComparator;
    }

    protected void deliverPendingEvents() {
    }

    @NotNull
    public Graph<Module> moduleGraph() {
        return this.moduleGraph(true);
    }

    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        Graph graph2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = graph2 = includeTests ? this.myCachedModuleTestGraph : this.myCachedModuleProductionGraph;
        if (graph2 != null) {
            return graph2;
        }
        graph2 = this.myModuleModel.moduleGraph(includeTests);
        if (includeTests) {
            this.myCachedModuleTestGraph = graph2;
        } else {
            this.myCachedModuleProductionGraph = graph2;
        }
        return graph2;
    }

    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module) {
        SmartList result2 = new SmartList();
        for (Module aModule : this.getModules()) {
            if (!ModuleManagerImpl.isModuleDependsOn(aModule, module)) continue;
            result2.add(aModule);
        }
        return result2;
    }

    public boolean isModuleDependent(@NotNull Module module, @NotNull Module onModule) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ModuleManagerImpl.isModuleDependsOn(module, onModule);
    }

    private static boolean isModuleDependsOn(@NotNull Module module, @NotNull Module onModule) {
        return ModuleRootManager.getInstance((Module)module).isDependsOn(onModule);
    }

    protected void fireModulesAdded() {
        for (Module module : this.myModuleModel.getModules()) {
            this.fireModuleAddedInWriteAction((ModuleEx)module);
        }
    }

    protected void fireModuleAddedInWriteAction(@NotNull ModuleEx module) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!module.isLoaded()) {
                module.moduleAdded();
                ((ModuleListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES)).moduleAdded(this.myProject, (Module)module);
            }
        });
    }

    public static void commitModelWithRunnable(@NotNull ModifiableModuleModel model, @NotNull Runnable runnable2) {
        ((ModuleModelImpl)model).commitWithRunnable(runnable2);
    }

    @NotNull
    protected abstract ModuleEx createModule(@NotNull String var1);

    protected ModuleEx createNonPersistentModule(@NotNull String name) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected abstract ModuleEx createAndLoadModule(@NotNull String var1) throws IOException;

    private void commitModel(@NotNull ModuleModelImpl moduleModel, @NotNull Runnable runnable2) {
        Collection<Object> removedModules;
        Collection<Module> addedModules;
        ModuleModelImpl.access$502(this.myModuleModel, null);
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<Module> oldModules = Arrays.asList(this.myModuleModel.getModules());
        List<Module> newModules = Arrays.asList(moduleModel.getModules());
        if (oldModules.isEmpty()) {
            addedModules = newModules;
            removedModules = Collections.emptyList();
        } else {
            addedModules = new HashSet<Module>(newModules);
            addedModules.removeAll(oldModules);
            removedModules = new HashSet<Module>(oldModules);
            removedModules.removeAll(newModules);
        }
        this.myProjectRootManager.makeRootsChange(() -> {
            for (Object removedModule : removedModules) {
                this.fireBeforeModuleRemoved((Module)removedModule);
                this.cleanCachedStuff();
            }
            if (!moduleModel.myModulesToDispose.isEmpty()) {
                ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
                neverAddedModules.removeAll(oldModules);
                for (Module neverAddedModule : neverAddedModules) {
                    neverAddedModule.putUserData(DISPOSED_MODULE_NAME, (Object)neverAddedModule.getName());
                    Disposer.dispose((Disposable)neverAddedModule);
                }
            }
            runnable2.run();
            Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
            Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
            modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
            ArrayList<Module> modules2 = new ArrayList<Module>();
            HashMap<Module, String> oldNames = new HashMap<Module, String>();
            for (Object module : modulesToBeRenamed) {
                oldNames.put((Module)module, module.getName());
                moduleModel.myModules.remove(module.getName());
                modules2.add((Module)module);
                ((ModuleEx)module).rename((String)modulesToNewNamesMap.get(module), true);
                moduleModel.myModules.put(module.getName(), (Module)module);
                this.myUnloadedModules.remove(module.getName());
            }
            moduleModel.myIsWritable = false;
            this.myModuleModel = moduleModel;
            for (Object module : removedModules) {
                this.fireModuleRemoved((Module)module);
                this.cleanCachedStuff();
                Disposer.dispose((Disposable)module);
                this.cleanCachedStuff();
            }
            ModuleListener publisher = (ModuleListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES);
            for (Module addedModule : addedModules) {
                this.myUnloadedModules.remove(addedModule.getName());
                ((ModuleEx)addedModule).moduleAdded();
                this.cleanCachedStuff();
                publisher.moduleAdded(this.myProject, addedModule);
                this.cleanCachedStuff();
            }
            this.cleanCachedStuff();
            this.fireModulesRenamed(modules2, oldNames);
            this.cleanCachedStuff();
            UnloadedModulesListStorage unloadedModulesListStorage = UnloadedModulesListStorage.getInstance(this.myProject);
            this.setUnloadedModuleNames(ContainerUtil.filter(unloadedModulesListStorage.getUnloadedModuleNames(), this.myUnloadedModules::containsKey));
        }, false, true);
    }

    public void fireModuleRenamedByVfsEvent(@NotNull Module module, @NotNull String oldName) {
        Module moduleInMap = this.myModuleModel.myModules.remove(oldName);
        LOG.assertTrue(moduleInMap == null || moduleInMap == module);
        this.myModuleModel.myModules.put(module.getName(), module);
        this.incModificationCount();
        this.myProjectRootManager.makeRootsChange(() -> this.fireModulesRenamed(Collections.singletonList(module), Collections.singletonMap(module, oldName)), false, true);
    }

    public String[] getModuleGroupPath(@NotNull Module module) {
        return this.myModuleModel.getModuleGroupPath(module);
    }

    public boolean hasModuleGroups() {
        return this.myModuleModel.hasModuleGroups();
    }

    @NotNull
    public Collection<ModuleDescription> getAllModuleDescriptions() {
        Module[] modules2 = this.getModules();
        ArrayList<ModuleDescription> descriptions = new ArrayList<ModuleDescription>(modules2.length + this.myUnloadedModules.size());
        for (Module module : modules2) {
            descriptions.add((ModuleDescription)new LoadedModuleDescriptionImpl(module));
        }
        descriptions.addAll(this.myUnloadedModules.values());
        return descriptions;
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions() {
        return Collections.unmodifiableCollection(this.myUnloadedModules.values());
    }

    @Override
    public Collection<ModulePath> getFailedModulePaths() {
        return Collections.unmodifiableSet(this.myFailedModulePaths);
    }

    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull String moduleName) {
        return this.myUnloadedModules.get(moduleName);
    }

    @NotNull
    public ModuleGrouper getModuleGrouper(@Nullable ModifiableModuleModel model) {
        return ModuleGroupersKt.createGrouper(this.myProject, model);
    }

    public void setUnloadedModules(@NotNull List<String> unloadedModuleNames) {
        if (this.myUnloadedModules.keySet().equals(new HashSet<String>(unloadedModuleNames))) {
            return;
        }
        this.setUnloadedModuleNames(unloadedModuleNames);
        ModifiableModuleModel model = this.getModifiableModel();
        LinkedHashMap<String, UnloadedModuleDescriptionImpl> toLoad = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>(this.myUnloadedModules);
        this.myUnloadedModules.clear();
        for (String name : unloadedModuleNames) {
            if (toLoad.containsKey(name)) {
                this.myUnloadedModules.put(name, (UnloadedModuleDescriptionImpl)toLoad.remove(name));
                continue;
            }
            Module module = this.findModuleByName(name);
            if (module == null) continue;
            LoadedModuleDescriptionImpl description = new LoadedModuleDescriptionImpl(module);
            ModuleSaveItem saveItem = new ModuleSaveItem(module, this);
            ModulePath modulePath = new ModulePath(saveItem.getModuleFilePath(), saveItem.getGroupPathString());
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            List contentRoots = ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)module).getContentRootUrls(), url -> pointerManager.create(url, (Disposable)this, null));
            UnloadedModuleDescriptionImpl unloadedModuleDescription = new UnloadedModuleDescriptionImpl(modulePath, description.getDependencyModuleNames(), contentRoots);
            StateStorageManagerKt.saveComponentManager((ComponentManager)module);
            model.disposeModule(module);
            this.myUnloadedModules.put(name, unloadedModuleDescription);
        }
        ArrayList<ModulePath> oldFailedPaths = new ArrayList<ModulePath>(this.myFailedModulePaths);
        this.myModulePathsToLoad = toLoad.values().stream().map(UnloadedModuleDescriptionImpl::getModulePath).collect(Collectors.toCollection(LinkedHashSet::new));
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableModuleModel)model).commit());
        this.myFailedModulePaths.addAll(oldFailedPaths);
        this.myModulePathsToLoad.clear();
    }

    public void removeUnloadedModules(@NotNull Collection<? extends UnloadedModuleDescription> unloadedModules) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (UnloadedModuleDescription unloadedModuleDescription : unloadedModules) {
            this.myUnloadedModules.remove(unloadedModuleDescription.getName());
        }
        this.setUnloadedModuleNames(new ArrayList<String>(this.myUnloadedModules.keySet()));
    }

    protected void setUnloadedModuleNames(@NotNull List<String> unloadedModuleNames) {
        UnloadedModulesListStorage.getInstance(this.myProject).setUnloadedModuleNames(unloadedModuleNames);
    }

    public void setModuleGroupPath(@NotNull Module module, String @Nullable [] groupPath) {
        this.myModuleModel.setModuleGroupPath(module, groupPath);
    }

    private /* synthetic */ Module lambda$loadModules$1(ProgressIndicator progressIndicator2, String path, List errors, ModulePath modulePath) throws Exception {
        progressIndicator2.setFraction(progressIndicator2.getFraction() + this.myProgressStep);
        return (Module)ProgressManager.getInstance().runProcess(() -> {
            try {
                return this.myProject.isDisposed() ? null : ModuleManagerImpl.loadModuleInternal(Paths.get(path, new String[0]), this);
            }
            catch (IOException e) {
                this.reportError(errors, modulePath, e);
            }
            catch (ProcessCanceledException e) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return null;
        }, (ProgressIndicator)ProgressWrapper.wrap(progressIndicator2));
    }

    static final class ModuleModelImpl
    implements ModifiableModuleModel {
        final Map<String, Module> myModules = Collections.synchronizedMap(new LinkedHashMap());
        private volatile Module[] myModulesCache;
        private final List<Module> myModulesToDispose = new ArrayList<Module>();
        private final Map<Module, String> myModuleToNewName = new HashMap<Module, String>();
        private final Map<String, Module> myNewNameToModule = new HashMap<String, Module>();
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;
        private final ModuleManagerImpl myManager;

        private ModuleModelImpl(@NotNull ModuleManagerImpl manager) {
            this.myManager = manager;
            this.myIsWritable = false;
        }

        private ModuleModelImpl(@NotNull ModuleModelImpl that) {
            this.myManager = that.myManager;
            this.myModules.putAll(that.myModules);
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new Object2ObjectOpenHashMap();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, (Object)"Attempt to modify committed ModifiableModuleModel");
        }

        public Module @NotNull [] getModules() {
            Module[] cache = this.myModulesCache;
            if (cache == null) {
                Collection<Module> modules2 = this.myModules.values();
                this.myModulesCache = cache = modules2.toArray(Module.EMPTY_ARRAY);
            }
            return cache;
        }

        private Module @NotNull [] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            return allModules;
        }

        public void renameModule(@NotNull Module module, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module));
            if (module.getName().equals(newName)) {
                this.myModuleToNewName.remove(module);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module, newName);
                this.myNewNameToModule.put(newName, module);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectModelBundle.message((String)"module.already.exists.error", (Object[])new Object[]{newName}), newName);
            }
        }

        public Module getModuleToBeRenamed(@NotNull String newName) {
            return this.myNewNameToModule.get(newName);
        }

        private Module getModuleByNewName(@NotNull String newName) {
            Module moduleToBeRenamed = this.getModuleToBeRenamed(newName);
            if (moduleToBeRenamed != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            return this.myModuleToNewName.get(moduleWithOldName) == null ? moduleWithOldName : null;
        }

        public String getNewName(@NotNull Module module) {
            return this.myModuleToNewName.get(module);
        }

        @NotNull
        public String getActualName(@NotNull Module module) {
            return (String)ObjectUtils.notNull((Object)this.getNewName(module), (Object)module.getName());
        }

        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
            return this.newModule(filePath, moduleTypeId, null);
        }

        @NotNull
        public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String moduleTypeId) {
            this.assertWritable();
            ModuleEx module = this.myManager.createNonPersistentModule(moduleName);
            ModuleManagerImpl.initModule(module, () -> module.setModuleType(moduleTypeId));
            this.addModule(module);
            return module;
        }

        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options2) {
            this.assertWritable();
            filePath = FileUtil.toSystemIndependentName((String)ModuleModelImpl.resolveShortWindowsName(filePath));
            ModuleEx module = this.getModuleByFilePath(filePath);
            if (module != null) {
                return module;
            }
            ModuleEx newModule = module = this.myManager.createModule(filePath);
            Path finalFilePath = Paths.get(filePath, new String[0]);
            ModuleManagerImpl.initModule(module, () -> {
                ((ModuleStore)newModule.getService(IComponentStore.class)).setPath(finalFilePath, null, true);
                newModule.setModuleType(moduleTypeId);
                if (options2 != null) {
                    for (Map.Entry option2 : options2.entrySet()) {
                        newModule.setOption((String)option2.getKey(), (String)option2.getValue());
                    }
                }
            });
            this.addModule(module);
            return module;
        }

        @NotNull
        private static String resolveShortWindowsName(@NotNull String filePath) {
            try {
                return FileUtil.resolveShortWindowsName((String)filePath);
            }
            catch (IOException ignored) {
                return filePath;
            }
        }

        @Nullable
        private ModuleEx getModuleByFilePath(@NotNull @SystemIndependent String filePath) {
            for (Module module : this.getModules()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? module.getModuleFilePath().equals(filePath) : module.getModuleFilePath().equalsIgnoreCase(filePath))) continue;
                return (ModuleEx)module;
            }
            return null;
        }

        @NotNull
        public Module loadModule(@NotNull @SystemIndependent String filePath) throws IOException {
            this.assertWritable();
            String resolvedPath = FileUtilRt.toSystemIndependentName((String)ModuleModelImpl.resolveShortWindowsName(filePath));
            try {
                ModuleEx module = this.getModuleByFilePath(resolvedPath);
                if (module == null) {
                    module = ModuleManagerImpl.loadModuleInternal(Paths.get(resolvedPath, new String[0]), this.myManager);
                    this.addModule(module);
                }
                return module;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(ProjectModelBundle.message((String)"module.corrupted.file.error", (Object[])new Object[]{FileUtilRt.toSystemDependentName((String)resolvedPath), e.getMessage()}), e);
            }
        }

        private void addModule(@NotNull Module module) {
            this.myModulesCache = null;
            this.myModules.put(module.getName(), module);
        }

        public void disposeModule(@NotNull Module module) {
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myModules.remove(module.getName()) != null) {
                this.myModulesToDispose.add(module);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module);
            }
        }

        public Module findModuleByName(@NotNull String name) {
            Module module = this.myModules.get(name);
            if (module != null && !module.isDisposed()) {
                return module;
            }
            return null;
        }

        @NotNull
        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder builder2 = new DFSTBuilder(this.moduleGraph(true));
            return builder2.comparator();
        }

        @NotNull
        private Graph<Module> moduleGraph(final boolean includeTests) {
            return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

                @NotNull
                public Collection<Module> getNodes() {
                    return myModules.values();
                }

                @NotNull
                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance((Module)m).getDependencies(includeTests);
                    return Arrays.asList(dependentModules).iterator();
                }
            }));
        }

        public void commit() {
            ModifiableModelCommitter.multiCommit(Collections.emptyList(), (ModifiableModuleModel)this);
        }

        private void commitWithRunnable(@NotNull Runnable runnable2) {
            this.myManager.commitModel(this, runnable2);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            Set existingModules = ContainerUtil.set((Object[])this.myManager.myModuleModel.getModules());
            for (Module thisModule : this.getModules()) {
                if (existingModules.contains(thisModule)) continue;
                Disposer.dispose((Disposable)thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (existingModules.contains(moduleToDispose)) continue;
                Disposer.dispose((Disposable)moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        public boolean isChanged() {
            if (!this.myIsWritable) {
                return false;
            }
            ModuleModelImpl model = this.myManager.myModuleModel;
            return !this.myModules.equals(model.myModules) || !Comparing.equal(model.myModuleGroupPath, this.myModuleGroupPath) || !this.myModuleToNewName.isEmpty();
        }

        private void disposeModel() {
            Module[] modules2 = this.getModules();
            this.myModulesCache = null;
            this.myModules.clear();
            for (Module module : modules2) {
                Disposer.dispose((Disposable)module);
            }
            this.myModuleGroupPath = null;
        }

        public String[] getModuleGroupPath(@NotNull Module module) {
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module);
        }

        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        public void setModuleGroupPath(@NotNull Module module, String @Nullable(value="null means remove") [] groupPath) {
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new Object2ObjectOpenHashMap();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module);
            } else {
                this.myModuleGroupPath.put(module, groupPath);
            }
        }

        @NotNull
        public Project getProject() {
            return this.myManager.myProject;
        }

        static /* synthetic */ Module[] access$502(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }
    }

    private static class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;
        private final ModuleManager myModuleManager;

        ModuleSaveItem(@NotNull Module module, @NotNull ModuleManager moduleManager) {
            this.myModule = module;
            this.myModuleManager = moduleManager;
        }

        @Override
        @NotNull
        protected String getModuleName() {
            return this.myModule.getName();
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = this.myModuleManager.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join((String[])groupPath, (String)"/") : null;
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            return this.myModule.getModuleFilePath();
        }
    }

    private static final class ModuleGroupInterner {
        private final Interner<String> groups = Interner.createStringInterner();
        private final Map<String[], String[]> paths = new Object2ObjectOpenCustomHashMap(ObjectArrays.HASH_STRATEGY);

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model, @NotNull Module module, String @Nullable [] group) {
            String[] cached;
            String[] stringArray = cached = group == null ? null : this.paths.get(group);
            if (cached == null && group != null) {
                cached = new String[group.length];
                for (int i2 = 0; i2 < group.length; ++i2) {
                    String g = group[i2];
                    cached[i2] = (String)this.groups.intern((Object)g);
                }
                this.paths.put(cached, cached);
            }
            model.setModuleGroupPath(module, cached);
        }
    }
}

