/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutPanel;
import com.intellij.openapi.keymap.impl.ui.ShortcutDialog;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KeyboardShortcutDialog
extends ShortcutDialog<KeyboardShortcut> {
    private final JComponent myPreferredFocusedComponent;
    @Nullable
    private final Map<KeyStroke, String> mySystemShortcuts;

    KeyboardShortcutDialog(Component parent, boolean allowSecondStroke, @Nullable Map<KeyStroke, String> systemShortcuts) {
        super(parent, "keyboard.shortcut.dialog.title", new KeyboardShortcutPanel(true, new BorderLayout()));
        KeyboardShortcutPanel panel2 = (KeyboardShortcutPanel)this.myShortcutPanel;
        this.myPreferredFocusedComponent = panel2.myFirstStroke;
        this.mySystemShortcuts = systemShortcuts;
        JPanel inner = new JPanel(new BorderLayout());
        inner.add("Center", (Component)((Object)panel2.mySecondStroke));
        inner.add("West", panel2.mySecondStrokeEnable);
        inner.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        inner.setVisible(allowSecondStroke);
        panel2.add("North", (Component)((Object)panel2.myFirstStroke));
        panel2.add("South", inner);
        panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        panel2.mySecondStrokeEnable.setText(KeyMapBundle.message((String)"dialog.enable.second.stroke.checkbox", (Object[])new Object[0]));
        this.init();
    }

    protected String getHelpId() {
        return "preferences.keymap.shortcut";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusedComponent;
    }

    @Override
    KeyboardShortcut toShortcut(Object value2) {
        return value2 instanceof KeyboardShortcut ? (KeyboardShortcut)value2 : null;
    }

    @Override
    @NotNull
    Collection<String> getConflicts(KeyboardShortcut shortcut, String actionId, Keymap keymap2) {
        String sysAct = this.getSystemShortcutAction(shortcut.getFirstKeyStroke());
        Set<String> keymapConflicts = keymap2.getConflicts(actionId, shortcut).keySet();
        if (sysAct == null) {
            return keymapConflicts;
        }
        if (keymapConflicts == null || keymapConflicts.isEmpty()) {
            return Collections.singletonList(sysAct);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        result2.addAll(keymapConflicts);
        result2.add(sysAct);
        return result2;
    }

    @Override
    protected void addSystemActionsIfPresented(Group group) {
        if (this.mySystemShortcuts != null) {
            Group macOsSysGroup = new Group("MacOS shortcuts", AllIcons.Nodes.KeymapOther);
            this.mySystemShortcuts.forEach((ks, actid) -> macOsSysGroup.addActionId((String)actid));
            group.addGroup(macOsSysGroup);
        }
    }

    @Nullable
    private String getSystemShortcutAction(@NotNull KeyStroke keyStroke) {
        return this.mySystemShortcuts == null ? null : this.mySystemShortcuts.get(keyStroke);
    }
}

