/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntProcedure;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public final class ModifierKeyDoubleClickHandler {
    private static final Logger LOG = Logger.getInstance(ModifierKeyDoubleClickHandler.class);
    private static final TIntIntHashMap KEY_CODE_TO_MODIFIER_MAP = new TIntIntHashMap();
    private final ConcurrentMap<String, MyDispatcher> myDispatchers = new ConcurrentHashMap<String, MyDispatcher>();
    private boolean myIsRunningAction;

    public ModifierKeyDoubleClickHandler() {
        int modifierKeyCode = ModifierKeyDoubleClickHandler.getMultiCaretActionModifier();
        this.registerAction("EditorCloneCaretAbove", modifierKeyCode, 38);
        this.registerAction("EditorCloneCaretBelow", modifierKeyCode, 40);
        this.registerAction("EditorLeftWithSelection", modifierKeyCode, 37);
        this.registerAction("EditorRightWithSelection", modifierKeyCode, 39);
        this.registerAction("EditorLineStartWithSelection", modifierKeyCode, 36);
        this.registerAction("EditorLineEndWithSelection", modifierKeyCode, 35);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (ModifierKeyDoubleClickHandler.this.myIsRunningAction) {
                    return;
                }
                for (MyDispatcher dispatcher : ModifierKeyDoubleClickHandler.this.myDispatchers.values()) {
                    dispatcher.resetState();
                }
            }
        });
        IdeEventQueue.getInstance().addDispatcher(event -> {
            if (!(event instanceof KeyEvent)) {
                return false;
            }
            boolean result2 = false;
            KeyEvent keyEvent = (KeyEvent)event;
            for (MyDispatcher dispatcher : this.myDispatchers.values()) {
                if (!dispatcher.dispatch(keyEvent)) continue;
                result2 = true;
            }
            return result2;
        }, (Disposable)ApplicationManager.getApplication());
    }

    public static ModifierKeyDoubleClickHandler getInstance() {
        return (ModifierKeyDoubleClickHandler)ApplicationManager.getApplication().getService(ModifierKeyDoubleClickHandler.class);
    }

    public static int getMultiCaretActionModifier() {
        return SystemInfo.isMac ? 18 : 17;
    }

    public void registerAction(@NotNull String actionId, int modifierKeyCode, int actionKeyCode, boolean skipIfActionHasShortcut) {
        this.myDispatchers.put(actionId, new MyDispatcher(actionId, modifierKeyCode, actionKeyCode, skipIfActionHasShortcut));
    }

    public void registerAction(@NotNull String actionId, int modifierKeyCode, int actionKeyCode) {
        this.registerAction(actionId, modifierKeyCode, actionKeyCode, true);
    }

    public void unregisterAction(@NotNull String actionId) {
        this.myDispatchers.remove(actionId);
    }

    public boolean isRunningAction() {
        return this.myIsRunningAction;
    }

    static {
        KEY_CODE_TO_MODIFIER_MAP.put(18, 8);
        KEY_CODE_TO_MODIFIER_MAP.put(17, 2);
        KEY_CODE_TO_MODIFIER_MAP.put(157, 4);
        KEY_CODE_TO_MODIFIER_MAP.put(16, 1);
    }

    private final class MyDispatcher {
        private final String myActionId;
        private final int myModifierKeyCode;
        private final int myActionKeyCode;
        private final boolean mySkipIfActionHasShortcut;
        private final Couple<AtomicBoolean> ourPressed = Couple.of((Object)new AtomicBoolean(false), (Object)new AtomicBoolean(false));
        private final Couple<AtomicBoolean> ourReleased = Couple.of((Object)new AtomicBoolean(false), (Object)new AtomicBoolean(false));
        private final AtomicBoolean ourOtherKeyWasPressed = new AtomicBoolean(false);
        private final AtomicLong ourLastTimePressed = new AtomicLong(0L);

        MyDispatcher(String actionId, int modifierKeyCode, int actionKeyCode, boolean skipIfActionHasShortcut) {
            this.myActionId = actionId;
            this.myModifierKeyCode = modifierKeyCode;
            this.myActionKeyCode = actionKeyCode;
            this.mySkipIfActionHasShortcut = skipIfActionHasShortcut;
        }

        public boolean dispatch(@NotNull KeyEvent event) {
            int keyCode = event.getKeyCode();
            LOG.debug("", new Object[]{this, event});
            if (keyCode == this.myModifierKeyCode) {
                if (this.hasOtherModifiers(event)) {
                    this.resetState();
                    return false;
                }
                if (this.myActionKeyCode == -1 && this.ourOtherKeyWasPressed.get() && event.getWhen() - this.ourLastTimePressed.get() < 100L) {
                    this.resetState();
                    return false;
                }
                this.ourOtherKeyWasPressed.set(false);
                if (((AtomicBoolean)this.ourPressed.first).get() && event.getWhen() - this.ourLastTimePressed.get() > 500L) {
                    this.resetState();
                }
                this.handleModifier(event);
                return false;
            }
            if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get() && ((AtomicBoolean)this.ourPressed.second).get() && this.myActionKeyCode != -1) {
                if (keyCode == this.myActionKeyCode && !this.hasOtherModifiers(event)) {
                    if (event.getID() == 401) {
                        return this.run(event);
                    }
                    return true;
                }
                return false;
            }
            this.ourLastTimePressed.set(event.getWhen());
            this.ourOtherKeyWasPressed.set(true);
            if (keyCode == 27 || keyCode == 9) {
                this.ourLastTimePressed.set(0L);
            }
            this.resetState();
            return false;
        }

        private boolean hasOtherModifiers(KeyEvent keyEvent) {
            final int modifiers = keyEvent.getModifiers();
            return !KEY_CODE_TO_MODIFIER_MAP.forEachEntry(new TIntIntProcedure(){

                public boolean execute(int keyCode, int modifierMask) {
                    return keyCode == MyDispatcher.this.myModifierKeyCode || (modifiers & modifierMask) == 0;
                }
            });
        }

        private void handleModifier(KeyEvent event) {
            if (((AtomicBoolean)this.ourPressed.first).get() && event.getWhen() - this.ourLastTimePressed.get() > 300L) {
                this.resetState();
                return;
            }
            if (event.getID() == 401) {
                if (!((AtomicBoolean)this.ourPressed.first).get()) {
                    this.resetState();
                    ((AtomicBoolean)this.ourPressed.first).set(true);
                    this.ourLastTimePressed.set(event.getWhen());
                    return;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get()) {
                    ((AtomicBoolean)this.ourPressed.second).set(true);
                    this.ourLastTimePressed.set(event.getWhen());
                    return;
                }
            } else if (event.getID() == 402) {
                if (((AtomicBoolean)this.ourPressed.first).get() && !((AtomicBoolean)this.ourReleased.first).get()) {
                    ((AtomicBoolean)this.ourReleased.first).set(true);
                    this.ourLastTimePressed.set(event.getWhen());
                    return;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get() && ((AtomicBoolean)this.ourPressed.second).get()) {
                    this.resetState();
                    if (this.myActionKeyCode == -1 && !this.shouldSkipIfActionHasShortcut()) {
                        this.run(event);
                    }
                    return;
                }
            }
            this.resetState();
        }

        private void resetState() {
            ((AtomicBoolean)this.ourPressed.first).set(false);
            ((AtomicBoolean)this.ourPressed.second).set(false);
            ((AtomicBoolean)this.ourReleased.first).set(false);
            ((AtomicBoolean)this.ourReleased.second).set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean run(KeyEvent event) {
            ModifierKeyDoubleClickHandler.this.myIsRunningAction = true;
            try {
                Window focusedWindow;
                ActionManagerEx ex = ActionManagerEx.getInstanceEx();
                AnAction action2 = ex.getAction(this.myActionId);
                if (action2 == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!action2.isEnabledInModalContext() && (focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) != null && IdeKeyEventDispatcher.isModalContext(focusedWindow)) {
                    boolean bl = false;
                    return bl;
                }
                DataContext context = this.calculateContext();
                AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)event, (String)"keyboard shortcut", (DataContext)context);
                action2.update(anActionEvent);
                if (!anActionEvent.getPresentation().isEnabled()) {
                    boolean bl = false;
                    return bl;
                }
                ex.fireBeforeActionPerformed(action2, anActionEvent.getDataContext(), anActionEvent);
                action2.actionPerformed(anActionEvent);
                ex.fireAfterActionPerformed(action2, anActionEvent.getDataContext(), anActionEvent);
                ActionsCollector.getInstance().record("DoubleShortcut", anActionEvent.getInputEvent(), action2.getClass());
                boolean bl = true;
                return bl;
            }
            finally {
                ModifierKeyDoubleClickHandler.this.myIsRunningAction = false;
            }
        }

        @NotNull
        private DataContext calculateContext() {
            IdeFocusManager focusManager = IdeFocusManager.findInstance();
            Component focusedComponent = focusManager.getFocusOwner();
            Window ideWindow = focusManager.getLastFocusedIdeWindow();
            return ideWindow == focusedComponent || focusedComponent == focusManager.getLastFocusedFor(ideWindow) ? DataManager.getInstance().getDataContext(focusedComponent) : DataManager.getInstance().getDataContext();
        }

        private boolean shouldSkipIfActionHasShortcut() {
            return this.mySkipIfActionHasShortcut && KeymapUtil.getActiveKeymapShortcuts((String)this.myActionId).getShortcuts().length > 0;
        }

        public String toString() {
            return "modifier double-click dispatcher [modifierKeyCode=" + this.myModifierKeyCode + ",actionKeyCode=" + this.myActionKeyCode + ",actionId=" + this.myActionId + "]";
        }
    }
}

