/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class TypeEditor<T extends UserFileType<T>>
extends DialogWrapper {
    private final T myFileType;
    private final SettingsEditor<T> myEditor;

    TypeEditor(@NotNull Component parent, @NotNull T fileType, @NotNull @NlsContexts.DialogTitle String title) {
        super(parent, false);
        this.myFileType = fileType;
        this.myEditor = fileType.getEditor();
        this.setTitle(title);
        this.init();
        Disposer.register((Disposable)this.myDisposable, this.myEditor);
    }

    protected void init() {
        super.init();
        this.myEditor.resetFrom(this.myFileType);
    }

    protected JComponent createCenterPanel() {
        return this.myEditor.getComponent();
    }

    protected void doOKAction() {
        try {
            this.myEditor.applyTo(this.myFileType);
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)e.getTitle());
            return;
        }
        super.doOKAction();
    }

    protected String getHelpId() {
        return "reference.dialogs.newfiletype";
    }
}

