/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.FilteredPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class OpenFilesScope
extends NamedScope {
    public static final OpenFilesScope INSTANCE = new OpenFilesScope();

    private OpenFilesScope() {
        super(OpenFilesScope.getNameText(), AllIcons.FileTypes.Any_type, (PackageSet)new FilteredPackageSet(OpenFilesScope.getNameText()){

            public boolean contains(@NotNull VirtualFile file2, @NotNull Project project) {
                FileEditorManager manager = project.isDisposed() ? null : FileEditorManager.getInstance((Project)project);
                return manager != null && manager.isFileOpen(file2);
            }
        });
    }

    public static String getNameText() {
        return IdeBundle.message((String)"scope.open.files", (Object[])new Object[0]);
    }

    public static final class Provider
    implements CustomScopesProvider {
        @NotNull
        public List<NamedScope> getCustomScopes() {
            return Collections.singletonList(INSTANCE);
        }
    }
}

