/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonProjectFileWritingAccessDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JLabel myListTitle;
    private JList<VirtualFile> myFileList;
    private JRadioButton myUnlockOneButton;
    private JRadioButton myUnlockDirButton;
    private JRadioButton myUnlockAllButton;

    public NonProjectFileWritingAccessDialog(@NotNull Project project, @NotNull List<? extends VirtualFile> nonProjectFiles) {
        this(project, nonProjectFiles, "Non-Project Files");
    }

    public NonProjectFileWritingAccessDialog(@NotNull Project project, @NotNull List<? extends VirtualFile> nonProjectFiles, @NotNull String filesType) {
        super(project);
        Object[] objectArray = new Object[]{filesType};
        this.$$$setupUI$$$();
        this.setTitle(IdeBundle.message((String)"dialog.title.0.protection", (Object[])objectArray));
        this.myFileList.setPreferredSize(ReadOnlyStatusDialog.getDialogPreferredSize());
        this.myFileList.setCellRenderer((ListCellRenderer<VirtualFile>)((Object)new FileListRenderer()));
        this.myFileList.setModel((ListModel<VirtualFile>)new CollectionListModel(nonProjectFiles));
        String theseFilesMessage = ReadOnlyStatusDialog.getTheseFilesMessage(nonProjectFiles);
        this.myListTitle.setText(IdeBundle.message((String)"label.0.1.not.belong.to.the.project", (Object[])new Object[]{StringUtil.capitalize((String)theseFilesMessage), nonProjectFiles.size()}));
        this.myUnlockOneButton.setSelected(true);
        this.setTextAndMnemonicAndListeners(this.myUnlockOneButton, "I want to edit " + theseFilesMessage + " anyway", "edit");
        int dirs = ContainerUtil.map2Set(nonProjectFiles, VirtualFile::getParent).size();
        this.setTextAndMnemonicAndListeners(this.myUnlockDirButton, "I want to edit all files in " + StringUtil.pluralize((String)"this", (int)dirs) + " " + StringUtil.pluralize((String)"directory", (int)dirs), "dir");
        this.setTextAndMnemonicAndListeners(this.myUnlockAllButton, "I want to edit any non-project file in the current session", "any");
        this.getRootPane().registerKeyboardAction(e -> this.doOKAction(), KeyStroke.getKeyStroke(10, 128), 1);
        this.getRootPane().registerKeyboardAction(e -> this.doOKAction(), KeyStroke.getKeyStroke(10, 256), 1);
        this.init();
    }

    private void setTextAndMnemonicAndListeners(JRadioButton button2, String text, String mnemonic) {
        button2.setText(text);
        button2.setMnemonic(mnemonic.charAt(0));
        button2.setDisplayedMnemonicIndex(button2.getText().indexOf(mnemonic));
        Runnable setDefaultButton = () -> {
            JRootPane rootPane = button2.getRootPane();
            if (rootPane != null) {
                rootPane.setDefaultButton(this.getButton(this.getOKAction()));
            }
        };
        button2.addActionListener(e -> setDefaultButton.run());
        button2.addItemListener(e -> setDefaultButton.run());
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUnlockOneButton;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    public NonProjectFileWritingAccessProvider.UnlockOption getUnlockOption() {
        if (this.myUnlockAllButton.isSelected()) {
            return NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK_ALL;
        }
        if (this.myUnlockDirButton.isSelected()) {
            return NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK_DIR;
        }
        return NonProjectFileWritingAccessProvider.UnlockOption.UNLOCK;
    }

    protected String getHelpId() {
        return "Non-Project_Files_Access_Dialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        this.myUnlockOneButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/IdeBundle", NonProjectFileWritingAccessDialog.class).getString("radio.button.unlock.one"));
        jPanel3.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUnlockAllButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/IdeBundle", NonProjectFileWritingAccessDialog.class).getString("radio.button.unlock.all"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUnlockDirButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/IdeBundle", NonProjectFileWritingAccessDialog.class).getString("radio.button.unlock.dir"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myListTitle = jLabel = new JLabel();
        jLabel.setText("title");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myFileList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton3);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

