/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final Logger LOG = Logger.getInstance(LoadTextUtil.class);
    private static final int UNLIMITED = -1;
    private static final Charset INTERNAL_SEVEN_BIT_UTF8 = new SevenBitCharset(StandardCharsets.UTF_8);
    private static final Charset INTERNAL_SEVEN_BIT_ISO_8859_1 = new SevenBitCharset(CharsetToolkit.ISO_8859_1_CHARSET);
    private static final Charset INTERNAL_SEVEN_BIT_WIN_1251 = new SevenBitCharset(CharsetToolkit.WIN_1251_CHARSET);
    private static final boolean GUESS_UTF = Boolean.parseBoolean(System.getProperty("idea.guess.utf.encoding", "true"));
    private static final Key<AutoDetectionReason> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create((String)"CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static ConvertResult convertLineSeparatorsToSlashN(@NotNull CharBuffer buffer) {
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        CharBuffer result2 = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        return new ConvertResult(result2, crCount, lfCount, crlfCount);
    }

    @NotNull
    private static ConvertResult convertLineSeparatorsToSlashN(byte @NotNull [] charsAsBytes, int startOffset, int endOffset) {
        int crIndex = LoadTextUtil.indexOf(charsAsBytes, (byte)13, startOffset, endOffset);
        if (crIndex == -1) {
            ByteArrayCharSequence sequence = new ByteArrayCharSequence(charsAsBytes, startOffset, endOffset);
            int lfIndex = LoadTextUtil.indexOf(charsAsBytes, (byte)10, startOffset, endOffset);
            return new ConvertResult((CharSequence)sequence, 0, lfIndex == -1 ? 0 : 1, 0);
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        byte[] result2 = new byte[endOffset - startOffset];
        for (int src = startOffset; src < endOffset; ++src) {
            char c = (char)charsAsBytes[src];
            switch (c) {
                case '\r': {
                    result2[dst++] = 10;
                    ++crCount;
                    break;
                }
                case '\n': {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    result2[dst++] = 10;
                    ++lfCount;
                    break;
                }
                default: {
                    result2[dst++] = (byte)c;
                }
            }
            prev = c;
        }
        ByteArrayCharSequence sequence = new ByteArrayCharSequence(result2, 0, dst);
        return new ConvertResult((CharSequence)sequence, crCount, lfCount, crlfCount);
    }

    private static int indexOf(byte[] ints, byte value2, int start2, int end) {
        for (int i2 = start2; i2 < end; ++i2) {
            if (ints[i2] != value2) continue;
            return i2;
        }
        return -1;
    }

    @NotNull
    private static DetectResult detectHardCharset(@NotNull VirtualFile virtualFile, byte @NotNull [] content2, int length, @NotNull FileType fileType) {
        Charset hardCodedCharset;
        String charsetName = fileType.getCharset(virtualFile, content2);
        DetectResult guessed = LoadTextUtil.guessFromContent(virtualFile, content2, length);
        Charset charset = hardCodedCharset = charsetName == null ? guessed.hardCodedCharset : CharsetToolkit.forName((String)charsetName);
        if (hardCodedCharset == null && guessed.guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            return new DetectResult(StandardCharsets.UTF_8, guessed.guessed, guessed.BOM);
        }
        return new DetectResult(hardCodedCharset, guessed.guessed, guessed.BOM);
    }

    @NotNull
    public static Charset detectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, byte @NotNull [] content2, @NotNull FileType fileType) {
        Charset internalCharset = LoadTextUtil.detectInternalCharsetAndSetBOM((VirtualFile)virtualFile, (byte[])content2, (int)content2.length, (boolean)true, (FileType)fileType).hardCodedCharset;
        return internalCharset instanceof SevenBitCharset ? ((SevenBitCharset)internalCharset).myBaseCharset : internalCharset;
    }

    @NotNull
    private static Charset getDefaultCharsetFromEncodingManager(@NotNull VirtualFile virtualFile) {
        Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile, true);
        return (Charset)ObjectUtils.notNull((Object)specifiedExplicitly, (Object)EncodingRegistry.getInstance().getDefaultCharset());
    }

    @NotNull
    private static DetectResult detectInternalCharsetAndSetBOM(@NotNull VirtualFile file2, byte @NotNull [] content2, int length, boolean saveBOM, @NotNull FileType fileType) {
        DetectResult info = LoadTextUtil.detectHardCharset(file2, content2, length, fileType);
        Charset charset = info.hardCodedCharset == null ? (file2.isCharsetSet() ? file2.getCharset() : LoadTextUtil.getDefaultCharsetFromEncodingManager(file2)) : info.hardCodedCharset;
        byte[] bom = info.BOM;
        if (saveBOM && bom != null && bom.length != 0) {
            file2.setBOM(bom);
            LoadTextUtil.setCharsetAutoDetectionReason(file2, AutoDetectionReason.FROM_BOM);
        }
        file2.setCharset(charset);
        Charset result2 = charset;
        if (info.guessed == CharsetToolkit.GuessedEncoding.SEVEN_BIT) {
            if (charset == StandardCharsets.UTF_8) {
                result2 = INTERNAL_SEVEN_BIT_UTF8;
            } else if (charset == CharsetToolkit.ISO_8859_1_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_ISO_8859_1;
            } else if (charset == CharsetToolkit.WIN_1251_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_WIN_1251;
            }
        }
        return new DetectResult(result2, info.guessed, bom);
    }

    @NotNull
    public static DetectResult guessFromContent(@NotNull VirtualFile virtualFile, byte @NotNull [] content2) {
        return LoadTextUtil.guessFromContent(virtualFile, content2, content2.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static DetectResult guessFromContent(@NotNull VirtualFile virtualFile, byte @NotNull [] content2, int length) {
        DetectResult detectResult;
        AutoDetectionReason detectedFromBytes = null;
        try {
            DetectResult info;
            if (GUESS_UTF) {
                info = LoadTextUtil.guessFromBytes(content2, 0, length, LoadTextUtil.getDefaultCharsetFromEncodingManager(virtualFile));
                if (info.BOM != null) {
                    detectedFromBytes = AutoDetectionReason.FROM_BOM;
                } else if (info.guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
                    detectedFromBytes = AutoDetectionReason.FROM_BYTES;
                }
            } else {
                info = new DetectResult(null, null, null);
            }
            detectResult = info;
        }
        catch (Throwable throwable) {
            LoadTextUtil.setCharsetAutoDetectionReason(virtualFile, detectedFromBytes);
            throw throwable;
        }
        LoadTextUtil.setCharsetAutoDetectionReason(virtualFile, detectedFromBytes);
        return detectResult;
    }

    @NotNull
    private static DetectResult guessFromBytes(byte @NotNull [] content2, int startOffset, int endOffset, @NotNull Charset defaultCharset) {
        CharsetToolkit toolkit = new CharsetToolkit(content2, defaultCharset);
        toolkit.setEnforce8Bit(true);
        Charset charset = toolkit.guessFromBOM();
        if (charset != null) {
            byte[] bom = (byte[])ObjectUtils.notNull((Object)CharsetToolkit.getMandatoryBom((Charset)charset), (Object)CharsetToolkit.UTF8_BOM);
            return new DetectResult(charset, null, bom);
        }
        CharsetToolkit.GuessedEncoding guessed = toolkit.guessFromContent(startOffset, endOffset);
        if (guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            return new DetectResult(StandardCharsets.UTF_8, CharsetToolkit.GuessedEncoding.VALID_UTF8, null);
        }
        return new DetectResult(null, guessed, null);
    }

    public static String getTextFromBytesOrNull(byte @NotNull [] bytes, int startOffset, int endOffset) {
        Charset charset;
        Charset defaultCharset = EncodingManager.getInstance().getDefaultCharset();
        DetectResult info = LoadTextUtil.guessFromBytes(bytes, startOffset, endOffset, defaultCharset);
        if (info.hardCodedCharset != null) {
            charset = info.hardCodedCharset;
        } else {
            switch (info.guessed) {
                case SEVEN_BIT: {
                    charset = CharsetToolkit.US_ASCII_CHARSET;
                    break;
                }
                case VALID_UTF8: {
                    charset = StandardCharsets.UTF_8;
                    break;
                }
                case INVALID_UTF8: 
                case BINARY: {
                    return null;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(info.guessed));
                }
            }
        }
        byte[] bom = info.BOM;
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(startOffset + (bom == null ? 0 : bom.length), endOffset), endOffset, charset);
        return result2.text.toString();
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> getOverriddenCharsetByBOM(byte @NotNull [] content2, @NotNull Charset charset) {
        if (charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom((byte[])content2)) {
            return Pair.createNonNull((Object)charset, (Object)CharsetToolkit.UTF8_BOM);
        }
        Charset charsetFromBOM = CharsetToolkit.guessFromBOM((byte[])content2);
        if (charsetFromBOM != null) {
            byte[] bom = (byte[])ObjectUtils.notNull((Object)CharsetToolkit.getMandatoryBom((Charset)charsetFromBOM), (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY);
            return Pair.createNonNull((Object)charsetFromBOM, (Object)bom);
        }
        return Pair.createNonNull((Object)charset, (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY);
    }

    public static void changeLineSeparators(@Nullable Project project, @NotNull VirtualFile file2, @NotNull String newSeparator, @NotNull Object requestor) throws IOException {
        CharSequence currentText = LoadTextUtil.getTextByBinaryPresentation(file2.contentsToByteArray(), file2, true, false);
        String newText = StringUtil.convertLineSeparators((String)currentText.toString(), (String)newSeparator);
        file2.setDetectedLineSeparator(newSeparator);
        LoadTextUtil.write(project, file2, requestor, newText, -1L);
    }

    public static void write(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull Object requestor, @NotNull String text, long newModificationStamp) throws IOException {
        Charset existing = virtualFile.getCharset();
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project, virtualFile, text, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (!charset.equals(existing)) {
            virtualFile.setCharset(charset);
        }
        LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile, buffer);
        virtualFile.setBinaryContent(buffer, newModificationStamp, -1L, requestor);
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> charsetForWriting(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text, @NotNull Charset existing) {
        Charset fromBom;
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile, text);
        Pair.NonNull chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM((byte[])bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.createNonNull((Object)fromBom, (Object)text.getBytes(fromBom));
        }
        return chosen;
    }

    private static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile, byte @NotNull [] content2) {
        if (virtualFile.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile, content2);
        } else {
            LoadTextUtil.setCharsetAutoDetectionReason(virtualFile, AutoDetectionReason.FROM_BOM);
        }
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> chooseMostlyHarmlessCharset(@NotNull Charset existing, @NotNull Charset specified, @NotNull String text) {
        try {
            if (specified.equals(existing)) {
                return Pair.createNonNull((Object)specified, (Object)text.getBytes(existing));
            }
            byte[] out = LoadTextUtil.isSupported(specified, text);
            if (out != null) {
                return Pair.createNonNull((Object)specified, (Object)out);
            }
            out = LoadTextUtil.isSupported(existing, text);
            if (out != null) {
                return Pair.createNonNull((Object)existing, (Object)out);
            }
            return Pair.createNonNull((Object)specified, (Object)text.getBytes(specified));
        }
        catch (RuntimeException e) {
            Charset defaultCharset = Charset.defaultCharset();
            return Pair.createNonNull((Object)defaultCharset, (Object)text.getBytes(defaultCharset));
        }
    }

    private static byte @Nullable(value="null means not supported, otherwise it is converted byte stream") [] isSupported(@NotNull Charset charset, @NotNull String str) {
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        return (Charset)ObjectUtils.notNull((Object)LoadTextUtil.charsetFromContentOrNull(project, virtualFile, text), (Object)virtualFile.getCharset());
    }

    @Nullable(value="returns null if cannot determine from content")
    public static @Nullable(value="returns null if cannot determine from content") Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        return CharsetUtil.extractCharsetFromFileContent((Project)project, (VirtualFile)virtualFile, (FileType)virtualFile.getFileType(), (CharSequence)text);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file2) {
        FileType type = file2.getFileType();
        if (type.isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.getInstance().forFileType(type);
            if (decompiler != null) {
                CharSequence text = decompiler.decompile(file2);
                try {
                    StringUtil.assertValidSeparators((CharSequence)text);
                }
                catch (AssertionError e) {
                    LOG.error((Throwable)((Object)e));
                }
                return text;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file which doesn't have a decompiler plugged in: " + file2.getPresentableUrl() + ". File type: " + type.getName());
        }
        return LoadTextUtil.loadText(file2, -1);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file2, int limit) {
        FileType type = file2.getFileType();
        if (type.isBinary()) {
            throw new IllegalArgumentException("Attempt to load truncated text for binary file: " + file2.getPresentableUrl() + ". File type: " + type.getName());
        }
        if (file2 instanceof LightVirtualFile) {
            return LoadTextUtil.limitCharSequence(((LightVirtualFile)file2).getContent(), limit);
        }
        if (file2.isDirectory()) {
            throw new AssertionError((Object)("'" + file2.getPresentableUrl() + "' is a directory"));
        }
        try {
            byte[] bytes = limit == -1 ? file2.contentsToByteArray() : FileUtil.loadFirstAndClose((InputStream)file2.getInputStream(), (int)limit);
            return LoadTextUtil.getTextByBinaryPresentation(bytes, file2);
        }
        catch (IOException e) {
            return Strings.EMPTY_CHAR_SEQUENCE;
        }
    }

    @NotNull
    private static CharSequence limitCharSequence(@NotNull CharSequence sequence, int limit) {
        return limit == -1 ? sequence : sequence.subSequence(0, Math.min(limit, sequence.length()));
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(byte @NotNull [] bytes, @NotNull VirtualFile virtualFile) {
        return LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, true, true);
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(byte @NotNull [] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM) {
        DetectResult info = LoadTextUtil.detectInternalCharsetAndSetBOM(virtualFile, bytes, bytes.length, saveBOM, virtualFile.getFileType());
        ConvertResult result2 = LoadTextUtil.convertBytesAndSetSeparator(bytes, bytes.length, virtualFile, saveDetectedSeparators, info, info.hardCodedCharset);
        return result2.text;
    }

    @NotNull
    static Set<String> detectAllLineSeparators(@NotNull VirtualFile virtualFile) {
        byte[] bytes;
        try {
            bytes = virtualFile.contentsToByteArray();
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
        DetectResult info = LoadTextUtil.detectInternalCharsetAndSetBOM(virtualFile, bytes, bytes.length, false, virtualFile.getFileType());
        byte[] bom = info.BOM;
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(bom == null ? 0 : bom.length, bytes.length), bytes.length, info.hardCodedCharset);
        return result2.allLineSeparators();
    }

    @NotNull
    public static FileType processTextFromBinaryPresentationOrNull(byte @NotNull [] bytes, int length, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM, @NotNull FileType fileType, @NotNull NotNullFunction<? super CharSequence, ? extends FileType> fileTextProcessor) {
        CharSequence toProcess2;
        DetectResult info = LoadTextUtil.detectInternalCharsetAndSetBOM(virtualFile, bytes, length, saveBOM, fileType);
        Charset internalCharset = info.hardCodedCharset;
        CharsetToolkit.GuessedEncoding guessed = info.guessed;
        if (internalCharset == null || guessed == CharsetToolkit.GuessedEncoding.BINARY || guessed == CharsetToolkit.GuessedEncoding.INVALID_UTF8) {
            toProcess2 = null;
        } else {
            ConvertResult result2 = LoadTextUtil.convertBytesAndSetSeparator(bytes, length, virtualFile, saveDetectedSeparators, info, internalCharset);
            toProcess2 = result2.text;
        }
        return (FileType)fileTextProcessor.fun(toProcess2);
    }

    @NotNull
    private static ConvertResult convertBytesAndSetSeparator(byte @NotNull [] bytes, int length, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, @NotNull DetectResult info, @NotNull Charset internalCharset) {
        String separator;
        byte[] bom = info.BOM;
        int BOMEndOffset = Math.min(length, bom == null ? 0 : bom.length);
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, BOMEndOffset, length, internalCharset);
        if (saveDetectedSeparators && (separator = result2.majorLineSeparator()) != null) {
            virtualFile.setDetectedLineSeparator(separator);
        }
        return result2;
    }

    @Nullable
    public static String detectLineSeparator(@NotNull VirtualFile file2, boolean checkFile) {
        String lineSeparator = file2.getDetectedLineSeparator();
        if (lineSeparator == null && checkFile) {
            try {
                LoadTextUtil.getTextByBinaryPresentation(file2.contentsToByteArray(), file2);
                lineSeparator = file2.getDetectedLineSeparator();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lineSeparator;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(byte @NotNull [] bytes, @NotNull Charset charset) {
        Pair.NonNull<Charset, byte[]> pair = LoadTextUtil.getOverriddenCharsetByBOM(bytes, charset);
        byte[] bom = (byte[])pair.getSecond();
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(bom.length, bytes.length), bytes.length, (Charset)pair.first);
        return result2.text;
    }

    @NotNull
    private static ConvertResult convertBytes(byte @NotNull [] bytes, int startOffset, int endOffset, @NotNull Charset internalCharset) {
        CharBuffer charBuffer;
        assert (startOffset >= 0 && startOffset <= endOffset && endOffset <= bytes.length) : startOffset + "," + endOffset + ": " + bytes.length;
        if (internalCharset instanceof SevenBitCharset || internalCharset == CharsetToolkit.US_ASCII_CHARSET) {
            return LoadTextUtil.convertLineSeparatorsToSlashN(bytes, startOffset, endOffset);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, endOffset - startOffset);
        try {
            charBuffer = internalCharset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtilRt.EMPTY_CHAR_ARRAY);
        }
        return LoadTextUtil.convertLineSeparatorsToSlashN(charBuffer);
    }

    @Nullable(value="null if was not detected, otherwise the reason it was")
    public static @Nullable(value="null if was not detected, otherwise the reason it was") AutoDetectionReason getCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile) {
        return (AutoDetectionReason)((Object)virtualFile.getUserData(CHARSET_WAS_DETECTED_FROM_BYTES));
    }

    private static void setCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile, @Nullable(value="null if was not detected, otherwise the reason it was") @Nullable(value="null if was not detected, otherwise the reason it was") AutoDetectionReason reason) {
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, (Object)reason);
    }

    public static void clearCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile) {
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, null);
    }

    private static class ConvertResult {
        @NotNull
        private final CharSequence text;
        private final int CR_count;
        private final int LF_count;
        private final int CRLF_count;

        ConvertResult(@NotNull CharSequence text, int CR_count, int LF_count, int CRLF_count) {
            this.text = text;
            this.CR_count = CR_count;
            this.LF_count = LF_count;
            this.CRLF_count = CRLF_count;
        }

        String majorLineSeparator() {
            String detectedLineSeparator = null;
            if (this.CRLF_count > this.CR_count && this.CRLF_count > this.LF_count) {
                detectedLineSeparator = "\r\n";
            } else if (this.CR_count > this.LF_count) {
                detectedLineSeparator = "\r";
            } else if (this.LF_count > 0) {
                detectedLineSeparator = "\n";
            }
            return detectedLineSeparator;
        }

        @NotNull
        Set<String> allLineSeparators() {
            THashSet result2 = new THashSet();
            if (this.CR_count > 0) {
                result2.add(LineSeparator.CR.getSeparatorString());
            }
            if (this.LF_count > 0) {
                result2.add(LineSeparator.LF.getSeparatorString());
            }
            if (this.CRLF_count > 0) {
                result2.add(LineSeparator.CRLF.getSeparatorString());
            }
            return result2;
        }
    }

    public static class DetectResult {
        public final Charset hardCodedCharset;
        public final CharsetToolkit.GuessedEncoding guessed;
        public final byte @Nullable [] BOM;

        DetectResult(Charset hardCodedCharset, CharsetToolkit.GuessedEncoding guessed, byte @Nullable [] BOM) {
            this.hardCodedCharset = hardCodedCharset;
            this.guessed = guessed;
            this.BOM = BOM;
        }
    }

    private static class SevenBitCharset
    extends Charset {
        private final Charset myBaseCharset;

        SevenBitCharset(@NotNull Charset baseCharset) {
            super("IJ__7BIT_" + baseCharset.name(), ArrayUtilRt.EMPTY_STRING_ARRAY);
            this.myBaseCharset = baseCharset;
        }

        @Override
        public boolean contains(Charset cs) {
            throw new IllegalStateException();
        }

        @Override
        public CharsetDecoder newDecoder() {
            throw new IllegalStateException();
        }

        @Override
        public CharsetEncoder newEncoder() {
            throw new IllegalStateException();
        }
    }

    public static enum AutoDetectionReason {
        FROM_BOM,
        FROM_BYTES;

    }
}

