/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import org.jetbrains.annotations.NotNull;

public final class FileEditorPsiTreeChangeListener
extends PsiTreeChangeAdapter {
    private static final Logger LOG = Logger.getInstance(FileEditorPsiTreeChangeListener.class);
    private final Project myProject;

    public FileEditorPsiTreeChangeListener(Project project) {
        this.myProject = project;
        if (this.myProject.isDefault()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent e) {
        if ("roots".equals(e.getPropertyName())) {
            ApplicationManager.getApplication().assertIsWriteThread();
            FileEditorManagerEx fileEditorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject);
            VirtualFile[] openFiles = fileEditorManager.getOpenFiles();
            for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
                VirtualFile file2 = openFiles[i2];
                LOG.assertTrue(file2 != null);
                fileEditorManager.updateFilePresentation(file2);
            }
        }
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        this.doChange(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        this.doChange(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        this.doChange(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        this.doChange(event);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        this.doChange(event);
    }

    private void doChange(PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            return;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return;
        }
        FileEditorManagerEx fileEditorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject);
        FileEditor[] editors = fileEditorManager.getAllEditors(file2);
        if (editors.length == 0) {
            return;
        }
        VirtualFile currentFile = fileEditorManager.getCurrentFile();
        if (currentFile != null && Comparing.equal((Object)psiFile.getVirtualFile(), (Object)currentFile)) {
            fileEditorManager.updateFilePresentation(currentFile);
        }
    }
}

