/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileChooserUtil {
    private static final String LAST_OPENED_FILE_PATH = "last_opened_file_path";

    @Nullable
    public static VirtualFile getLastOpenedFile(@Nullable Project project) {
        String path = project == null ? PropertiesComponent.getInstance().getValue(LAST_OPENED_FILE_PATH) : PropertiesComponent.getInstance((Project)project).getValue(LAST_OPENED_FILE_PATH);
        return path != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    @Deprecated
    public static void setLastOpenedFile(@Nullable Project project, @Nullable VirtualFile file2) {
        if (file2 == null) {
            return;
        }
        if (project == null) {
            PropertiesComponent.getInstance().setValue(LAST_OPENED_FILE_PATH, file2.getPath());
        } else if (!project.isDisposed()) {
            PropertiesComponent.getInstance((Project)project).setValue(LAST_OPENED_FILE_PATH, file2.getPath());
        }
    }

    public static void setLastOpenedFile(@Nullable Project project, @NotNull Path file2) {
        if (project == null) {
            PropertiesComponent.getInstance().setValue(LAST_OPENED_FILE_PATH, FileUtil.toSystemIndependentName((String)file2.toString()));
        } else if (!project.isDisposed()) {
            PropertiesComponent.getInstance((Project)project).setValue(LAST_OPENED_FILE_PATH, FileUtil.toSystemIndependentName((String)file2.toString()));
        }
    }

    @Nullable
    public static VirtualFile getFileToSelect(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @Nullable VirtualFile toSelect2, @Nullable VirtualFile lastPath) {
        boolean chooseDir = descriptor2 instanceof FileSaverDescriptor;
        VirtualFile result2 = toSelect2 == null && lastPath == null ? (project == null || project.isDefault() ? null : ProjectUtil.guessProjectDir((Project)project)) : (toSelect2 != null && lastPath != null ? (Boolean.TRUE.equals(descriptor2.getUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT)) ? lastPath : toSelect2) : (toSelect2 == null ? lastPath : toSelect2));
        if (result2 != null) {
            if (chooseDir && !result2.isDirectory()) {
                result2 = result2.getParent();
            }
        } else if (SystemInfo.isUnix) {
            result2 = VfsUtil.getUserHomeDir();
        }
        return result2;
    }

    @NotNull
    public static List<VirtualFile> getChosenFiles(@NotNull FileChooserDescriptor descriptor2, @NotNull List<? extends VirtualFile> selectedFiles) {
        return ContainerUtil.mapNotNull(selectedFiles, (Function)((NullableFunction)file2 -> file2 != null && file2.isValid() ? descriptor2.getFileToSelect(file2) : null));
    }
}

