/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class FileTextFieldUtil {
    private static final Logger LOG = Logger.getInstance(FileTextFieldUtil.class);

    public static void processCompletion(final FileTextFieldImpl.CompletionResult result2, @NotNull FileLookup.Finder finder, final @NotNull FileLookup.LookupFilter filter2, @NotNull String fileSpitRegExp, @NotNull Map<String, String> macroMap) {
        result2.myToComplete = new ArrayList<FileLookup.LookupFile>();
        result2.mySiblings = new ArrayList<FileLookup.LookupFile>();
        result2.myKidsAfterSeparator = new ArrayList<FileLookup.LookupFile>();
        final String typed = result2.myCompletionBase;
        if (typed == null) {
            return;
        }
        FileTextFieldImpl.addMacroPaths(result2, typed, finder, macroMap);
        String typedText = finder.normalize(typed);
        result2.myClosestParent = result2.current = FileTextFieldUtil.getClosestParent(typed, finder, fileSpitRegExp);
        if (result2.current != null) {
            String currentGrandparentText;
            result2.currentParentMatch = SystemInfo.isFileSystemCaseSensitive ? typedText.equals(result2.current.getAbsolutePath()) : typedText.equalsIgnoreCase(result2.current.getAbsolutePath());
            result2.closedPath = typed.endsWith(finder.getSeparator()) && typedText.length() > finder.getSeparator().length();
            String currentParentText = result2.current.getAbsolutePath();
            if (!StringUtil.toUpperCase((String)typedText).startsWith(StringUtil.toUpperCase((String)currentParentText))) {
                return;
            }
            String prefix = typedText.substring(currentParentText.length());
            if (prefix.startsWith(finder.getSeparator())) {
                prefix = prefix.substring(finder.getSeparator().length());
            } else if (typed.endsWith(finder.getSeparator())) {
                prefix = "";
            }
            result2.effectivePrefix = prefix;
            result2.currentGrandparent = result2.current.getParent();
            if (result2.currentGrandparent != null && result2.currentParentMatch && !result2.closedPath && StringUtil.startsWithConcatenation((String)typedText, (String[])new String[]{currentGrandparentText = result2.currentGrandparent.getAbsolutePath(), finder.getSeparator()})) {
                result2.grandparentPrefix = currentParentText.substring(currentGrandparentText.length() + finder.getSeparator().length());
            }
        } else {
            result2.effectivePrefix = typedText;
        }
        ReadAction.run((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(){

            public void run() {
                if (result2.current != null) {
                    result2.myToComplete.addAll(this.getMatchingChildren(result2.effectivePrefix, result2.current));
                    if (result2.currentParentMatch && !result2.closedPath && !typed.isEmpty()) {
                        result2.myKidsAfterSeparator.addAll(result2.myToComplete);
                    }
                    if (result2.grandparentPrefix != null) {
                        List<FileLookup.LookupFile> siblings = this.getMatchingChildren(result2.grandparentPrefix, result2.currentGrandparent);
                        result2.myToComplete.addAll(0, siblings);
                        result2.mySiblings.addAll(siblings);
                    }
                }
                int currentDiff = Integer.MIN_VALUE;
                FileLookup.LookupFile toPreselect = result2.myPreselected;
                if (toPreselect == null || !result2.myToComplete.contains(toPreselect)) {
                    boolean toPreselectFixed = false;
                    if (result2.effectivePrefix.length() > 0) {
                        for (FileLookup.LookupFile each : result2.myToComplete) {
                            int diff;
                            String eachName = StringUtil.toUpperCase((String)each.getName());
                            if (!eachName.startsWith(result2.effectivePrefix) || (currentDiff = Math.max(diff = result2.effectivePrefix.compareTo(eachName), currentDiff)) != diff) continue;
                            toPreselect = each;
                            toPreselectFixed = true;
                            break;
                        }
                        if (!toPreselectFixed) {
                            toPreselect = null;
                        }
                    } else {
                        toPreselect = null;
                    }
                    if (toPreselect == null) {
                        if (result2.myToComplete.size() == 1) {
                            toPreselect = result2.myToComplete.get(0);
                        } else if (result2.effectivePrefix.length() == 0 && result2.mySiblings.size() > 0) {
                            toPreselect = result2.mySiblings.get(0);
                        }
                        if (toPreselect == null && !result2.myToComplete.contains(toPreselect) && result2.myToComplete.size() > 0) {
                            toPreselect = result2.myToComplete.get(0);
                        }
                    }
                }
                if (result2.currentParentMatch && result2.mySiblings.size() > 0) {
                    toPreselect = null;
                }
                result2.myPreselected = toPreselect;
            }

            private List<FileLookup.LookupFile> getMatchingChildren(String prefix, FileLookup.LookupFile parent) {
                final MinusculeMatcher matcher = FileTextFieldUtil.createMatcher(prefix);
                return parent.getChildren(new FileLookup.LookupFilter(){

                    @Override
                    public boolean isAccepted(FileLookup.LookupFile file2) {
                        return !file2.equals(result2.current) && filter2.isAccepted(file2) && matcher.matches(file2.getName());
                    }
                });
            }
        });
    }

    static MinusculeMatcher createMatcher(String prefix) {
        return NameUtil.buildMatcher((String)("*" + prefix), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    @Nullable
    private static FileLookup.LookupFile getClosestParent(String typed, FileLookup.Finder finder, String fileSpitRegExp) {
        if (typed == null) {
            return null;
        }
        FileLookup.LookupFile lastFound = finder.find(typed);
        if (lastFound == null) {
            return null;
        }
        if (typed.isEmpty()) {
            return lastFound;
        }
        if (lastFound.exists()) {
            if (typed.charAt(typed.length() - 1) != File.separatorChar) {
                return lastFound.getParent();
            }
            return lastFound;
        }
        String[] splits = finder.normalize(typed).split(fileSpitRegExp);
        StringBuilder fullPath = new StringBuilder();
        for (int i2 = 0; i2 < splits.length; ++i2) {
            FileLookup.LookupFile file2;
            String each = splits[i2];
            fullPath.append(each);
            if (i2 < splits.length - 1) {
                fullPath.append(finder.getSeparator());
            }
            if ((file2 = finder.find(fullPath.toString())) == null || !file2.exists()) {
                return lastFound;
            }
            lastFound = file2;
        }
        return lastFound;
    }

    @NotNull
    public static String getLookupString(@NotNull FileLookup.LookupFile file2, @NotNull FileLookup.Finder finder, @Nullable FileTextFieldImpl.CompletionResult result2) {
        if (file2.getMacro() != null) {
            return file2.getMacro();
        }
        String prefix = result2 != null && result2.myKidsAfterSeparator.contains(file2) ? finder.getSeparator() : "";
        return prefix + file2.getName();
    }

    private static void replacePathComponent(@NotNull FileLookup.LookupFile file2, @NotNull DocumentOwner doc, @NotNull FileLookup.Finder finder, int caretPos, int start2, int end) throws BadLocationException {
        int newPos;
        boolean toRemoveExistingName;
        doc.removeSelection();
        String name = file2.getName();
        if (caretPos >= start2) {
            String prefix = doc.getText(start2, caretPos - start2);
            if (prefix.length() == 0) {
                prefix = doc.getText(start2, end - start2);
            }
            toRemoveExistingName = SystemInfo.isFileSystemCaseSensitive ? name.startsWith(prefix) && prefix.length() > 0 : StringUtil.toUpperCase((String)name).startsWith(StringUtil.toUpperCase((String)prefix)) && prefix.length() > 0;
        } else {
            toRemoveExistingName = true;
        }
        if (toRemoveExistingName) {
            doc.remove(start2, end - start2);
            doc.insertString(start2, name);
            newPos = start2 + name.length();
        } else {
            doc.insertString(caretPos, name);
            newPos = caretPos + name.length();
        }
        if (file2.isDirectory() && !finder.getSeparator().equals(doc.getText(newPos, 1))) {
            doc.insertString(newPos, finder.getSeparator());
            ++newPos;
        }
        if (newPos < doc.getLength() && finder.getSeparator().equals(doc.getText(newPos, 1))) {
            ++newPos;
        }
        doc.setCaretPosition(newPos);
    }

    public static void processChosenFromCompletion(FileLookup.LookupFile file2, DocumentOwner doc, FileLookup.Finder finder, boolean nameOnly) {
        block12: {
            if (file2 == null) {
                return;
            }
            if (nameOnly) {
                try {
                    int end;
                    int start2;
                    int caretPos;
                    if (finder.getSeparator().equals(doc.getText(caretPos, 1))) {
                        for (caretPos = doc.getCaretPosition(); caretPos < doc.getLength(); ++caretPos) {
                            String eachChar = doc.getText(caretPos, 1);
                            if (!finder.getSeparator().equals(eachChar)) break;
                        }
                    }
                    int n = start2 = caretPos > 0 ? caretPos - 1 : caretPos;
                    while (start2 >= 0) {
                        String each = doc.getText(start2, 1);
                        if (finder.getSeparator().equals(each)) {
                            ++start2;
                            break;
                        }
                        --start2;
                    }
                    for (end = Math.max(start2, caretPos); end <= doc.getLength(); ++end) {
                        String each = doc.getText(end, 1);
                        if (finder.getSeparator().equals(each)) break;
                    }
                    if (end > doc.getLength()) {
                        end = doc.getLength();
                    }
                    if (start2 > end || start2 < 0 || end > doc.getLength()) {
                        doc.setText(file2.getAbsolutePath());
                        break block12;
                    }
                    FileTextFieldUtil.replacePathComponent(file2, doc, finder, caretPos, start2, end);
                }
                catch (BadLocationException e) {
                    LOG.error((Throwable)e);
                }
            } else {
                doc.setTextToFile(file2);
            }
        }
    }

    public static void setTextToFile(@NotNull FileLookup.LookupFile file2, FileLookup.Finder finder, @NotNull DocumentOwner doc) {
        String text = file2.getAbsolutePath();
        if (file2.isDirectory() && !text.endsWith(finder.getSeparator())) {
            text = text + finder.getSeparator();
        }
        doc.setText(text);
    }

    public static class TextFieldDocumentOwner
    implements DocumentOwner {
        private final JTextField myField;
        private final Document myDocument;
        private final Consumer<FileLookup.LookupFile> mySetText;

        public TextFieldDocumentOwner(@NotNull JTextField field, @NotNull Consumer<FileLookup.LookupFile> setText) {
            this.myField = field;
            this.myDocument = field.getDocument();
            this.mySetText = setText;
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            return this.myDocument.getText(offset, length);
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            this.myDocument.remove(offset, length);
        }

        @Override
        public void insertString(int offset, String str) throws BadLocationException {
            this.myDocument.insertString(offset, str, this.myDocument.getDefaultRootElement().getAttributes());
        }

        @Override
        public int getLength() {
            return this.myDocument.getLength();
        }

        @Override
        public void removeSelection() {
            this.myField.setSelectionStart(0);
            this.myField.setSelectionEnd(0);
        }

        @Override
        public void setCaretPosition(int position) {
            this.myField.setCaretPosition(position);
        }

        @Override
        public int getCaretPosition() {
            return this.myField.getCaretPosition();
        }

        @Override
        public void setText(@NotNull String text) {
            this.myField.setText(text);
        }

        @Override
        public void setTextToFile(@NotNull FileLookup.LookupFile file2) {
            this.mySetText.accept(file2);
        }
    }

    public static interface DocumentOwner {
        public String getText(int var1, int var2) throws BadLocationException;

        public void remove(int var1, int var2) throws BadLocationException;

        public void insertString(int var1, String var2) throws BadLocationException;

        public int getLength();

        public void removeSelection();

        public void setCaretPosition(int var1);

        public int getCaretPosition();

        public void setText(@NotNull String var1);

        public void setTextToFile(@NotNull FileLookup.LookupFile var1);
    }
}

