/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationsNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationNode
extends ExternalSystemNode {
    private final RunnerAndConfigurationSettings mySettings;

    public RunConfigurationNode(@NotNull ExternalProjectsView externalProjectsView, RunConfigurationsNode parent, @NotNull RunnerAndConfigurationSettings settings) {
        super(externalProjectsView, parent);
        this.mySettings = settings;
    }

    protected void update(@NotNull PresentationData presentation2) {
        super.update(presentation2);
        presentation2.setIcon(ProgramRunnerUtil.getConfigurationIcon(this.mySettings, false));
        ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)this.mySettings.getConfiguration();
        ExternalSystemTaskExecutionSettings taskExecutionSettings = runConfiguration.getSettings();
        String shortcutHint = StringUtil.nullize((String)this.getShortcutsManager().getDescription(taskExecutionSettings.getExternalProjectPath(), this.mySettings.getName()));
        String activatorHint = StringUtil.nullize((String)this.getTaskActivator().getDescription(taskExecutionSettings.getExternalSystemId(), taskExecutionSettings.getExternalProjectPath(), ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(this.mySettings)));
        String hint = shortcutHint == null ? activatorHint : (activatorHint == null ? shortcutHint : shortcutHint + ", " + activatorHint);
        this.setNameAndTooltip(this.getName(), StringUtil.join((Collection)taskExecutionSettings.getTaskNames(), (String)" "), hint);
    }

    public RunnerAndConfigurationSettings getSettings() {
        return this.mySettings;
    }

    @Override
    public String getName() {
        return this.mySettings.getName();
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.RunConfigurationMenu";
    }

    public void updateRunConfiguration() {
    }

    @Override
    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        ExternalProjectsView projectsView = this.getExternalProjectsView();
        String place = projectsView instanceof Component ? ((Component)((Object)projectsView)).getName() : "unknown";
        ExternalSystemActionsCollector.trigger(this.myProject, projectsView.getSystemId(), ExternalSystemActionsCollector.ActionId.ExecuteExternalSystemRunConfigurationAction, place, false, null);
        ProgramRunnerUtil.executeConfiguration(this.mySettings, DefaultRunExecutor.getRunExecutorInstance());
        RunManager.getInstance((Project)this.mySettings.getConfiguration().getProject()).setSelectedConfiguration(this.mySettings);
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return new Navigatable(){

            public void navigate(boolean requestFocus) {
                RunManager.getInstance((Project)RunConfigurationNode.this.myProject).setSelectedConfiguration(RunConfigurationNode.this.mySettings);
                EditConfigurationsDialog dialog2 = new EditConfigurationsDialog(RunConfigurationNode.this.myProject);
                dialog2.show();
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return false;
            }
        };
    }
}

