/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationsNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=40)
public class ModuleNode
extends ExternalSystemNode<ModuleData> {
    private final boolean myIsRoot;
    private final ModuleData myData;
    private Collection<ModuleNode> myAllModules = Collections.emptyList();
    private final RunConfigurationsNode myRunConfigurationsNode;

    public ModuleNode(ExternalProjectsView externalProjectsView, DataNode<ModuleData> dataNode, @Nullable ExternalSystemNode parent, boolean isRoot) {
        super(externalProjectsView, parent, dataNode);
        this.myIsRoot = isRoot;
        this.myData = (ModuleData)dataNode.getData();
        this.myRunConfigurationsNode = new RunConfigurationsNode(externalProjectsView, this);
    }

    public void setAllModules(Collection<ModuleNode> allModules) {
        this.myAllModules = allModules;
    }

    public boolean isRoot() {
        return this.myIsRoot;
    }

    protected void update(@NotNull PresentationData presentation2) {
        super.update(presentation2);
        presentation2.setIcon(this.getUiAware().getProjectIcon());
        String hint = null;
        if (this.myIsRoot) {
            hint = "root";
        }
        String tooltip = this.myData.toString() + (this.myData.getDescription() != null ? "<br>" + this.myData.getDescription() : "");
        this.setNameAndTooltip(this.getName(), tooltip, hint);
    }

    @Override
    @NotNull
    protected List<ExternalSystemNode<?>> doBuildChildren() {
        ArrayList myChildNodes = new ArrayList();
        if (this.getExternalProjectsView().getGroupModules()) {
            List childModules = ContainerUtil.findAll(this.myAllModules, module -> module != this && StringUtil.equals((CharSequence)module.getIdeParentGrouping(), (CharSequence)this.getIdeGrouping()));
            myChildNodes.addAll(childModules);
        }
        myChildNodes.addAll(super.doBuildChildren());
        myChildNodes.add(this.myRunConfigurationsNode);
        return myChildNodes;
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.ModuleMenu";
    }

    @Override
    public int compareTo(@NotNull ExternalSystemNode node) {
        return this.myIsRoot ? -1 : (node instanceof ModuleNode && ((ModuleNode)node).myIsRoot ? 1 : super.compareTo(node));
    }

    public void updateRunConfigurations() {
        this.myRunConfigurationsNode.updateRunConfigurations();
        this.childrenChanged();
        this.getExternalProjectsView().updateUpTo(this);
        this.getExternalProjectsView().updateUpTo(this.myRunConfigurationsNode);
    }

    @Override
    public String getName() {
        if (this.getExternalProjectsView().getGroupModules()) {
            return this.myData.getExternalName();
        }
        return super.getName();
    }

    @Nullable
    public String getIdeGrouping() {
        ModuleData data2 = (ModuleData)this.getData();
        if (data2 == null) {
            return null;
        }
        return data2.getIdeGrouping();
    }

    @Nullable
    public String getIdeParentGrouping() {
        ModuleData data2 = (ModuleData)this.getData();
        if (data2 == null) {
            return null;
        }
        return data2.getIdeParentGrouping();
    }

    @Override
    public void mergeWith(ExternalSystemNode<ModuleData> node) {
        ModuleNode moduleNode;
        super.mergeWith(node);
        ModuleNode moduleNode2 = moduleNode = node instanceof ModuleNode ? (ModuleNode)node : null;
        if (moduleNode != null) {
            this.myAllModules = moduleNode.myAllModules;
        }
    }
}

