/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.FileCollectionDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.UnknownDependencyNode;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.TasksNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TLongObjectHashMap;
import java.awt.event.InputEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemViewDefaultContributor
extends ExternalSystemViewContributor {
    private static final Key<?>[] KEYS = new Key[]{ProjectKeys.MODULE, ProjectKeys.DEPENDENCIES_GRAPH, ProjectKeys.MODULE_DEPENDENCY, ProjectKeys.LIBRARY_DEPENDENCY, ProjectKeys.TASK};

    @Override
    @NotNull
    public ProjectSystemId getSystemId() {
        return ProjectSystemId.IDE;
    }

    @Override
    @NotNull
    public List<Key<?>> getKeys() {
        return Arrays.asList(KEYS);
    }

    @Override
    @NotNull
    public List<ExternalSystemNode<?>> createNodes(ExternalProjectsView externalProjectsView, MultiMap<Key<?>, DataNode<?>> dataNodes) {
        SmartList result2 = new SmartList();
        ExternalSystemViewDefaultContributor.addModuleNodes(externalProjectsView, dataNodes, result2);
        Collection tasksNodes = dataNodes.get((Object)ProjectKeys.TASK);
        if (!tasksNodes.isEmpty()) {
            TasksNode tasksNode = new TasksNode(externalProjectsView, tasksNodes);
            if (externalProjectsView.useTasksNode()) {
                result2.add(tasksNode);
            } else {
                ContainerUtil.addAll((Collection)result2, (Object[])tasksNode.getChildren());
            }
        }
        ExternalSystemViewDefaultContributor.addDependenciesNode(externalProjectsView, dataNodes, result2);
        return result2;
    }

    @Override
    @Nullable
    public String getDisplayName(@NotNull DataNode node) {
        return ExternalSystemViewDefaultContributor.getNodeDisplayName(node);
    }

    private static void addDependenciesNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<? super ExternalSystemNode<?>> result2) {
        Collection depsGraph = dataNodes.get((Object)ProjectKeys.DEPENDENCIES_GRAPH);
        if (!depsGraph.isEmpty()) {
            MyDependenciesNode depNode = new MyDependenciesNode(externalProjectsView);
            for (DataNode dataNode : depsGraph) {
                if (!(dataNode.getData() instanceof ProjectDependencies)) continue;
                ProjectDependencies projectDependencies = (ProjectDependencies)dataNode.getData();
                for (ComponentDependencies componentDependencies : projectDependencies.getComponentsDependencies()) {
                    depNode.add(new DependencyScopeExternalSystemNode(externalProjectsView, componentDependencies.getCompileDependenciesGraph()));
                    depNode.add(new DependencyScopeExternalSystemNode(externalProjectsView, componentDependencies.getRuntimeDependenciesGraph()));
                }
            }
            if (depNode.hasChildren()) {
                result2.add(depNode);
            }
            return;
        }
        Collection moduleDeps = dataNodes.get((Object)ProjectKeys.MODULE_DEPENDENCY);
        Collection libDeps = dataNodes.get((Object)ProjectKeys.LIBRARY_DEPENDENCY);
        if (!moduleDeps.isEmpty() || !libDeps.isEmpty()) {
            MyDependenciesNode depNode = new MyDependenciesNode(externalProjectsView);
            boolean addDepNode = false;
            for (DataNode dataNode : moduleDeps) {
                if (!(dataNode.getData() instanceof ModuleDependencyData)) continue;
                ModuleDependencyDataExternalSystemNode moduleDependencyDataExternalSystemNode = new ModuleDependencyDataExternalSystemNode(externalProjectsView, (DataNode<ModuleDependencyData>)dataNode);
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof AbstractDependencyData) {
                    result2.add(moduleDependencyDataExternalSystemNode);
                    continue;
                }
                depNode.add(moduleDependencyDataExternalSystemNode);
                addDepNode = true;
            }
            for (DataNode dataNode : libDeps) {
                if (!(dataNode.getData() instanceof LibraryDependencyData)) continue;
                LibraryDependencyDataExternalSystemNode libraryDependencyDataExternalSystemNode = new LibraryDependencyDataExternalSystemNode(externalProjectsView, (DataNode<LibraryDependencyData>)dataNode);
                if (((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).isUnresolved()) {
                    libraryDependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.ERROR, "Unable to resolve " + ((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).getExternalName());
                } else {
                    libraryDependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.NONE, new String[0]);
                }
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof ModuleData) {
                    depNode.add(libraryDependencyDataExternalSystemNode);
                    addDepNode = true;
                    continue;
                }
                result2.add(libraryDependencyDataExternalSystemNode);
            }
            if (addDepNode) {
                result2.add(depNode);
            }
        }
    }

    private static void addModuleNodes(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<? super ExternalSystemNode<?>> result2) {
        Collection moduleDataNodes = dataNodes.get((Object)ProjectKeys.MODULE);
        if (!moduleDataNodes.isEmpty()) {
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)externalProjectsView.getProject(), (ProjectSystemId)externalProjectsView.getSystemId());
            HashMap<String, ModuleNode> groupToModule = new HashMap<String, ModuleNode>(moduleDataNodes.size());
            ArrayList<ModuleNode> moduleNodes = new ArrayList<ModuleNode>();
            for (DataNode dataNode : moduleDataNodes) {
                ModuleData data2 = (ModuleData)dataNode.getData();
                ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(data2.getLinkedExternalProjectPath());
                DataNode projectDataNode = ExternalSystemApiUtil.findParent((DataNode)dataNode, (Key)ProjectKeys.PROJECT);
                boolean isRoot = projectSettings != null && data2.getLinkedExternalProjectPath().equals(projectSettings.getExternalProjectPath()) && projectDataNode != null && ((ProjectData)projectDataNode.getData()).getInternalName().equals(data2.getInternalName());
                ModuleNode moduleNode = new ModuleNode(externalProjectsView, (DataNode<ModuleData>)dataNode, null, isRoot);
                moduleNodes.add(moduleNode);
                String group = moduleNode.getIdeGrouping();
                if (group == null) continue;
                groupToModule.put(group, moduleNode);
            }
            for (ModuleNode moduleNode : moduleNodes) {
                ModuleNode parent;
                moduleNode.setAllModules(moduleNodes);
                String parentGroup = moduleNode.getIdeParentGrouping();
                ModuleNode moduleNode2 = parent = parentGroup != null ? (ModuleNode)groupToModule.get(parentGroup) : null;
                if (parent == null) continue;
                moduleNode.setParent(parent);
            }
            result2.addAll(moduleNodes);
        }
    }

    @NotNull
    private static String getNodeDisplayName(@NotNull DataNode<?> node) {
        Object data2 = node.getData();
        if (data2 instanceof LibraryDependencyData) {
            LibraryDependencyData libraryDependencyData = (LibraryDependencyData)data2;
            String externalName = libraryDependencyData.getExternalName();
            if (StringUtil.isEmpty((String)externalName)) {
                Set paths = ((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY);
                if (paths.size() == 1) {
                    String relativePathToRoot = null;
                    String path = ExternalSystemApiUtil.toCanonicalPath((String)((String)paths.iterator().next()));
                    DataNode projectDataDataNode = ExternalSystemApiUtil.findParent(node, (Key)ProjectKeys.PROJECT);
                    if (projectDataDataNode != null) {
                        relativePathToRoot = FileUtil.getRelativePath((String)((ProjectData)projectDataDataNode.getData()).getLinkedExternalProjectPath(), (String)path, (char)'/');
                        relativePathToRoot = relativePathToRoot != null && StringUtil.startsWith((CharSequence)relativePathToRoot, (CharSequence)"../../") ? new File(relativePathToRoot).getName() : relativePathToRoot;
                    }
                    return (String)ObjectUtils.notNull(relativePathToRoot, (Object)path);
                }
                return "<file set>";
            }
            return externalName;
        }
        if (data2 instanceof Named) {
            return ((Named)data2).getExternalName();
        }
        if (data2 instanceof TaskData) {
            return ((TaskData)data2).getName();
        }
        return StringUtil.notNullize((String)node.toString());
    }

    @Override
    public ExternalProjectsStructure.ErrorLevel getErrorLevel(DataNode<?> dataNode) {
        if (ProjectKeys.LIBRARY_DEPENDENCY.equals((Object)dataNode.getKey()) && ((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).isUnresolved()) {
            return ExternalProjectsStructure.ErrorLevel.ERROR;
        }
        return super.getErrorLevel(dataNode);
    }

    private static class LibraryDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<LibraryDependencyData> {
        LibraryDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<LibraryDependencyData> dataNode) {
            super(externalProjectsView, (ExternalSystemNode)null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation2) {
            super.update(presentation2);
            presentation2.setIcon(AllIcons.Nodes.PpLib);
            LibraryDependencyData data2 = (LibraryDependencyData)this.getData();
            if (data2 != null) {
                this.setNameAndTooltip(this.getName(), null, data2.getScope().getDisplayName());
            }
        }
    }

    private static class ModuleDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<ModuleDependencyData> {
        ModuleDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<ModuleDependencyData> dataNode) {
            super(externalProjectsView, (ExternalSystemNode)null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation2) {
            super.update(presentation2);
            presentation2.setIcon(this.getUiAware().getProjectIcon());
            ModuleDependencyData data2 = (ModuleDependencyData)this.getData();
            if (data2 != null) {
                this.setNameAndTooltip(this.getName(), null, data2.getScope().getDisplayName());
            }
        }

        @Override
        @NotNull
        protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
            return Collections.emptyList();
        }

        @Override
        public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
            return ExternalProjectsStructure.ErrorLevel.NONE;
        }
    }

    private static abstract class DependencyDataExternalSystemNode<T extends DependencyData<?>>
    extends ExternalSystemNode<T> {
        private final Navigatable myNavigatable = new OrderEntryNavigatable(this.getProject(), () -> this.getOrderEntry());

        DependencyDataExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent, @Nullable DataNode<T> dataNode) {
            super(externalProjectsView, parent, dataNode);
        }

        @Override
        @Nullable
        public Navigatable getNavigatable() {
            return this.myNavigatable;
        }

        @Nullable
        private OrderEntry getOrderEntry() {
            DependencyData data2 = (DependencyData)this.getData();
            if (data2 == null) {
                return null;
            }
            Project project = this.getProject();
            if (project == null) {
                return null;
            }
            return new IdeModelsProviderImpl(project).findIdeModuleOrderEntry(data2);
        }

        @Override
        public int compareTo(@NotNull ExternalSystemNode node) {
            int order2;
            int order1;
            DependencyData myData = (DependencyData)this.getData();
            Object thatData = node.getData();
            if (myData instanceof OrderAware && thatData instanceof OrderAware && (order1 = ((OrderAware)myData).getOrder()) != (order2 = ((OrderAware)thatData).getOrder())) {
                return order1 < order2 ? -1 : 1;
            }
            String dependencyName = DependencyDataExternalSystemNode.getDependencySimpleName(this);
            String thatDependencyName = DependencyDataExternalSystemNode.getDependencySimpleName(node);
            return StringUtil.compare((String)dependencyName, (String)thatDependencyName, (boolean)true);
        }

        @NotNull
        private static String getDependencySimpleName(@NotNull ExternalSystemNode<?> node) {
            Set paths;
            LibraryDependencyData dependencyData;
            String externalName;
            Object thatData = node.getData();
            if (thatData instanceof LibraryDependencyData && StringUtil.isEmpty((String)(externalName = (dependencyData = (LibraryDependencyData)thatData).getExternalName())) && (paths = ((LibraryData)dependencyData.getTarget()).getPaths(LibraryPathType.BINARY)).size() == 1) {
                return new File((String)paths.iterator().next()).getName();
            }
            return node.getName();
        }

        private static class OrderEntryNavigatable
        implements Navigatable {
            @NotNull
            private final Supplier<OrderEntry> myProvider;
            @Nullable
            private final Project myProject;
            @Nullable
            private OrderEntry myOrderEntry;

            OrderEntryNavigatable(@Nullable Project project, @NotNull Supplier<OrderEntry> provider) {
                this.myProject = project;
                this.myProvider = provider;
            }

            public void navigate(boolean requestFocus) {
                if (this.myOrderEntry != null && this.myProject != null) {
                    ProjectSettingsService.getInstance(this.myProject).openModuleDependenciesSettings(this.myOrderEntry.getOwnerModule(), this.myOrderEntry);
                }
            }

            public boolean canNavigate() {
                this.myOrderEntry = this.myProvider.get();
                return this.myOrderEntry != null;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        }
    }

    private static class DependencyExternalSystemNode
    extends ExternalSystemNode<Object> {
        @NotNull
        private final DependencyNode myDependencyNode;
        @NotNull
        private final TLongObjectHashMap<DependencyNode> myDependencyNodeMap;
        @Nullable
        private DependencyNode myReferencedNode;
        private final String myName;

        DependencyExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull DependencyNode dependencyNode, @NotNull TLongObjectHashMap<DependencyNode> dependencyNodeMap) {
            super(externalProjectsView, null);
            this.myDependencyNode = dependencyNode;
            this.myDependencyNodeMap = dependencyNodeMap;
            if (this.myDependencyNode instanceof ReferenceNode) {
                this.myReferencedNode = (DependencyNode)this.myDependencyNodeMap.get(this.myDependencyNode.getId());
            }
            this.myName = this.myReferencedNode != null ? MessageFormat.format("{0}{1}", this.myReferencedNode.getDisplayName(), this.myReferencedNode.getDependencies().isEmpty() ? "" : " (*)") : this.myDependencyNode.getDisplayName();
        }

        @Override
        public String getName() {
            return this.myName;
        }

        protected void update(@NotNull PresentationData presentation2) {
            String tooltip;
            super.update(presentation2);
            boolean isProjectDependency = this.myDependencyNode instanceof ProjectDependencyNode || this.myReferencedNode instanceof ProjectDependencyNode;
            presentation2.setIcon(isProjectDependency ? this.getUiAware().getProjectIcon() : AllIcons.Nodes.PpLib);
            if (this.myReferencedNode != null) {
                tooltip = ExternalSystemBundle.message((String)"external.system.view.nodes.dependency_reference_node_tooltip", (Object[])new Object[0]);
            } else if (this.myDependencyNode instanceof FileCollectionDependencyNode) {
                String path = ((FileCollectionDependencyNode)this.myDependencyNode).getPath();
                tooltip = StringUtil.join((Object[])path.split(File.pathSeparator), s -> StringEscapeUtils.escapeHtml((String)s) + "<br/>", (String)"");
            } else {
                tooltip = null;
            }
            this.setNameAndTooltip(this.getName(), tooltip, (String)null);
        }

        @Override
        @NotNull
        protected List<ExternalSystemNode<?>> doBuildChildren() {
            if (this.myReferencedNode != null) {
                return Collections.emptyList();
            }
            ArrayList myChildNodes = new ArrayList();
            for (DependencyNode dependency : this.myDependencyNode.getDependencies()) {
                myChildNodes.add(new DependencyExternalSystemNode(this.getExternalProjectsView(), dependency, this.myDependencyNodeMap));
            }
            return myChildNodes;
        }

        @Override
        public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
            if (this.myReferencedNode == null) {
                super.handleDoubleClickOrEnter(tree, inputEvent);
            } else {
                this.selectAndExpandReferencedNode();
            }
        }

        private void selectAndExpandReferencedNode() {
            ExternalProjectsStructure structure = this.getStructure();
            if (structure == null) {
                return;
            }
            DependencyScopeExternalSystemNode scopeNode = this.findParent(DependencyScopeExternalSystemNode.class);
            if (scopeNode == null) {
                return;
            }
            DependencyExternalSystemNode referencedNode = this.findReferencedNode(scopeNode);
            if (referencedNode != null) {
                structure.select(referencedNode);
                structure.expand(referencedNode);
            }
        }

        @Nullable
        private DependencyExternalSystemNode findReferencedNode(ExternalSystemNode<?> node) {
            for (ExternalSystemNode<?> child2 : node.getChildren()) {
                if (child2 instanceof DependencyExternalSystemNode && ((DependencyExternalSystemNode)child2).myDependencyNode == this.myReferencedNode) {
                    return (DependencyExternalSystemNode)child2;
                }
                DependencyExternalSystemNode referencedNode = this.findReferencedNode(child2);
                if (referencedNode == null) continue;
                return referencedNode;
            }
            return null;
        }
    }

    private static class DependencyScopeExternalSystemNode
    extends ExternalSystemNode<Object> {
        private final DependencyScopeNode myDependenciesGraph;
        private final TLongObjectHashMap<DependencyNode> myDependencyNodeMap = new TLongObjectHashMap();

        DependencyScopeExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull DependencyScopeNode dependenciesGraph) {
            super(externalProjectsView, null);
            this.myDependenciesGraph = dependenciesGraph;
        }

        @Override
        public String getName() {
            return this.myDependenciesGraph.getScope();
        }

        protected void update(@NotNull PresentationData presentation2) {
            super.update(presentation2);
            presentation2.setIcon(AllIcons.Nodes.PpLibFolder);
            String description = this.myDependenciesGraph.getDescription();
            if (description != null) {
                this.setNameAndTooltip(this.getName(), description, (String)null);
            }
        }

        @Override
        @NotNull
        protected List<ExternalSystemNode<?>> doBuildChildren() {
            DependencyScopeExternalSystemNode.buildNodesMap(this.myDependencyNodeMap, (DependencyNode)this.myDependenciesGraph);
            ArrayList myChildNodes = new ArrayList();
            for (DependencyNode dependency : this.myDependenciesGraph.getDependencies()) {
                myChildNodes.add(new DependencyExternalSystemNode(this.getExternalProjectsView(), dependency, this.myDependencyNodeMap));
            }
            return myChildNodes;
        }

        @Override
        public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
            return DependencyScopeExternalSystemNode.getErrorLevelRecursively((DependencyNode)this.myDependenciesGraph);
        }

        @NotNull
        private static ExternalProjectsStructure.ErrorLevel getErrorLevelRecursively(@NotNull DependencyNode node) {
            if (node instanceof UnknownDependencyNode) {
                return ExternalProjectsStructure.ErrorLevel.ERROR;
            }
            ExternalProjectsStructure.ErrorLevel result2 = ExternalProjectsStructure.ErrorLevel.NONE;
            for (DependencyNode dependencyNode : node.getDependencies()) {
                ExternalProjectsStructure.ErrorLevel eachLevel = DependencyScopeExternalSystemNode.getErrorLevelRecursively(dependencyNode);
                if (result2.compareTo(eachLevel) > 0) {
                    result2 = eachLevel;
                }
                if (result2 != ExternalProjectsStructure.ErrorLevel.ERROR) continue;
                break;
            }
            return result2;
        }

        private static void buildNodesMap(@NotNull TLongObjectHashMap<DependencyNode> dependencyNodeMap, @NotNull DependencyNode node) {
            for (DependencyNode child2 : node.getDependencies()) {
                if (child2 instanceof ReferenceNode) continue;
                dependencyNodeMap.put(child2.getId(), (Object)child2);
                DependencyScopeExternalSystemNode.buildNodesMap(dependencyNodeMap, child2);
            }
        }
    }

    @Order(value=20)
    private static class MyDependenciesNode
    extends ExternalSystemNode<Object> {
        MyDependenciesNode(ExternalProjectsView externalProjectsView) {
            super(externalProjectsView, null, null);
        }

        protected void update(@NotNull PresentationData presentation2) {
            super.update(presentation2);
            presentation2.setIcon(AllIcons.Nodes.PpLibFolder);
        }

        @Override
        public String getName() {
            return "Dependencies";
        }
    }
}

