/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Tag(value="activation")
public class TaskActivationState {
    @XCollection(elementName="task", valueAttributeName="name", propertyElementName="before_run")
    public List<String> beforeRunTasks = new ArrayList<String>();
    @XCollection(elementName="task", valueAttributeName="name", propertyElementName="before_sync")
    public List<String> beforeSyncTasks = new ArrayList<String>();
    @XCollection(elementName="task", valueAttributeName="name", propertyElementName="after_sync")
    public List<String> afterSyncTasks = new ArrayList<String>();
    @XCollection(elementName="task", valueAttributeName="name", propertyElementName="before_compile")
    public List<String> beforeCompileTasks = new ArrayList<String>();
    @XCollection(elementName="task", valueAttributeName="name", propertyElementName="after_compile")
    public List<String> afterCompileTasks = new ArrayList<String>();
    @XCollection(elementName="task", valueAttributeName="name", propertyElementName="after_rebuild")
    public List<String> afterRebuildTask = new ArrayList<String>();
    @XCollection(elementName="task", valueAttributeName="name", propertyElementName="before_rebuild")
    public List<String> beforeRebuildTask = new ArrayList<String>();

    public boolean isEmpty() {
        for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
            if (this.getTasks(phase).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<String> getTasks(@NotNull ExternalSystemTaskActivator.Phase phase) {
        switch (phase) {
            case AFTER_COMPILE: {
                return this.afterCompileTasks;
            }
            case BEFORE_COMPILE: {
                return this.beforeCompileTasks;
            }
            case AFTER_SYNC: {
                return this.afterSyncTasks;
            }
            case BEFORE_RUN: {
                return this.beforeRunTasks;
            }
            case BEFORE_SYNC: {
                return this.beforeSyncTasks;
            }
            case AFTER_REBUILD: {
                return this.afterRebuildTask;
            }
            case BEFORE_REBUILD: {
                return this.beforeRebuildTask;
            }
        }
        throw new IllegalArgumentException("Unknown task activation phase: " + (Object)((Object)phase));
    }
}

