/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483648)
public class ProjectDataServiceImpl
extends AbstractProjectDataService<ProjectData, Project> {
    @NotNull
    public Key<ProjectData> getTargetDataKey() {
        return ProjectKeys.PROJECT;
    }

    public void importData(@NotNull Collection<DataNode<ProjectData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty()) {
            return;
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single project but got %d: %s", toImport.size(), toImport));
        }
        DataNode<ProjectData> node = toImport.iterator().next();
        assert (projectData2 == node.getData());
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)((ProjectData)node.getData()), (Module[])modelsProvider.getModules())) {
            return;
        }
        if (!project.getName().equals(projectData2.getInternalName())) {
            ProjectDataServiceImpl.renameProject(projectData2.getInternalName(), projectData2.getOwner(), project);
        }
    }

    private static void renameProject(final @NotNull String newName, final @NotNull ProjectSystemId externalSystemId, final @NotNull Project project) {
        if (!(project instanceof ProjectEx) || newName.equals(project.getName())) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                String oldName = project.getName();
                ((ProjectEx)project).setProjectName(newName);
                ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)externalSystemId).getPublisher().onProjectRenamed(oldName, newName);
            }
        });
    }
}

