/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483618)
public abstract class AbstractDependencyDataService<E extends AbstractDependencyData<?>, I extends ExportableOrderEntry>
extends AbstractProjectDataService<E, I> {
    private static final Logger LOG = Logger.getInstance((String)AbstractDependencyDataService.class.getName());

    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty()) {
            return;
        }
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        for (Map.Entry entry : byModule.entrySet()) {
            DataNode moduleDataNode = (DataNode)entry.getKey();
            Module module = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            if (module == null) {
                LOG.warn(String.format("Can't import dependencies %s. Reason: target module (%s) is not found at the ide and can't be imported", entry.getValue(), moduleDataNode));
                continue;
            }
            Map<OrderEntry, OrderAware> moduleDependenciesOrder = this.importData((Collection)entry.getValue(), module, modelsProvider);
            Map orderEntryDataMap = (Map)moduleDataNode.getUserData(AbstractModuleDataService.ORDERED_DATA_MAP_KEY);
            if (orderEntryDataMap != null) {
                orderEntryDataMap.putAll(moduleDependenciesOrder);
                continue;
            }
            moduleDataNode.putUserData(AbstractModuleDataService.ORDERED_DATA_MAP_KEY, moduleDependenciesOrder);
        }
    }

    protected abstract Map<OrderEntry, OrderAware> importData(@NotNull Collection<DataNode<E>> var1, @NotNull Module var2, @NotNull IdeModifiableModelsProvider var3);

    @NotNull
    public Computable<Collection<I>> computeOrphanData(@NotNull Collection<DataNode<E>> toImport, @NotNull ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        return () -> {
            MultiMap byModuleName = MultiMap.create();
            for (DataNode node : toImport) {
                String depName;
                AbstractDependencyData data2 = (AbstractDependencyData)node.getData();
                Module ownerModule = modelsProvider.findIdeModule(data2.getOwnerModule());
                if (ownerModule == null && modelsProvider.getUnloadedModuleDescription(data2.getOwnerModule()) != null) continue;
                assert (ownerModule != null);
                if (data2 instanceof ModuleDependencyData) {
                    Module targetModule = modelsProvider.findIdeModule((ModuleData)((ModuleDependencyData)data2).getTarget());
                    if (targetModule == null && modelsProvider.getUnloadedModuleDescription((ModuleData)((ModuleDependencyData)data2).getTarget()) != null) continue;
                    assert (targetModule != null);
                    depName = targetModule.getName();
                } else {
                    depName = AbstractDependencyDataService.getInternalName(data2);
                }
                byModuleName.putValue((Object)ownerModule.getName(), (Object)depName);
            }
            ModifiableModuleModel modifiableModuleModel = modelsProvider.getModifiableModuleModel();
            SmartList orphanEntries = new SmartList();
            for (Module module : modelsProvider.getModules(projectData2)) {
                for (OrderEntry entry : modelsProvider.getOrderEntries(module)) {
                    String moduleName;
                    if (entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).getLibraryName() == null && entry.getUrls(OrderRootType.CLASSES).length == 0 || !this.getOrderEntryType().isInstance(entry) || byModuleName.get((Object)(moduleName = modifiableModuleModel.getActualName(entry.getOwnerModule()))).contains(this.getOrderEntryName(modelsProvider, (ExportableOrderEntry)entry))) continue;
                    orphanEntries.add((ExportableOrderEntry)entry);
                }
            }
            return orphanEntries;
        };
    }

    @NotNull
    protected abstract Class<I> getOrderEntryType();

    protected String getOrderEntryName(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull I orderEntry) {
        return orderEntry.getPresentableName();
    }

    public void removeData(@NotNull Computable<Collection<I>> toRemoveComputable, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Map<Module, Collection<ExportableOrderEntry>> byModule = AbstractDependencyDataService.groupByModule((Collection)toRemoveComputable.compute());
        for (Map.Entry<Module, Collection<ExportableOrderEntry>> entry : byModule.entrySet()) {
            this.removeData(entry.getValue(), entry.getKey(), modelsProvider);
        }
    }

    @NotNull
    private static Map<Module, Collection<ExportableOrderEntry>> groupByModule(@NotNull Collection<? extends ExportableOrderEntry> data2) {
        HashMap<Module, Collection<ExportableOrderEntry>> result2 = new HashMap<Module, Collection<ExportableOrderEntry>>();
        for (ExportableOrderEntry exportableOrderEntry : data2) {
            ArrayList<ExportableOrderEntry> entries = (ArrayList<ExportableOrderEntry>)result2.get(exportableOrderEntry.getOwnerModule());
            if (entries == null) {
                entries = new ArrayList<ExportableOrderEntry>();
                result2.put(exportableOrderEntry.getOwnerModule(), entries);
            }
            entries.add(exportableOrderEntry);
        }
        return result2;
    }

    protected void removeData(@NotNull Collection<? extends ExportableOrderEntry> toRemove2, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemove2.isEmpty()) {
            return;
        }
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        for (ExportableOrderEntry exportableOrderEntry : toRemove2) {
            modifiableRootModel.removeOrderEntry((OrderEntry)exportableOrderEntry);
        }
    }

    private static String getInternalName(AbstractDependencyData<?> data2) {
        if (data2 instanceof LibraryDependencyData) {
            String name = data2.getInternalName();
            if (StringUtil.isNotEmpty((String)name)) {
                return name;
            }
            Set paths = ((LibraryData)((LibraryDependencyData)data2).getTarget()).getPaths(LibraryPathType.BINARY);
            if (!paths.isEmpty()) {
                String url = (String)paths.iterator().next();
                return PathUtil.toPresentableUrl((String)url);
            }
            return ProjectModelBundle.message((String)"library.empty.library.item", (Object[])new Object[0]);
        }
        return data2.getInternalName();
    }
}

