/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.notification.NotificationType;
import org.jetbrains.annotations.NotNull;

public enum NotificationCategory {
    ERROR(4),
    INFO(3),
    SIMPLE(1),
    WARNING(5);

    private final int myValue;

    private NotificationCategory(int value2) {
        this.myValue = value2;
    }

    public int getMessageCategory() {
        return this.myValue;
    }

    @NotNull
    public NotificationType getNotificationType() {
        return NotificationCategory.convert(this);
    }

    public static NotificationType convert(NotificationCategory notificationCategory) {
        switch (notificationCategory) {
            case ERROR: {
                return NotificationType.ERROR;
            }
            case INFO: {
                return NotificationType.INFORMATION;
            }
            case SIMPLE: {
                return NotificationType.INFORMATION;
            }
            case WARNING: {
                return NotificationType.WARNING;
            }
        }
        return NotificationType.INFORMATION;
    }

    public static NotificationCategory convert(NotificationType notificationType) {
        switch (notificationType) {
            case INFORMATION: {
                return INFO;
            }
            case WARNING: {
                return WARNING;
            }
            case ERROR: {
                return ERROR;
            }
        }
        return SIMPLE;
    }

    public static NotificationCategory convert(int type) {
        switch (type) {
            case 4: {
                return ERROR;
            }
            case 5: {
                return WARNING;
            }
            case 3: {
                return INFO;
            }
            case 2: {
                return INFO;
            }
            case 1: {
                return SIMPLE;
            }
            case 6: {
                return INFO;
            }
        }
        return SIMPLE;
    }
}

