/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemProcessingManager
implements ExternalSystemTaskNotificationListener,
Disposable {
    private static final long TOO_LONG_EXECUTION_MS = TimeUnit.SECONDS.toMillis(10L);
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, Long> myTasksInProgress = new ConcurrentHashMap<ExternalSystemTaskId, Long>();
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, ExternalSystemTask> myTasksDetails = new ConcurrentHashMap<ExternalSystemTaskId, ExternalSystemTask>();
    @NotNull
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    @NotNull
    private final ExternalSystemFacadeManager myFacadeManager;

    public ExternalSystemProcessingManager() {
        Application app = ApplicationManager.getApplication();
        this.myFacadeManager = (ExternalSystemFacadeManager)app.getService(ExternalSystemFacadeManager.class);
        if (app.isUnitTestMode()) {
            return;
        }
        ((ExternalSystemProgressNotificationManager)app.getService(ExternalSystemProgressNotificationManager.class)).addNotificationListener(this, this);
    }

    public void dispose() {
        this.myAlarm.cancelAllRequests();
    }

    public boolean hasTaskOfTypeInProgress(@NotNull ExternalSystemTaskType type, @NotNull Project project) {
        String projectId = ExternalSystemTaskId.getProjectId((Project)project);
        for (ExternalSystemTaskId id2 : this.myTasksInProgress.keySet()) {
            if (!type.equals((Object)id2.getType()) || !projectId.equals(id2.getIdeProjectId())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ExternalSystemTask findTask(@NotNull ExternalSystemTaskId id2) {
        return (ExternalSystemTask)this.myTasksDetails.get(id2);
    }

    @Nullable
    public ExternalSystemTask findTask(@NotNull ExternalSystemTaskType type, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        for (ExternalSystemTask task2 : this.myTasksDetails.values()) {
            AbstractExternalSystemTask externalSystemTask;
            if (!(task2 instanceof AbstractExternalSystemTask) || (externalSystemTask = (AbstractExternalSystemTask)task2).getId().getType() != type || !externalSystemTask.getExternalSystemId().getId().equals(projectSystemId.getId()) || !externalSystemTask.getExternalProjectPath().equals(externalProjectPath)) continue;
            return task2;
        }
        return null;
    }

    @NotNull
    public List<ExternalSystemTask> findTasksOfState(@NotNull ProjectSystemId projectSystemId, ExternalSystemTaskState ... taskStates) {
        SmartList result2 = new SmartList();
        for (ExternalSystemTask task2 : this.myTasksDetails.values()) {
            AbstractExternalSystemTask externalSystemTask;
            if (!(task2 instanceof AbstractExternalSystemTask) || !(externalSystemTask = (AbstractExternalSystemTask)task2).getExternalSystemId().getId().equals(projectSystemId.getId()) || !ArrayUtil.contains((Object)externalSystemTask.getState(), (Object[])taskStates)) continue;
            result2.add(task2);
        }
        return result2;
    }

    public void add(@NotNull ExternalSystemTask task2) {
        this.myTasksDetails.put(task2.getId(), task2);
    }

    public void release(@NotNull ExternalSystemTaskId id2) {
        this.myTasksDetails.remove(id2);
    }

    public void onStart(@NotNull ExternalSystemTaskId id2, String workingDir) {
        this.myTasksInProgress.put(id2, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
        if (this.myAlarm.isEmpty()) {
            this.myAlarm.addRequest(() -> this.update(), TOO_LONG_EXECUTION_MS);
        }
    }

    public void onStart(@NotNull ExternalSystemTaskId id2) {
        this.myTasksInProgress.put(id2, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
        this.myTasksInProgress.put(event.getId(), System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text, boolean stdOut) {
        this.myTasksInProgress.put(id2, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
    }

    public void onEnd(@NotNull ExternalSystemTaskId id2) {
        this.myTasksInProgress.remove(id2);
        if (this.myTasksInProgress.isEmpty()) {
            this.myAlarm.cancelAllRequests();
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id2) {
    }

    public void onFailure(@NotNull ExternalSystemTaskId id2, @NotNull Exception e) {
    }

    public void beforeCancel(@NotNull ExternalSystemTaskId id2) {
    }

    public void onCancel(@NotNull ExternalSystemTaskId id2) {
    }

    public void update() {
        long delay = TOO_LONG_EXECUTION_MS;
        HashMap newState2 = new HashMap();
        HashMap<ExternalSystemTaskId, Long> currentState = new HashMap<ExternalSystemTaskId, Long>(this.myTasksInProgress);
        if (currentState.isEmpty()) {
            return;
        }
        for (Map.Entry entry : currentState.entrySet()) {
            long diff = System.currentTimeMillis() - (Long)entry.getValue();
            if (diff > 0L) {
                delay = Math.min(delay, diff);
                newState2.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!this.myFacadeManager.isTaskActive((ExternalSystemTaskId)entry.getKey())) continue;
            newState2.put(entry.getKey(), System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
        }
        this.myTasksInProgress.clear();
        this.myTasksInProgress.putAll(newState2);
        if (!newState2.isEmpty()) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.update(), delay);
        }
    }
}

