/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.externalSystem.util.environment.Environment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public final class ExternalSystemJdkUtil {
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";

    @Nullable
    @Contract(value="_, null -> null")
    public static Sdk getJdk(@Nullable Project project, @Nullable String jdkName) throws ExternalSystemJdkException {
        return ExternalSystemJdkUtil.resolveJdkName(ExternalSystemJdkUtil.getProjectJdk(project), jdkName);
    }

    @Nullable
    @Contract(value="_, null -> null")
    public static Sdk resolveJdkName(@Nullable Sdk projectSdk, @Nullable String jdkName) throws ExternalSystemJdkException {
        if (jdkName == null) {
            return null;
        }
        switch (jdkName) {
            case "#JAVA_INTERNAL": {
                return ExternalSystemJdkUtil.getInternalJdk();
            }
            case "#USE_PROJECT_JDK": {
                if (projectSdk == null) {
                    throw new ProjectJdkNotFoundException();
                }
                return ExternalSystemJdkUtil.resolveDependentJdk(projectSdk);
            }
            case "#JAVA_HOME": {
                return ExternalSystemJdkUtil.getJavaHomeJdk();
            }
        }
        return ExternalSystemJdkUtil.getJdk(jdkName);
    }

    @NotNull
    private static Sdk getProjectJdk(@Nullable Project project) {
        if (project != null) {
            Module[] modules2;
            Sdk res2 = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (res2 != null) {
                return res2;
            }
            for (Module module : modules2 = ModuleManager.getInstance((Project)project).getModules()) {
                Sdk sdk2 = ModuleRootManager.getInstance((Module)module).getSdk();
                if (sdk2 == null || !(sdk2.getSdkType() instanceof JavaSdkType)) continue;
                return sdk2;
            }
        }
        SdkType jdkType = ExternalSystemJdkUtil.getJavaSdk();
        return ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)jdkType).stream().filter(it -> ExternalSystemJdkUtil.isValidJdk(it)).max(jdkType.versionComparator()).orElseGet(ExternalSystemJdkUtil::getInternalJdk);
    }

    @NotNull
    private static Sdk getJavaHomeJdk() {
        String javaHome = ExternalSystemJdkUtil.getJavaHome();
        if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
            throw new UndefinedJavaHomeException();
        }
        if (!ExternalSystemJdkUtil.isValidJdk(javaHome)) {
            throw new InvalidJavaHomeException(javaHome);
        }
        return ExternalSystemJdkProvider.getInstance().createJdk(null, javaHome);
    }

    @Nullable
    public static String getJavaHome() {
        return Environment.getVariable(JAVA_HOME);
    }

    @Nullable
    private static Sdk getJdk(@NotNull String jdkName) {
        Sdk jdk = ProjectJdkTable.getInstance().findJdk(jdkName);
        if (jdk == null) {
            return null;
        }
        String homePath = jdk.getHomePath();
        if (!ExternalSystemJdkUtil.isValidJdk(jdk)) {
            throw new InvalidSdkException(homePath);
        }
        return jdk;
    }

    @NotNull
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project) throws ExternalSystemJdkException {
        String javaHome;
        List allJdks;
        Sdk mostRecentSdk;
        SdkType javaSdkType = ExternalSystemJdkUtil.getJavaSdkType();
        if (project != null) {
            Sdk projectJdk = ExternalSystemJdkUtil.findProjectJDK(project, javaSdkType);
            if (projectJdk != null) {
                return Pair.pair((Object)USE_PROJECT_JDK, (Object)projectJdk);
            }
            Sdk referencedJdk = ExternalSystemJdkUtil.findReferencedJdk(project);
            if (referencedJdk != null) {
                return Pair.pair((Object)USE_PROJECT_JDK, (Object)referencedJdk);
            }
        }
        if ((mostRecentSdk = (Sdk)(allJdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdkType)).stream().filter(sdk2 -> ExternalSystemJdkUtil.isValidJdk(sdk2)).max(javaSdkType.versionComparator()).orElse(null)) != null) {
            return Pair.pair((Object)mostRecentSdk.getName(), (Object)mostRecentSdk);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ExternalSystemJdkUtil.isValidJdk(javaHome = ExternalSystemJdkUtil.getJavaHome())) {
            SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
            String sdkName = simpleJavaSdkType.suggestSdkName(null, javaHome);
            return Pair.pair((Object)USE_JAVA_HOME, (Object)simpleJavaSdkType.createJdk(sdkName, javaHome));
        }
        return Pair.pair((Object)USE_INTERNAL_JAVA, (Object)ExternalSystemJdkUtil.getInternalJdk());
    }

    private static Sdk findProjectJDK(@NotNull Project project, SdkType javaSdkType) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Stream<Sdk> projectSdks = Stream.concat(Stream.of(projectSdk), Stream.of(ModuleManager.getInstance((Project)project).getModules()).map(module -> ModuleRootManager.getInstance((Module)module).getSdk()));
        return projectSdks.filter(sdk2 -> sdk2 != null && sdk2.getSdkType() == javaSdkType && ExternalSystemJdkUtil.isValidJdk(sdk2)).findFirst().orElse(null);
    }

    @Nullable
    @Contract(value="null -> null")
    private static Sdk findReferencedJdk(Sdk projectSdk) {
        if (projectSdk != null && projectSdk.getSdkType() instanceof DependentSdkType && projectSdk.getSdkType() instanceof JavaSdkType) {
            JavaSdkType sdkType = (JavaSdkType)projectSdk.getSdkType();
            String jdkPath = FileUtil.toSystemIndependentName((String)new File(sdkType.getBinPath(projectSdk)).getParent());
            return Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk2 -> {
                String homePath = sdk2.getHomePath();
                return homePath != null && FileUtil.toSystemIndependentName((String)homePath).equals(jdkPath);
            }).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    private static Sdk findReferencedJdk(Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        return ExternalSystemJdkUtil.findReferencedJdk(projectSdk);
    }

    @NotNull
    public static Sdk resolveDependentJdk(@NotNull Sdk sdk2) {
        Sdk parentSdk = ExternalSystemJdkUtil.findReferencedJdk(sdk2);
        if (parentSdk == null) {
            return sdk2;
        }
        return parentSdk;
    }

    @NotNull
    public static Collection<String> suggestJdkHomePaths() {
        return ExternalSystemJdkUtil.getJavaSdkType().suggestHomePaths();
    }

    @NotNull
    public static SdkType getJavaSdkType() {
        return ExternalSystemJdkUtil.getJavaSdk();
    }

    @Contract(value="null -> false")
    public static boolean isValidJdk(@Nullable Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        if (!(jdk.getSdkType() instanceof JavaSdkType)) {
            return false;
        }
        if (SdkDownloadTracker.getInstance().isDownloading(jdk)) {
            return true;
        }
        return ExternalSystemJdkUtil.isValidJdk(jdk.getHomePath());
    }

    @Contract(value="null -> false")
    public static boolean isValidJdk(@Nullable String homePath) {
        return !StringUtil.isEmptyOrSpaces((String)homePath) && JdkUtil.checkForJdk((String)homePath) && JdkUtil.checkForJre((String)homePath);
    }

    @NotNull
    public static Sdk addJdk(String homePath) {
        ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
        List<Sdk> sdks = Arrays.asList(ProjectJdkTable.getInstance().getAllJdks());
        String name = SdkConfigurationUtil.createUniqueSdkName(jdkProvider.getJavaSdkType(), homePath, sdks);
        Sdk jdk = jdkProvider.createJdk(name, homePath);
        SdkConfigurationUtil.addSdk(jdk);
        return jdk;
    }

    @NotNull
    private static SdkType getJavaSdk() {
        return ExternalSystemJdkProvider.getInstance().getJavaSdkType();
    }

    @NotNull
    private static Sdk getInternalJdk() {
        return ExternalSystemJdkProvider.getInstance().getInternalJdk();
    }

    @Contract(value="null -> false")
    public static boolean isJdk9orLater(@Nullable String javaHome) {
        JdkVersionDetector.JdkVersionInfo jdkVersionInfo = javaHome == null ? null : JdkVersionDetector.getInstance().detectJdkVersionInfo(javaHome);
        return jdkVersionInfo != null && jdkVersionInfo.version.isAtLeast(9);
    }
}

