/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemBeforeRunTask;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEditTaskDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ExternalSystemBeforeRunTaskProvider
extends BeforeRunTaskProvider<ExternalSystemBeforeRunTask> {
    @NotNull
    private final ProjectSystemId mySystemId;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Key<ExternalSystemBeforeRunTask> myId;

    public ExternalSystemBeforeRunTaskProvider(@NotNull ProjectSystemId systemId, @NotNull Project project, @NotNull Key<ExternalSystemBeforeRunTask> id2) {
        this.mySystemId = systemId;
        this.myProject = project;
        this.myId = id2;
    }

    @NotNull
    public Key<ExternalSystemBeforeRunTask> getId() {
        return this.myId;
    }

    public String getName() {
        return ExternalSystemBundle.message((String)"tasks.before.run.empty", (Object[])new Object[]{this.mySystemId.getReadableName()});
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull ExternalSystemBeforeRunTask task2) {
        ExternalSystemEditTaskDialog dialog2 = new ExternalSystemEditTaskDialog(this.myProject, task2.getTaskExecutionSettings(), this.mySystemId);
        dialog2.setTitle(ExternalSystemBundle.message((String)"tasks.select.task.title", (Object[])new Object[]{this.mySystemId.getReadableName()}));
        return dialog2.showAndGet();
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull ExternalSystemBeforeRunTask beforeRunTask) {
        ExternalSystemTaskExecutionSettings executionSettings = beforeRunTask.getTaskExecutionSettings();
        ArrayList<ExternalTaskPojo> tasks = new ArrayList<ExternalTaskPojo>();
        for (String taskName : executionSettings.getTaskNames()) {
            tasks.add(new ExternalTaskPojo(taskName, executionSettings.getExternalProjectPath(), null));
        }
        if (tasks.isEmpty()) {
            return true;
        }
        ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment(this.myProject, this.mySystemId, executionSettings, "Run");
        if (environment == null) {
            return false;
        }
        return environment.getRunner().canRun("Run", environment.getRunProfile());
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull ExternalSystemBeforeRunTask beforeRunTask) {
        ExternalSystemTaskExecutionSettings executionSettings = beforeRunTask.getTaskExecutionSettings();
        ArrayList<ExternalTaskPojo> tasks = new ArrayList<ExternalTaskPojo>();
        for (String taskName : executionSettings.getTaskNames()) {
            tasks.add(new ExternalTaskPojo(taskName, executionSettings.getExternalProjectPath(), null));
        }
        if (tasks.isEmpty()) {
            return true;
        }
        ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment(this.myProject, this.mySystemId, executionSettings, "Run");
        if (environment == null) {
            return false;
        }
        ProgramRunner runner = environment.getRunner();
        environment.setExecutionId(env.getExecutionId());
        return RunConfigurationBeforeRunProvider.doRunTask(DefaultRunExecutor.getRunExecutorInstance().getId(), environment, runner);
    }

    public String getDescription(ExternalSystemBeforeRunTask task2) {
        String externalProjectPath = task2.getTaskExecutionSettings().getExternalProjectPath();
        if (task2.getTaskExecutionSettings().getTaskNames().isEmpty()) {
            return ExternalSystemBundle.message((String)"tasks.before.run.empty", (Object[])new Object[]{this.mySystemId.getReadableName()});
        }
        String desc = StringUtil.join((Collection)task2.getTaskExecutionSettings().getTaskNames(), (String)" ");
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)this.mySystemId, (Module)module) || !StringUtil.equals((CharSequence)externalProjectPath, (CharSequence)ExternalSystemApiUtil.getExternalProjectPath((Module)module))) continue;
            desc = module.getName() + ": " + desc;
            break;
        }
        return ExternalSystemBundle.message((String)"tasks.before.run", (Object[])new Object[]{this.mySystemId.getReadableName(), desc});
    }
}

