/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ExternalSystemRunConfigurationMenu
extends DefaultActionGroup
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        for (AnAction action2 : this.getChildActionsOrStubs()) {
            if (!(action2 instanceof ExecuteExternalSystemRunConfigurationAction)) continue;
            this.remove(action2);
        }
        Project project = e.getProject();
        List selectedNodes = (List)e.getData(ExternalSystemDataKeys.SELECTED_NODES);
        if (selectedNodes == null || selectedNodes.size() != 1 || !(selectedNodes.get(0) instanceof RunConfigurationNode)) {
            return;
        }
        RunConfigurationNode runConfigurationNode = (RunConfigurationNode)selectedNodes.get(0);
        RunnerAndConfigurationSettings settings = runConfigurationNode.getSettings();
        if (settings == null || project == null) {
            return;
        }
        ProjectSystemId projectSystemId = (ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID);
        ArrayList<Executor> executors = new ArrayList<Executor>();
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            if (executor instanceof ExecutorGroup) {
                executors.addAll(((ExecutorGroup)executor).childExecutors());
                continue;
            }
            executors.add(executor);
        }
        int i2 = executors.size();
        while (--i2 >= 0) {
            Executor executor;
            executor = (Executor)executors.get(i2);
            if (!executor.isApplicable(project)) continue;
            ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)settings.getConfiguration());
            ExecuteExternalSystemRunConfigurationAction action3 = new ExecuteExternalSystemRunConfigurationAction(executor, runner != null, project, projectSystemId, settings);
            this.addAction(action3, Constraints.FIRST);
        }
        super.update(e);
    }

    private static class ExecuteExternalSystemRunConfigurationAction
    extends AnAction {
        private final Executor myExecutor;
        private final boolean myEnabled;
        private final Project myProject;
        private final RunnerAndConfigurationSettings mySettings;
        private final ProjectSystemId mySystemId;

        ExecuteExternalSystemRunConfigurationAction(Executor executor, boolean enabled, Project project, ProjectSystemId projectSystemId, RunnerAndConfigurationSettings settings) {
            super(executor.getActionName(), null, executor.getIcon());
            this.myExecutor = executor;
            this.myEnabled = enabled;
            this.myProject = project;
            this.mySettings = settings;
            this.mySystemId = projectSystemId;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (this.myEnabled) {
                ExternalSystemActionsCollector.trigger(this.myProject, this.mySystemId, this, event);
                ProgramRunnerUtil.executeConfiguration(this.mySettings, this.myExecutor);
                RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(this.mySettings);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(this.myEnabled);
        }
    }
}

