/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DefaultLineMarkerRenderer
implements LineMarkerRendererEx {
    private final TextAttributesKey myAttributesKey;
    private final int myThickness;
    private final int myDepth;
    private final LineMarkerRendererEx.Position myPosition;
    private final Color myColor;

    public DefaultLineMarkerRenderer(@NotNull TextAttributesKey myAttributesKey, int thickness) {
        this(myAttributesKey, thickness, 0, LineMarkerRendererEx.Position.RIGHT);
    }

    public DefaultLineMarkerRenderer(@NotNull TextAttributesKey attributesKey, int thickness, int depth, @NotNull LineMarkerRendererEx.Position position) {
        this.myAttributesKey = attributesKey;
        this.myThickness = thickness;
        this.myDepth = depth;
        this.myPosition = position;
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme.getAttributes(this.myAttributesKey);
        Color color = attributes.getBackgroundColor();
        Color color2 = color = color != null ? color : attributes.getForegroundColor();
        this.myColor = color != null ? (ColorUtil.isDark((Color)scheme.getDefaultBackground()) ? ColorUtil.shift((Color)color, (double)1.5) : color.darker()) : null;
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        if (this.myColor == null) {
            return;
        }
        g.setColor(this.myColor);
        g.fillRect(r.x, r.y, this.myThickness, r.height);
        g.fillRect(r.x + this.myThickness, r.y, this.myDepth, this.myThickness);
        g.fillRect(r.x + this.myThickness, r.y + r.height - this.myThickness, this.myDepth, this.myThickness);
    }

    @NotNull
    public TextAttributesKey getAttributesKey() {
        return this.myAttributesKey;
    }

    public int getDepth() {
        return this.myDepth;
    }

    public int getThickness() {
        return this.myThickness;
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        return this.myPosition;
    }
}

