/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.ComplexTextFragment;
import com.intellij.openapi.editor.impl.view.SimpleTextFragment;
import com.intellij.openapi.editor.impl.view.TextFragment;
import com.intellij.util.ui.UIUtilities;
import org.jetbrains.annotations.NotNull;

final class TextFragmentFactory {
    TextFragmentFactory() {
    }

    public static TextFragment createTextFragment(char @NotNull [] lineChars, int start2, int end, boolean isRtl, @NotNull FontInfo fontInfo) {
        if (isRtl || fontInfo.getFont().hasLayoutAttributes() || TextFragmentFactory.isComplexText(lineChars, start2, end)) {
            return new ComplexTextFragment(lineChars, start2, end, isRtl, fontInfo);
        }
        return new SimpleTextFragment(lineChars, start2, end, fontInfo);
    }

    private static boolean isComplexText(char[] chars, int start2, int end) {
        return UIUtilities.isComplexLayout((char[])chars, (int)start2, (int)end);
    }
}

