/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineFragment;
import java.awt.Graphics2D;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

class TabFragment
implements LineFragment {
    private final EditorView myView;
    private final Editor myEditor;

    TabFragment(EditorView view) {
        this.myView = view;
        this.myEditor = view.getEditor();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        int tabSize = this.myView.getTabSize();
        return tabSize - startColumn % tabSize;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        float x = this.getNextTabStop(startX);
        return EditorUtil.columnsNumber(x - startX, this.myView.getPlainSpaceWidth());
    }

    @Override
    public Consumer<Graphics2D> draw(float x, float y, int startColumn, int endColumn) {
        return g -> {};
    }

    @Override
    @NotNull
    public LineFragment subFragment(int startOffset, int endOffset) {
        return this;
    }

    @Override
    public float offsetToX(float startX, int startOffset, int offset) {
        return TabFragment.trimOffset(offset) <= TabFragment.trimOffset(startOffset) ? startX : this.getNextTabStop(startX);
    }

    @Override
    public int logicalToVisualColumn(float startX, int startColumn, int column) {
        int visualColumnCount = this.getVisualColumnCount(startX);
        int logicalColumnCount = this.getLogicalColumnCount(startColumn);
        return column == logicalColumnCount ? visualColumnCount : Math.min(column, visualColumnCount - 1);
    }

    @Override
    public int visualToLogicalColumn(float startX, int startColumn, int column) {
        int visualColumnCount = this.getVisualColumnCount(startX);
        int logicalColumnCount = this.getLogicalColumnCount(startColumn);
        return column == visualColumnCount ? logicalColumnCount : Math.min(column, logicalColumnCount - 1);
    }

    @Override
    public int visualColumnToOffset(float startX, int column) {
        int visualColumnCount = this.getVisualColumnCount(startX);
        return column == visualColumnCount ? 1 : 0;
    }

    @Override
    public int[] xToVisualColumn(float startX, float x) {
        boolean closerToLargerColumns;
        int column;
        if (x <= startX) {
            return new int[]{0, 0};
        }
        float nextTabStop = this.getNextTabStop(startX);
        if (x > nextTabStop) {
            return new int[]{this.getVisualColumnCount(startX), 1};
        }
        if (this.myEditor.getSettings().isCaretInsideTabs()) {
            float plainSpaceWidth = this.myView.getPlainSpaceWidth();
            column = Math.round((x - startX) / plainSpaceWidth);
            closerToLargerColumns = x - startX > (float)column * plainSpaceWidth;
        } else {
            column = x > (startX + nextTabStop) / 2.0f ? this.getVisualColumnCount(startX) : 0;
            closerToLargerColumns = column == 0;
        }
        return new int[]{column, closerToLargerColumns ? 1 : 0};
    }

    @Override
    public float visualColumnToX(float startX, int column) {
        if (column <= 0) {
            return startX;
        }
        if (column >= this.getVisualColumnCount(startX)) {
            return this.getNextTabStop(startX);
        }
        return startX + this.myView.getPlainSpaceWidth() * (float)column;
    }

    private static int trimOffset(int offset) {
        return offset <= 0 ? 0 : 1;
    }

    private float getNextTabStop(float x) {
        int leftInset = this.myView.getInsets().left;
        return EditorUtil.nextTabStop(x - (float)leftInset, this.myView.getPlainSpaceWidth(), this.myView.getTabSize()) + (float)leftInset;
    }
}

