/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.HardReferencingRangeMarkerTree;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.Getter;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MarkerTreeWithPartialSums<T extends RangeMarkerImpl>
extends HardReferencingRangeMarkerTree<T> {
    MarkerTreeWithPartialSums(@NotNull Document document) {
        super(document);
    }

    @Override
    protected Node<T> getRoot() {
        return (Node)super.getRoot();
    }

    void valueUpdated(T marker) {
        Node node = (Node)this.lookupNode(marker);
        if (node != null) {
            node.recalculateSubTreeSumUp();
        }
    }

    int getSumOfValuesUpToOffset(int offset) {
        return this.getSumOfValuesForOverlappingRanges((Node<T>)this.getRoot(), offset, 0);
    }

    private int getSumOfValuesForOverlappingRanges(@Nullable Node<T> node, int offset, int deltaUpToRootExclusive) {
        if (node == null) {
            return 0;
        }
        int delta = deltaUpToRootExclusive + node.delta;
        if (offset >= node.maxEnd + delta) {
            return ((Node)node).subtreeSum;
        }
        int value2 = this.getSumOfValuesForOverlappingRanges((Node<T>)node.getLeft(), offset, delta);
        if (offset >= node.intervalStart() + delta) {
            value2 += ((Node)node).getLocalSum();
            value2 += this.getSumOfValuesForOverlappingRanges((Node<T>)node.getRight(), offset, delta);
        }
        return value2;
    }

    @Override
    @NotNull
    protected RangeMarkerTree.RMNode<T> createNewNode(@NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        assert (start2 == end);
        assert (!greedyToLeft);
        assert (!greedyToRight);
        return new Node<T>(this, key, start2, start2, false, false, stickingToRight);
    }

    @Override
    void correctMax(@NotNull IntervalTreeImpl.IntervalNode<T> node, int deltaUpToRoot) {
        super.correctMax(node, deltaUpToRoot);
        ((Node)node).recalculateSubTreeSum();
    }

    static class Node<T extends RangeMarkerImpl>
    extends RangeMarkerTree.RMNode<T> {
        private int subtreeSum;

        Node(@NotNull RangeMarkerTree<T> rangeMarkerTree, @NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight) {
            super(rangeMarkerTree, key, start2, end, greedyToLeft, greedyToRight, stickingToRight);
        }

        @Override
        public Node<T> getLeft() {
            return (Node)super.getLeft();
        }

        @Override
        public Node<T> getRight() {
            return (Node)super.getRight();
        }

        @Override
        public Node<T> getParent() {
            return (Node)super.getParent();
        }

        private int getLocalSum() {
            int sum = 0;
            for (Getter g : this.intervals) {
                sum += ((IntSupplier)((Object)((RangeMarkerImpl)g.get()))).getAsInt();
            }
            return sum;
        }

        private void recalculateSubTreeSum() {
            IntervalTreeImpl.IntervalNode right;
            this.subtreeSum = this.getLocalSum();
            IntervalTreeImpl.IntervalNode left = this.getLeft();
            if (left != null) {
                this.subtreeSum += ((Node)left).subtreeSum;
            }
            if ((right = this.getRight()) != null) {
                this.subtreeSum += ((Node)right).subtreeSum;
            }
        }

        private void recalculateSubTreeSumUp() {
            for (IntervalTreeImpl.IntervalNode n = this; n != null; n = n.getParent()) {
                n.recalculateSubTreeSum();
            }
        }

        @Override
        void addInterval(@NotNull T interval) {
            super.addInterval(interval);
            this.recalculateSubTreeSumUp();
        }

        @Override
        void removeIntervalInternal(int i2) {
            super.removeIntervalInternal(i2);
            this.recalculateSubTreeSumUp();
        }
    }
}

