/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class FoldingAnchorsOverlayStrategy {
    private final EditorImpl myEditor;

    FoldingAnchorsOverlayStrategy(EditorImpl editor) {
        this.myEditor = editor;
    }

    @NotNull
    Collection<DisplayedFoldingAnchor> getAnchorsToDisplay(int firstVisibleOffset, int lastVisibleOffset, @NotNull List<FoldRegion> activeFoldRegions) {
        Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
        FoldRegion[] visibleFoldRegions = this.myEditor.getFoldingModel().fetchVisible();
        if (visibleFoldRegions != null) {
            for (FoldRegion region : visibleFoldRegions) {
                int endLogicalLine;
                int endOffset;
                int startOffset;
                if (!region.isValid() || region.shouldNeverExpand() || (startOffset = region.getStartOffset()) > lastVisibleOffset || (endOffset = region.getEndOffset()) < firstVisibleOffset) continue;
                boolean singleLine = false;
                int startLogicalLine = this.myEditor.getDocument().getLineNumber(startOffset);
                if (startLogicalLine == (endLogicalLine = this.myEditor.getDocument().getLineNumber(endOffset))) {
                    singleLine = true;
                    if (!region.isGutterMarkEnabledForSingleLine() && (!this.myEditor.getSettings().isAllowSingleLogicalLineFolding() || endOffset - startOffset <= 1 || this.myEditor.getSoftWrapModel().getSoftWrapsForRange(startOffset + 1, endOffset - 1).isEmpty())) continue;
                }
                int foldStart = this.myEditor.offsetToVisualLine(startOffset);
                if (!region.isExpanded()) {
                    FoldingAnchorsOverlayStrategy.tryAdding((Int2ObjectOpenHashMap<DisplayedFoldingAnchor>)result2, region, foldStart, 0, singleLine ? DisplayedFoldingAnchor.Type.COLLAPSED_SINGLE_LINE : DisplayedFoldingAnchor.Type.COLLAPSED, activeFoldRegions);
                    continue;
                }
                int foldEnd = this.myEditor.offsetToVisualLine(endOffset);
                if (foldStart == foldEnd) {
                    FoldingAnchorsOverlayStrategy.tryAdding((Int2ObjectOpenHashMap<DisplayedFoldingAnchor>)result2, region, foldStart, 0, DisplayedFoldingAnchor.Type.EXPANDED_SINGLE_LINE, activeFoldRegions);
                    continue;
                }
                FoldingAnchorsOverlayStrategy.tryAdding((Int2ObjectOpenHashMap<DisplayedFoldingAnchor>)result2, region, foldStart, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_TOP, activeFoldRegions);
                FoldingAnchorsOverlayStrategy.tryAdding((Int2ObjectOpenHashMap<DisplayedFoldingAnchor>)result2, region, foldEnd, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_BOTTOM, activeFoldRegions);
            }
        }
        return result2.values();
    }

    private static void tryAdding(@NotNull Int2ObjectOpenHashMap<DisplayedFoldingAnchor> resultsMap, @NotNull FoldRegion region, int visualLine, int visualHeight, @NotNull DisplayedFoldingAnchor.Type type, @NotNull List<FoldRegion> activeRegions) {
        DisplayedFoldingAnchor prev = (DisplayedFoldingAnchor)resultsMap.get(visualLine);
        if (prev != null && !prev.type.singleLine) {
            if (type.singleLine) {
                return;
            }
            if (region.getGroup() != null && region.getGroup() == prev.foldRegion.getGroup() && type != DisplayedFoldingAnchor.Type.COLLAPSED && type != prev.type) {
                resultsMap.remove(visualLine);
                return;
            }
            if (activeRegions.contains(prev.foldRegion)) {
                return;
            }
            if (!activeRegions.contains(region) && prev.foldRegionVisualLines < visualHeight) {
                return;
            }
        }
        resultsMap.put(visualLine, (Object)new DisplayedFoldingAnchor(region, visualLine, visualHeight, type));
    }
}

