/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContextMenuPopupHandler
implements EditorPopupHandler {
    @Nullable
    public abstract ActionGroup getActionGroup(@NotNull EditorMouseEvent var1);

    @Override
    public boolean handlePopup(@NotNull EditorMouseEvent event) {
        ActionGroup group = this.getActionGroup(event);
        if (group != null) {
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", group);
            MouseEvent e = event.getMouseEvent();
            Component c = e.getComponent();
            if (c != null && c.isShowing()) {
                popupMenu.getComponent().show(c, e.getX(), e.getY());
            }
            event.consume();
        }
        return true;
    }

    @Nullable
    static ActionGroup getGroupForId(@Nullable String groupId2) {
        return groupId2 == null ? null : (ActionGroup)ObjectUtils.tryCast((Object)CustomActionsSchema.getInstance().getCorrectedAction(groupId2), ActionGroup.class);
    }

    public static class Simple
    extends ContextMenuPopupHandler {
        private final ActionGroup myActionGroup;

        public Simple(ActionGroup actionGroup) {
            this.myActionGroup = actionGroup;
        }

        public Simple(String groupId2) {
            this(ContextMenuPopupHandler.getGroupForId(groupId2));
        }

        @Override
        @Nullable
        public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
            return this.myActionGroup;
        }
    }

    public static abstract class ById
    extends ContextMenuPopupHandler {
        @Override
        @Nullable
        public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
            return ContextMenuPopupHandler.getGroupForId(this.getActionGroupId(event));
        }

        @Nullable
        public abstract String getActionGroupId(@NotNull EditorMouseEvent var1);
    }
}

