/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class ShortBasedStorage
implements DataStorage {
    protected short[] myData;

    public ShortBasedStorage() {
        this.myData = new short[64];
    }

    protected ShortBasedStorage(short[] data2) {
        this.myData = data2;
    }

    @Override
    public void setData(int segmentIndex, int data2) {
        if (segmentIndex >= this.myData.length) {
            this.myData = ArrayUtil.realloc((short[])this.myData, (int)SegmentArray.calcCapacity(this.myData.length, segmentIndex));
        }
        this.myData[segmentIndex] = (short)data2;
    }

    @Override
    public void remove(int startIndex, int endIndex, int mySegmentCount) {
        if (endIndex < mySegmentCount) {
            System.arraycopy(this.myData, endIndex, this.myData, startIndex, mySegmentCount - endIndex);
        }
    }

    @Override
    public void replace(DataStorage storage, int startOffset, int len) {
        assert (storage instanceof ShortBasedStorage);
        System.arraycopy(((ShortBasedStorage)storage).myData, 0, this.myData, startOffset, len);
    }

    @Override
    public void insert(DataStorage storageToInsert, int startIndex, int segmentCountToInsert, int segmentCount) {
        assert (storageToInsert instanceof ShortBasedStorage);
        this.myData = ShortBasedStorage.insert(this.myData, ((ShortBasedStorage)storageToInsert).myData, startIndex, segmentCountToInsert, segmentCount);
    }

    @Override
    public int getData(int index) {
        return this.myData[index];
    }

    @Override
    public int packData(IElementType tokenType, int state, boolean isRestartableState) {
        short idx = tokenType.getIndex();
        return isRestartableState ? idx : -idx;
    }

    @Override
    public int unpackStateFromData(int data2) {
        throw new UnsupportedOperationException("Unable to unpack state, state is not stored in ShortBasedStorage");
    }

    @Override
    public IElementType unpackTokenFromData(int data2) {
        return IElementType.find((short)((short)Math.abs(data2)));
    }

    @Override
    public DataStorage copy() {
        return new ShortBasedStorage(this.myData);
    }

    @Override
    public DataStorage createStorage() {
        return new ShortBasedStorage();
    }

    protected static short @NotNull [] insert(short @NotNull [] array2, short @NotNull [] insertArray, int startIndex, int insertLength, int mySegmentCount) {
        short[] newArray = ShortBasedStorage.reallocateArray(array2, mySegmentCount + insertLength);
        if (startIndex < mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        return newArray;
    }

    protected static short @NotNull [] reallocateArray(short @NotNull [] array2, int index) {
        if (index < array2.length) {
            return array2;
        }
        return ArrayUtil.realloc((short[])array2, (int)SegmentArray.calcCapacity(array2.length, index));
    }
}

