/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.AccessingInternalJdkFontApi;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.FontFallbackIterator;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowFontsUsedByEditorAction
extends EditorAction {
    private static final Logger LOG = Logger.getInstance(ShowFontsUsedByEditorAction.class);

    public ShowFontsUsedByEditorAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            return editor instanceof EditorEx;
        }

        protected void doExecute(final @NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            new Task.Modal(editor.getProject(), EditorBundle.message((String)"fonts.used.by.editor.progress", (Object[])new Object[0]), true){
                private String textToShow;

                public void run(@NotNull ProgressIndicator indicator) {
                    Set fontNames = (Set)ReadAction.compute(() -> Handler.collectFontNames((EditorEx)editor));
                    this.textToShow = StringUtil.join((Collection)fontNames, (String)"\n");
                }

                public void onSuccess() {
                    if (this.textToShow != null) {
                        new MyDialog(this.textToShow).show();
                    }
                }
            }.queue();
        }

        private static Set<String> collectFontNames(@NotNull EditorEx editor) {
            TreeSet<String> result2 = new TreeSet<String>();
            DocumentEx document = editor.getDocument();
            CharSequence text = document.getImmutableCharSequence();
            int textLength = document.getTextLength();
            IterationState it = new IterationState(editor, 0, textLength, null, false, true, false, false);
            FontFallbackIterator ffi = new FontFallbackIterator().setPreferredFonts(editor.getColorsScheme().getFontPreferences());
            while (!it.atEnd()) {
                ffi.setFontStyle(it.getMergedAttributes().getFontType());
                int start2 = it.getStartOffset();
                int end = it.getEndOffset();
                for (int i2 = start2; i2 < end; ++i2) {
                    if ("\r\n\t".indexOf(text.charAt(i2)) < 0) continue;
                    Handler.collectFontNames(result2, text, start2, i2, ffi);
                    start2 = i2 + 1;
                }
                Handler.collectFontNames(result2, text, start2, end, ffi);
                Handler.setProgress((double)end / (double)textLength);
                it.advance();
            }
            return result2;
        }

        private static void collectFontNames(@NotNull Set<String> result2, @NotNull CharSequence text, int startOffset, int endOffset, @NotNull FontFallbackIterator ffi) {
            if (startOffset >= endOffset) {
                return;
            }
            ffi.start(text, startOffset, endOffset);
            while (!ffi.atEnd()) {
                ProgressManager.checkCanceled();
                Font font = ffi.getFont();
                List<String> components = null;
                try {
                    components = AccessingInternalJdkFontApi.getRelevantComponents(font, text, ffi.getStart(), ffi.getEnd());
                }
                catch (Throwable e) {
                    LOG.debug(e);
                }
                if (components == null) {
                    result2.add(font.getFontName() + " (*)");
                } else {
                    result2.addAll(components);
                }
                ffi.advance();
            }
        }

        private static void setProgress(double progress2) {
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (indicator != null) {
                indicator.setFraction(progress2);
            }
        }

        private static class MyDialog
        extends DialogWrapper {
            private final JBTextArea myTextArea;

            private MyDialog(String text) {
                super(false);
                this.setTitle(EditorBundle.message((String)"fonts.used.by.editor.title", (Object[])new Object[0]));
                this.myTextArea = new JBTextArea(text, 10, 50);
                this.myTextArea.setEditable(false);
                this.init();
            }

            protected Action @NotNull [] createActions() {
                return new Action[0];
            }

            protected JComponent createCenterPanel() {
                return new JBScrollPane((Component)this.myTextArea);
            }
        }
    }
}

