/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddCaretPerSelectedLineAction
extends EditorAction {
    public AddCaretPerSelectedLineAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
            super(true);
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            assert (caret != null);
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int selectionStart = caret.getSelectionStart();
            int startLine = document.getLineNumber(selectionStart);
            int selectionEnd = caret.getSelectionEnd();
            int endLine = document.getLineNumber(selectionEnd);
            caret.removeSelection();
            boolean primary = caret.getOffset() != selectionStart;
            for (int i2 = startLine; i2 <= endLine; ++i2) {
                int targetOffset;
                if (i2 < endLine) {
                    targetOffset = document.getLineEndOffset(i2);
                } else {
                    targetOffset = selectionEnd;
                    if (i2 != startLine && targetOffset == document.getLineStartOffset(i2)) continue;
                }
                if (targetOffset == caret.getOffset()) {
                    caret.moveToOffset(targetOffset == 0 ? document.getTextLength() : 0);
                }
                caretModel.addCaret(editor.offsetToLogicalPosition(targetOffset), primary);
            }
            caretModel.removeCaret(caret);
        }
    }
}

