/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class MergeRequestImpl
extends MergeRequest {
    private static final Logger LOG = Logger.getInstance(MergeRequestImpl.class);
    private final DiffContent[] myDiffContents = new DiffContent[3];
    private String myWindowTitle = null;
    private String[] myVersionTitles = null;
    private int myResult = 1;
    private String myHelpId;

    public MergeRequestImpl(@NotNull String left, @NotNull MergeVersion base, @NotNull String right, @Nullable Project project) {
        this((DiffContent)new SimpleContent(left), new MergeContent(base, project), (DiffContent)new SimpleContent(right), project);
    }

    public MergeRequestImpl(@NotNull String left, @NotNull String base, @NotNull String right, @Nullable FileType type, @Nullable Project project) {
        this((DiffContent)new SimpleContent(left, type), (DiffContent)new SimpleContent(base, type), (DiffContent)new SimpleContent(right, type), project);
    }

    private MergeRequestImpl(@NotNull DiffContent left, @NotNull DiffContent base, @NotNull DiffContent right, @Nullable Project project) {
        super(project);
        this.myDiffContents[0] = left;
        this.myDiffContents[1] = base;
        this.myDiffContents[2] = right;
        if (LOG.isDebugEnabled()) {
            VirtualFile file2 = base.getFile();
            LOG.debug(new Throwable(base.getClass() + " - writable: " + base.getDocument().isWritable() + ", contentType: " + base.getContentType() + ", file: " + (file2 != null ? "valid - " + file2.isValid() : "null")));
        }
    }

    public DiffContent @NotNull [] getContents() {
        return this.myDiffContents;
    }

    public String[] getContentTitles() {
        return this.myVersionTitles;
    }

    public void setVersionTitles(String[] versionTitles) {
        this.myVersionTitles = versionTitles;
    }

    public String getWindowTitle() {
        return this.myWindowTitle;
    }

    public void setWindowTitle(String windowTitle) {
        this.myWindowTitle = windowTitle;
    }

    public void setResult(int result2) {
        if (result2 == 0) {
            this.applyChanges();
        }
        this.myResult = result2;
    }

    public void applyChanges() {
        MergeContent mergeContent = this.getMergeContent();
        if (mergeContent != null) {
            mergeContent.applyChanges();
        }
    }

    public int getResult() {
        return this.myResult;
    }

    @Nullable
    public MergeContent getMergeContent() {
        if (this.myDiffContents[1] instanceof MergeContent) {
            return (MergeContent)this.myDiffContents[1];
        }
        return null;
    }

    @Nullable
    public DiffContent getResultContent() {
        return this.getMergeContent();
    }

    public void restoreOriginalContent() {
        MergeContent mergeContent = this.getMergeContent();
        if (mergeContent == null) {
            return;
        }
        mergeContent.restoreOriginalContent();
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    public void setHelpId(@Nullable @NonNls String helpId) {
        this.myHelpId = helpId;
    }

    public static class MergeContent
    extends DiffContent {
        @NotNull
        private final MergeVersion myTarget;
        private final Document myWorkingDocument;
        private final Project myProject;

        public MergeContent(@NotNull MergeVersion target2, Project project) {
            this.myTarget = target2;
            this.myProject = project;
            this.myWorkingDocument = this.myTarget.createWorkingDocument(project);
            LOG.assertTrue(this.myWorkingDocument.isWritable());
        }

        public void applyChanges() {
            this.myTarget.applyText(this.myWorkingDocument.getText(), this.myProject);
        }

        public Document getDocument() {
            return this.myWorkingDocument;
        }

        public Navigatable getOpenFileDescriptor(int offset) {
            VirtualFile file2 = this.getFile();
            if (file2 == null) {
                return null;
            }
            return PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file2, offset);
        }

        public VirtualFile getFile() {
            return this.myTarget.getFile();
        }

        @Nullable
        public FileType getContentType() {
            return this.myTarget.getContentType();
        }

        public byte[] getBytes() throws IOException {
            return this.myTarget.getBytes();
        }

        public void restoreOriginalContent() {
            this.myTarget.restoreOriginalContent(this.myProject);
        }

        @NotNull
        public MergeVersion getMergeVersion() {
            return this.myTarget;
        }
    }
}

