/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.WeakList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class UndoRedoStacksHolder {
    private static final Logger LOG = Logger.getInstance(UndoRedoStacksHolder.class);
    private final Key<LinkedList<UndoableGroup>> STACK_IN_DOCUMENT_KEY = Key.create((String)"STACK_IN_DOCUMENT_KEY");
    private final boolean myUndo;
    private final LinkedList<UndoableGroup> myGlobalStack = new LinkedList();
    private final THashMap<DocumentReference, LinkedList<UndoableGroup>> myDocumentStacks = new THashMap();
    private final Collection<Document> myDocumentsWithStacks = new WeakList();
    private final Collection<VirtualFile> myNonlocalVirtualFilesWithStacks = new WeakList();

    UndoRedoStacksHolder(boolean isUndo) {
        this.myUndo = isUndo;
    }

    @NotNull
    LinkedList<UndoableGroup> getStack(@NotNull DocumentReference r) {
        return r.getFile() != null ? this.doGetStackForFile(r) : this.doGetStackForDocument(r);
    }

    @NotNull
    private LinkedList<UndoableGroup> doGetStackForFile(@NotNull DocumentReference r) {
        LinkedList result2;
        VirtualFile file2 = r.getFile();
        if (!file2.isInLocalFileSystem()) {
            result2 = this.addWeaklyTrackedEmptyStack(file2, this.myNonlocalVirtualFilesWithStacks);
        } else {
            result2 = (LinkedList)this.myDocumentStacks.get((Object)r);
            if (result2 == null) {
                result2 = new LinkedList();
                this.myDocumentStacks.put((Object)r, result2);
            }
        }
        return result2;
    }

    @NotNull
    private LinkedList<UndoableGroup> doGetStackForDocument(@NotNull DocumentReference r) {
        return this.addWeaklyTrackedEmptyStack(r.getDocument(), this.myDocumentsWithStacks);
    }

    @NotNull
    private <T extends UserDataHolder> LinkedList<UndoableGroup> addWeaklyTrackedEmptyStack(@NotNull T holder, @NotNull Collection<T> allHolders) {
        LinkedList result2 = (LinkedList)holder.getUserData(this.STACK_IN_DOCUMENT_KEY);
        if (result2 == null) {
            result2 = new LinkedList();
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, result2);
            allHolders.add(holder);
        }
        return result2;
    }

    boolean canBeUndoneOrRedone(@NotNull Collection<? extends DocumentReference> refs) {
        if (refs.isEmpty()) {
            return !this.myGlobalStack.isEmpty() && this.myGlobalStack.getLast().isValid();
        }
        for (DocumentReference documentReference : refs) {
            if (this.getStack(documentReference).isEmpty() || !this.getStack(documentReference).getLast().isValid()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    UndoableGroup getLastAction(@NotNull Collection<? extends DocumentReference> refs) {
        if (refs.isEmpty()) {
            return this.myGlobalStack.getLast();
        }
        UndoableGroup mostRecentAction = null;
        int mostRecentDocTimestamp = 0;
        for (DocumentReference documentReference : refs) {
            LinkedList<UndoableGroup> stack = this.getStack(documentReference);
            if (stack.isEmpty()) continue;
            UndoableGroup lastAction = stack.getLast();
            int timestamp = lastAction.getCommandTimestamp();
            if (mostRecentAction != null && (!lastAction.isTemporary() || mostRecentAction.isTemporary()) && (lastAction.isTemporary() != mostRecentAction.isTemporary() || !(this.myUndo ? timestamp > mostRecentDocTimestamp : timestamp < mostRecentDocTimestamp))) continue;
            mostRecentAction = lastAction;
            mostRecentDocTimestamp = timestamp;
        }
        return mostRecentAction;
    }

    @NotNull
    Set<DocumentReference> collectClashingActions(@NotNull UndoableGroup group) {
        UndoableGroup last;
        THashSet result2 = new THashSet();
        for (DocumentReference each : group.getAffectedDocuments()) {
            UndoableGroup last2 = this.getStack(each).peekLast();
            if (last2 == null || last2 == group) continue;
            result2.addAll(last2.getAffectedDocuments());
        }
        if (group.isGlobal() && (last = this.myGlobalStack.peekLast()) != null && last != group) {
            result2.addAll(last.getAffectedDocuments());
        }
        return result2;
    }

    private String getStacksDescription() {
        return this.myUndo ? "undo stacks" : "redo stacks";
    }

    void addToStacks(@NotNull UndoableGroup group) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding to " + this.getStacksDescription() + ": " + group.dumpState());
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group)) {
            if (this.myUndo && !group.isTemporary()) {
                UndoRedoStacksHolder.convertTemporaryActionsToPermanent(each);
            }
            this.doAddToStack(each, group, each == this.myGlobalStack ? UndoManagerImpl.getGlobalUndoLimit() : UndoManagerImpl.getDocumentUndoLimit());
        }
    }

    private void doAddToStack(@NotNull LinkedList<UndoableGroup> stack, @NotNull UndoableGroup group, int limit) {
        if (!group.isUndoable() && stack.isEmpty()) {
            return;
        }
        stack.add(group);
        while (stack.size() > limit) {
            this.clearStacksFrom(stack.getFirst());
        }
    }

    void removeFromStacks(@NotNull UndoableGroup group) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing from " + this.getStacksDescription() + ": " + group.dumpState());
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group)) {
            assert (each.getLast() == group);
            each.removeLast();
        }
    }

    void clearStacks(boolean clearGlobal, @NotNull Set<? extends DocumentReference> refs) {
        for (LinkedList<UndoableGroup> each2 : this.getAffectedStacks(clearGlobal, refs)) {
            while (!each2.isEmpty()) {
                this.clearStacksFrom(each2.getLast());
            }
        }
        this.myDocumentStacks.entrySet().removeIf(each -> ((LinkedList)each.getValue()).isEmpty());
        this.myDocumentStacks.compact();
        this.cleanWeaklyTrackedEmptyStacks(this.myDocumentsWithStacks);
        this.cleanWeaklyTrackedEmptyStacks(this.myNonlocalVirtualFilesWithStacks);
    }

    private static void convertTemporaryActionsToPermanent(LinkedList<? extends UndoableGroup> each) {
        UndoableGroup group1;
        for (int i2 = each.size() - 1; i2 >= 0 && (group1 = each.get(i2)).isTemporary(); --i2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Converting to permanent: " + group1);
            }
            group1.makePermanent();
        }
    }

    private <T extends UserDataHolder> void cleanWeaklyTrackedEmptyStacks(@NotNull Collection<T> stackHolders) {
        THashSet holdersToDrop = new THashSet();
        for (UserDataHolder holder : stackHolders) {
            List stack = (List)holder.getUserData(this.STACK_IN_DOCUMENT_KEY);
            if (stack == null || !stack.isEmpty()) continue;
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, null);
            holdersToDrop.add(holder);
        }
        stackHolders.removeAll((Collection<?>)holdersToDrop);
    }

    private void clearStacksFrom(@NotNull UndoableGroup from) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing " + this.getStacksDescription() + " from " + from.dumpState());
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(from)) {
            int pos = each.indexOf(from);
            if (pos == -1) continue;
            if (pos > 0) {
                int top = each.size() - pos;
                this.clearStacksFrom(each.get(pos - 1));
                assert (each.size() == top && each.indexOf(from) == 0);
            }
            each.removeFirst();
        }
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(@NotNull UndoableGroup group) {
        return this.getAffectedStacks(group.isGlobal(), group.getAffectedDocuments());
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(boolean global, @NotNull Collection<? extends DocumentReference> refs) {
        ArrayList<LinkedList<UndoableGroup>> result2 = new ArrayList<LinkedList<UndoableGroup>>(refs.size() + 1);
        if (global) {
            result2.add(this.myGlobalStack);
        }
        for (DocumentReference documentReference : refs) {
            result2.add(this.getStack(documentReference));
        }
        return result2;
    }

    void clearAllStacksInTests() {
        this.clearStacks(true, this.getAffectedDocuments());
        this.myGlobalStack.clear();
        this.myDocumentStacks.clear();
        this.myDocumentsWithStacks.clear();
        this.myNonlocalVirtualFilesWithStacks.clear();
    }

    void collectAllAffectedDocuments(@NotNull Collection<? super DocumentReference> result2) {
        for (UndoableGroup each : this.myGlobalStack) {
            result2.addAll(each.getAffectedDocuments());
        }
        this.collectLocalAffectedDocuments(result2);
    }

    private void collectLocalAffectedDocuments(@NotNull Collection<? super DocumentReference> result2) {
        result2.addAll(this.myDocumentStacks.keySet());
        DocumentReferenceManager documentReferenceManager = DocumentReferenceManager.getInstance();
        for (Document document : this.myDocumentsWithStacks) {
            result2.add((DocumentReference)documentReferenceManager.create(document));
        }
        for (VirtualFile virtualFile : this.myNonlocalVirtualFilesWithStacks) {
            result2.add((DocumentReference)documentReferenceManager.create(virtualFile));
        }
    }

    @NotNull
    private Set<DocumentReference> getAffectedDocuments() {
        THashSet result2 = new THashSet();
        this.collectAllAffectedDocuments((Collection<? super DocumentReference>)result2);
        return result2;
    }

    int getLastCommandTimestamp(@NotNull DocumentReference r) {
        LinkedList<UndoableGroup> stack = this.getStack(r);
        if (stack.isEmpty()) {
            return 0;
        }
        return Math.max(stack.getFirst().getCommandTimestamp(), stack.getLast().getCommandTimestamp());
    }

    void invalidateActionsFor(@NotNull DocumentReference ref) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invalidating actions in " + this.getStacksDescription() + " for " + ref);
        }
        for (List list2 : this.getAffectedStacks(true, Collections.singleton(ref))) {
            for (UndoableGroup eachGroup : list2) {
                eachGroup.invalidateActionsFor(ref);
            }
        }
    }
}

