/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FinishMarkAction
extends BasicUndoableAction {
    @NotNull
    private final StartMarkAction myStartAction;
    private boolean myGlobal = false;
    private String myCommandName;
    private final DocumentReference myReference;

    private FinishMarkAction(DocumentReference reference2, @NotNull StartMarkAction action2) {
        super(new DocumentReference[]{reference2});
        this.myReference = reference2;
        this.myStartAction = action2;
    }

    public void undo() {
    }

    public void redo() {
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this.myStartAction.setGlobal(isGlobal);
        this.myGlobal = isGlobal;
    }

    public void setCommandName(String commandName) {
        this.myStartAction.setCommandName(commandName);
        this.myCommandName = commandName;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public DocumentReference getAffectedDocument() {
        return this.myReference;
    }

    public static void finish(Project project, Editor editor, @Nullable StartMarkAction startAction) {
        if (startAction == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            DocumentReference reference2 = DocumentReferenceManager.getInstance().create(editor.getDocument());
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new FinishMarkAction(reference2, startAction));
            StartMarkAction.markFinished(project);
        }, IdeBundle.message((String)"command.finish", (Object[])new Object[0]), null);
    }
}

