/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DecodeDefaultsUtil {
    private static final Logger LOG = Logger.getInstance(DecodeDefaultsUtil.class);
    private static final Map<String, URL> RESOURCE_CACHE = Collections.synchronizedMap(new THashMap());

    public static URL getDefaults(Object requestor, @NotNull String componentResourcePath) {
        URL url = RESOURCE_CACHE.get(componentResourcePath);
        if (url == null) {
            if (StringUtil.startsWithChar((CharSequence)componentResourcePath, (char)'/')) {
                url = DecodeDefaultsUtil.getResource(DecodeDefaultsUtil.appendExt(componentResourcePath), requestor);
                if (url == null && !(requestor instanceof UrlClassLoader)) {
                    url = DecodeDefaultsUtil.getResource(DecodeDefaultsUtil.appendExt(componentResourcePath.substring(1)), requestor);
                }
            } else {
                url = DecodeDefaultsUtil.getResource(DecodeDefaultsUtil.appendExt("/idea/" + componentResourcePath), requestor);
                if (url == null) {
                    url = requestor instanceof ClassLoader ? DecodeDefaultsUtil.getResource(DecodeDefaultsUtil.appendExt(componentResourcePath), requestor) : DecodeDefaultsUtil.getResource(DecodeDefaultsUtil.appendExt('/' + componentResourcePath), requestor);
                }
            }
            RESOURCE_CACHE.put(componentResourcePath, url);
        }
        return url;
    }

    private static URL getResource(String path, Object requestor) {
        if (requestor instanceof ClassLoader) {
            return ((ClassLoader)requestor).getResource(path);
        }
        return requestor.getClass().getResource(path);
    }

    private static String appendExt(@NotNull String s) {
        return DecodeDefaultsUtil.appendIfNeeded(s, ".xml");
    }

    private static String appendIfNeeded(@NotNull String head, @NotNull String tail) {
        return head.endsWith(tail) ? head : head + tail;
    }

    @Nullable
    public static InputStream getDefaultsInputStream(Object requestor, @NotNull String componentResourcePath) {
        try {
            URL defaults = DecodeDefaultsUtil.getDefaults(requestor, componentResourcePath);
            return defaults == null ? null : URLUtil.openStream((URL)defaults);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

